# Transcription Context Template

Use this template to create context files that improve transcription accuracy.
Place this file (or your customized version) in the same directory as your audio/video files.

---

## Meeting/Recording Information

- **Date**: [YYYY-MM-DD]
- **Type**: [Meeting / Interview / Presentation / Podcast / etc.]
- **Topic**: [Brief description of what was discussed]

## Speakers

List all participants with their full names and roles:

- [Full Name] - [Role/Title]
- [Full Name] - [Role/Title]
- [Full Name] - [Role/Title]

## Technical Terms

Domain-specific vocabulary that may be misrecognized:

### Products & Services
- [Product Name] - [Brief description]
- [Service Name] - [Brief description]

### Technologies
- Kubernetes - container orchestration platform
- Docker - containerization tool
- FastAPI - Python web framework
- PostgreSQL - relational database
- Redis - in-memory data store
- Terraform - infrastructure as code
- Pulumi - infrastructure as code
- AlloyDB - Google Cloud database
- Cloud Run - serverless container platform

### Frameworks & Libraries
- React - JavaScript UI library
- Vue.js - JavaScript framework
- Next.js - React framework
- Django - Python web framework
- Flask - Python micro framework

## Acronyms & Abbreviations

| Acronym | Expansion |
|---------|-----------|
| API | Application Programming Interface |
| CI/CD | Continuous Integration/Continuous Deployment |
| PR | Pull Request |
| MR | Merge Request |
| K8s | Kubernetes |
| GCP | Google Cloud Platform |
| AWS | Amazon Web Services |
| VM | Virtual Machine |
| VPC | Virtual Private Cloud |
| IAM | Identity and Access Management |
| JWT | JSON Web Token |
| OAuth | Open Authorization |
| REST | Representational State Transfer |
| SQL | Structured Query Language |
| ORM | Object-Relational Mapping |

## Organizations & Teams

- [Company Name]
- [Department Name]
- [Team Name]
- [Partner Organization]

## Projects & Codenames

- [Project Name] - [Brief description]
- [Feature Codename] - [What it refers to]

## Proper Nouns

### Locations
- [Office Location]
- [City Names]
- [Building Names]

### Events
- [Conference Names]
- [Meeting Series Names]

## Common Phrases

Phrases frequently used in your domain:

- "[Specific phrase or jargon]"
- "[Another common phrase]"

---

## Usage Notes

1. **Keep this file updated** - Add new terms as they come up
2. **Be specific** - Include exact spellings, especially for unusual names
3. **Include context** - Brief descriptions help with disambiguation
4. **Multiple files OK** - You can have separate files for different contexts:
   - `team-members.md` - Just names and roles
   - `tech-glossary.md` - Technical terminology
   - `project-context.md` - Current project details
