# Keynote deck generator (end-to-end)

```javascript
const Keynote = Application("Keynote");
Keynote.activate();
const doc = Keynote.Document({ documentTheme: Keynote.themes["White"], width: 1920, height: 1080 }).make();

function addTitleSlide(title, subtitle) {
  const master = doc.masterSlides["Title & Subtitle"];
  const slide = Keynote.Slide({ baseSlide: master });
  doc.slides.push(slide);
  slide.defaultTitleItem().objectText = title;
  slide.defaultBodyItem().objectText = subtitle;
}

function addBulletsSlide(title, bullets) {
  const master = doc.masterSlides["Title & Bullets"];
  const slide = Keynote.Slide({ baseSlide: master });
  doc.slides.push(slide);
  slide.defaultTitleItem().objectText = title;
  slide.defaultBodyItem().objectText = bullets.join("\n");
}

addTitleSlide("Quarterly Report", "Generated by JXA");
addBulletsSlide("Highlights", ["Revenue +12%", "Margins stable", "New markets opened"]);

doc.export({ to: Path("/Users/you/Desktop/report.pdf"), as: "PDF" });
```

Notes:
- Master slide names are theme-dependent; validate first.
- For .key output, save the document instead of export.

