# PowerPoint deck generator (end-to-end)

```javascript
const ppt = Application("Microsoft PowerPoint");
ppt.includeStandardAdditions = true;
ppt.activate();

const deck = ppt.make({ new: "presentation" });
const master = deck.slideMasters[0];
const titleLayout = master.customLayouts.byName("Title Slide");
const contentLayout = master.customLayouts.byName("Title and Content");

function addTitleSlide(title, subtitle) {
  const slide = ppt.make({ new: "slide", at: deck.slides.end, withProperties: { customLayout: titleLayout } });
  slide.shapes[0].textFrame.textRange.content = title;
  slide.shapes[1].textFrame.textRange.content = subtitle;
}

function addBulletsSlide(title, bullets) {
  const slide = ppt.make({ new: "slide", at: deck.slides.end, withProperties: { customLayout: contentLayout } });
  slide.shapes[0].textFrame.textRange.content = title;
  slide.shapes[1].textFrame.textRange.content = bullets.join("\n");
}

addTitleSlide("Quarterly Report", "Generated by JXA");
addBulletsSlide("Highlights", ["Revenue +12%", "Margins stable", "New markets opened"]);

const out = "/Users/you/Desktop/report.pptx";
deck.save({ in: out, as: 24 }); // PPTX
```

Notes:
- Layout names are theme-dependent; verify in Script Editor.
- Shapes index positions depend on the layout.

