# Attribution Guidelines

## About This Template

**ICE/CBP Monitoring Template**
**Created by:** Andrew Thrasher
**Organization:** Titus Consulting (tituslegaldesign.com)
**LinkedIn:** [linkedin.com/in/andrewmthrasher](https://linkedin.com/in/andrewmthrasher)
**Version:** 1.0
**Release Date:** October 2025
**License:** MIT License

## Using This Template

This template is provided under the MIT License, which means you are free to:
- Use it for any purpose (personal, organizational, commercial)
- Modify it to fit your needs
- Distribute your customized versions
- Create derivative works

**No attribution is legally required under the MIT License**, but attribution is greatly appreciated and helps this work reach more communities.

## Recommended Attribution

### If You're Using This Template

**Minimal Attribution:**
```markdown
Based on the ICE/CBP Monitoring Template by Andrew Thrasher (Titus Consulting)
```

**Preferred Attribution:**
```markdown
This monitoring system uses the ICE/CBP Monitoring Template created by
Andrew Thrasher of Titus Consulting (tituslegaldesign.com).
Template licensed under MIT License.
```

**With Link:**
```markdown
Powered by the [ICE/CBP Monitoring Template](https://github.com/[USERNAME]/ice-cbp-monitoring-template)
by Andrew Thrasher / Titus Consulting
```

### If You're Sharing Your Customization

When sharing your customized version with others:

**In README.md:**
```markdown
## Credits

**Original Template:** ICE/CBP Monitoring Template
**Template Creator:** Andrew Thrasher, Titus Consulting
**Template License:** MIT
**Template URL:** [link if available]

**Customized for:** [Your City/Organization]
**Customized by:** [Your Name/Organization]
**Customization Date:** [Date]
```

**In File Headers:**
```markdown
---
Based on: ICE/CBP Monitoring Template v1.0
Original: Andrew Thrasher / Titus Consulting
Customized: [Your modifications]
---
```

## Where to Include Attribution

### Recommended Locations:

1. **README.md** - In the "Credits" or "About" section
2. **SKILL.md** - Optional footer note
3. **Documentation** - If you create derivative documentation
4. **Website/App** - If you build tools using this template
5. **Publications** - If you write about using this system
6. **Presentations** - If you present about your monitoring work

### Not Required But Appreciated:

- Social media posts about your customization
- Blog posts about implementation
- Academic papers using this methodology
- Community presentations
- Training materials

## Modifying the Template

### You May:
- Add, remove, or modify any features
- Adapt for your specific location and needs
- Translate to other languages
- Integrate with your own tools
- Create commercial products based on this
- Rebrand completely for your organization

### We Appreciate:
- Sharing improvements back to the community
- Noting what worked well in your context
- Reporting bugs or unclear documentation
- Suggesting enhancements

## Contributing Back

If you make improvements that could benefit others:

1. **Share Documentation:** Describe what you changed and why
2. **Contribute Examples:** Add your use cases to community knowledge
3. **Submit PRs:** Propose changes to the original template
4. **Support Others:** Help newcomers in discussions/issues

See [CONTRIBUTING.md](CONTRIBUTING.md) for details.

**Community safety comes first.** The MIT License gives you full freedom to make these decisions.

### If You're Providing Professional Services:

If you're customizing this template as a paid service:
- You may charge for your customization services
- Attribution to the original template is appreciated but not required
- Consider how attribution benefits your clients vs. the broader community
- You may add your own branding and credits

### If You're Creating Derivative Templates:

If you create a new template based on this one:
- You may license your derivative under any terms
- Note the original template in your documentation
- Differentiate your enhancements clearly
- Consider contributing improvements back

## Contact & Permissions

### For Questions About Attribution:
- LinkedIn: [linkedin.com/in/andrewmthrasher](https://linkedin.com/in/andrewmthrasher)
- Website: [tituslegaldesign.com](https://tituslegaldesign.com)

### Need Custom Permissions?
The MIT License already grants broad permissions. However, if you have specific questions or need explicit written permission for organizational policies, please reach out.

### Want to Highlight Your Use?
We'd love to know how you're using this template! Share your story (maintaining appropriate privacy) so others can learn from your experience.

## FAQ

**Q: Do I have to attribute if I only use this internally?**
A: No, attribution is never legally required under MIT License. It's always appreciated though!

**Q: Can I remove all references to the original creator?**
A: Yes, legally you can. We hope you'll keep some attribution to help others find this resource, but it's your choice.

**Q: Can I claim I created this template?**
A: That would be misleading and against community norms, even if not illegal. Please be honest about the origins while highlighting your customizations.

**Q: Can I use the Titus Consulting name or logo?**
A: No, the MIT License does not grant trademark rights. You may reference Titus Consulting in attribution but cannot imply endorsement or use our branding.

**Q: What if my organization requires different licensing?**
A: You're free to relicense your modified version, but please note the original template's MIT License for compliance.

**Q: Can I sell this template or derived products?**
A: Yes, the MIT License permits commercial use. Attribution is appreciated but not required.

## Version History

- **v1.0 (October 2025):** Initial release with MIT License

---

## Thank You

Thank you for considering attribution! Every mention helps more communities discover this tool and supports the creation of more open-source resources for social justice and accountability work.

**The goal is getting this tool into the hands of communities that need it, however that works best for you.**

---

**License:** This ATTRIBUTION.md file itself is released under CC0 (public domain). You may use these attribution examples without any restrictions.
