# Code of Conduct

## Our Pledge

We as members, contributors, and leaders pledge to make participation in this project a harassment-free experience for everyone, regardless of age, body size, visible or invisible disability, ethnicity, sex characteristics, gender identity and expression, level of experience, education, socio-economic status, nationality, personal appearance, race, caste, color, religion, or sexual identity and orientation.

We pledge to act and interact in ways that contribute to an open, welcoming, diverse, inclusive, and healthy community focused on supporting immigration accountability and community safety.

## Our Standards

### Examples of Behavior That Contributes to a Positive Environment

- Using welcoming and inclusive language
- Being respectful of differing viewpoints and experiences
- Gracefully accepting constructive criticism
- Focusing on what is best for the community
- Showing empathy towards other community members
- Prioritizing community safety and privacy
- Supporting collaborative documentation efforts
- Sharing knowledge and resources generously
- Respecting the sensitive nature of this work

### Examples of Unacceptable Behavior

- The use of sexualized language or imagery, and sexual attention or advances of any kind
- Trolling, insulting or derogatory comments, and personal or political attacks
- Public or private harassment
- Publishing others' private information, such as addresses, physical location details, or identifying information without explicit permission
- Sharing sensitive community organizing information publicly
- Misusing this tool for surveillance, harassment, or harmful purposes
- Conducting activities that endanger community members
- Other conduct which could reasonably be considered inappropriate in a professional setting

## Project-Specific Standards

Given the sensitive nature of immigration enforcement documentation:

### Privacy and Safety First

- **Never share** personally identifiable information about community members
- **Always anonymize** examples and case studies
- **Coordinate** with affected communities before public sharing
- **Respect** organizational security practices
- **Consider** the safety implications of all contributions

### Responsible Documentation

- Maintain accuracy and verification standards
- Distinguish between confirmed and alleged information
- Respect source attribution requirements
- Follow ethical journalism and research practices
- Coordinate with legal and advocacy professionals when appropriate

### Community-Centered Approach

- Center the needs of affected communities
- Defer to community organizations on sensitive matters
- Support grassroots documentation efforts
- Recognize power dynamics in immigration enforcement
- Work collaboratively across organizations

## Enforcement Responsibilities

Project maintainers are responsible for clarifying and enforcing our standards of acceptable behavior and will take appropriate and fair corrective action in response to any behavior that they deem inappropriate, threatening, offensive, or harmful.

Project maintainers have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, and will communicate reasons for moderation decisions when appropriate.

## Scope

This Code of Conduct applies within all project spaces, and also applies when an individual is officially representing the project in public spaces. Examples of representing the project include using an official project e-mail address, posting via an official social media account, or acting as an appointed representative at an online or offline event.

## Reporting Issues

### Non-Emergency Issues

If you experience or witness unacceptable behavior, or have concerns about project conduct:

1. **Document** what happened (if safe to do so)
2. **Report** to project maintainers at [contact email - TO BE ADDED]
3. **Include** relevant details: what, when, where, who (if applicable)

All complaints will be reviewed and investigated promptly and fairly. Project maintainers are obligated to respect the privacy and security of the reporter.

### Community Safety Concerns

If a contribution or activity creates safety concerns for community members:

1. **Contact** project maintainers immediately
2. **Do not** engage publicly if it increases risk
3. **Coordinate** with relevant community organizations
4. **Document** concerns privately

We will prioritize community safety in our response.

## Enforcement Guidelines

Project maintainers will follow these Community Impact Guidelines in determining the consequences for any action they deem in violation of this Code of Conduct:

### 1. Correction

**Community Impact**: Use of inappropriate language or other behavior deemed unprofessional or unwelcome.

**Consequence**: A private, written warning from project maintainers, providing clarity around the nature of the violation and an explanation of why the behavior was inappropriate. A public apology may be requested.

### 2. Warning

**Community Impact**: A violation through a single incident or series of actions.

**Consequence**: A warning with consequences for continued behavior. No interaction with the people involved, including unsolicited interaction with those enforcing the Code of Conduct, for a specified period of time. This includes avoiding interactions in community spaces as well as external channels like social media. Violating these terms may lead to a temporary or permanent ban.

### 3. Temporary Ban

**Community Impact**: A serious violation of community standards, including sustained inappropriate behavior.

**Consequence**: A temporary ban from any sort of interaction or public communication with the community for a specified period of time. No public or private interaction with the people involved, including unsolicited interaction with those enforcing the Code of Conduct, is allowed during this period. Violating these terms may lead to a permanent ban.

### 4. Permanent Ban

**Community Impact**: Demonstrating a pattern of violation of community standards, including sustained inappropriate behavior, harassment of an individual, or aggression toward or disparagement of classes of individuals.

**Consequence**: A permanent ban from any sort of public interaction within the community.

### 5. Immediate Removal (Project-Specific)

**Community Impact**: Actions that endanger community members, violate privacy, or misuse this tool for harmful surveillance or enforcement purposes.

**Consequence**: Immediate removal from the project and reporting to relevant authorities/organizations as appropriate. This includes violations such as:
- Sharing identifying information without consent
- Using the tool to aid enforcement activities
- Coordinating harassment or surveillance
- Violating organizational security practices

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant](https://www.contributor-covenant.org), version 2.1, available at [https://www.contributor-covenant.org/version/2/1/code_of_conduct.html](https://www.contributor-covenant.org/version/2/1/code_of_conduct.html).

Community Impact Guidelines were inspired by [Mozilla's code of conduct enforcement ladder](https://github.com/mozilla/diversity).

Additional provisions specific to immigration enforcement documentation were added to address the unique ethical and safety considerations of this project.

## Contact

For questions about this Code of Conduct:
- Open a Discussion in the project repository
- Contact project maintainers at: [TO BE ADDED]
- For urgent safety concerns: coordinate with relevant community organizations

---

**Remember**: This project exists to support community documentation, legal accountability, and immigrant rights. All interactions should reflect these values and prioritize community safety.
