# Quick Start Guide

**Get up and running in 30 minutes**

---

## Step 1: Read the Customization Guide (5 minutes)

Open `CUSTOMIZATION_GUIDE.md` and review:
- What information you need to gather
- What files need to be edited
- What the placeholders mean

**Don't skip this!** The template won't work without customization.

---

## Step 2: Gather Local Information (10 minutes)

Make a list of:

### Must-Have:
- [ ] Your city name
- [ ] Your state name
- [ ] 3-5 local news sources
- [ ] 2-3 local immigrant rights organizations
- [ ] Local rapid response networks (if any)

### Nice-to-Have:
- [ ] Your federal court district
- [ ] Common local neighborhoods
- [ ] Named operation (if applicable)
- [ ] Local hotline numbers

---

## Step 3: Basic Customization (10 minutes)

### In `SKILL.md`:
1. Find and replace `[CITY_NAME]` → your city
2. Find and replace `[STATE_NAME]` → your state
3. Update the "Key Sources to Monitor" section (lines ~99-122)
4. Update "Contact Resources" at the bottom

### In `README.md`:
1. Find and replace `[CITY_NAME]` → your city
2. Find and replace `[STATE_NAME]` → your state
3. Update the example table (lines ~66-81) with local info
4. Update "Source Coverage" section (lines ~99-105)

---

## Step 4: Test Upload (5 minutes)

1. **Zip your folder:**
   - Name it: `ice-cbp-[yourcity]-monitoring.zip`
   - Include all files

2. **Upload to Claude:**
   - Go to claude.ai
   - Settings → Skills
   - Upload your zip file

3. **Test with:**
   ```
   "Run daily ICE monitoring for [YOUR_CITY] - last 24 hours"
   ```

4. **Verify Claude:**
   - Uses your city name
   - References your local sources
   - Provides appropriate suggestions

---

## You're Ready!

**If the test worked:** You're good to go! Start daily monitoring.

**If the test didn't work:** See troubleshooting in `CUSTOMIZATION_GUIDE.md`

---

## What to Do Next

### Week 1: Get Comfortable
- Run daily monitoring every day
- Practice extracting from different source types
- Learn the data fields

### Week 2: Expand
- Add weekly deep dive (Sundays)
- Start tracking patterns
- Refine your local sources list

### Week 3: Optimize
- Create your own prompt shortcuts
- Build a local examples library
- Connect with community organizations

---

## Most Important Tips

1. **Search Daily** - Consistency is key
2. **Verify Sources** - Cross-check when possible
3. **Document Everything** - Even "no activity" is data
4. **Quality Over Speed** - Accurate is better than fast
5. **Share Safely** - Coordinate with local organizations

---

## Need Help?

See the full `CUSTOMIZATION_GUIDE.md` for:
- Detailed instructions
- Troubleshooting
- Advanced features
- Best practices

---

**Ready? Start with "Run daily ICE monitoring for [YOUR_CITY]"**
