# Search Strategies for ICE/CBP Activity Monitoring

**Template Version** - Customize for your location using the patterns below.

---

## Overview

This document provides a comprehensive library of search queries and strategies for monitoring ICE and CBP enforcement activity in [CITY_NAME], [STATE_NAME]. Adapt these patterns to your local context.

## Daily Search Routine (15 Minutes)

### Core Queries (Run Every Day)

**General ICE Activity:**
```
ICE [CITY_NAME] arrest today
ICE [CITY_NAME] operation [current date]
immigration enforcement [CITY_NAME] today
CBP [CITY_NAME]
[IF_APPLICABLE: [OPERATION_NAME] [CITY_NAME]]
federal agents [CITY_NAME] immigration
```

**Time-Bounded Searches:**
```
ICE [CITY_NAME] last 24 hours
immigration raid [CITY_NAME] yesterday
ICE activity [CITY_NAME] this week
```

**Agency-Specific:**
```
"ICE ERO" [CITY_NAME]
"Enforcement and Removal Operations" [CITY_NAME]
"Border Patrol" [CITY_NAME]
"CBP" [CITY_NAME] immigration
```

### Site-Specific Searches

**Local News Outlets:**
[CUSTOMIZE with your sources]
```
site:[LOCAL_NEWS_1].com ICE
site:[LOCAL_NEWS_2].org immigration [CITY_NAME]
site:[LOCAL_TV_STATION].com ICE arrest
site:[PUBLIC_RADIO].org immigration enforcement
site:[COMMUNITY_NEWS].com ICE
```

**Example patterns:**
- `site:blockclubchicago.org ICE` (hyperlocal news)
- `site:wbez.org immigration Chicago` (public radio)
- `site:cbsnews.com/chicago ICE` (TV news)

**National News with Local Focus:**
```
site:nytimes.com ICE [CITY_NAME]
site:washingtonpost.com immigration [CITY_NAME]
site:reuters.com ICE [STATE_NAME]
site:apnews.com immigration [CITY_NAME]
```

### Social Media Searches

**Twitter/X:**
```
ICE [CITY_NAME] (from:today)
immigration enforcement [CITY_NAME]
#ICERaid #[CITY_NAME]
"federal agents" [CITY_NAME] detention
@[LOCAL_RAPID_RESPONSE_1] [search latest tweets]
```

**Instagram:**
```
[Search hashtags]: #[CityName]Immigration #ICE[CityName]
[Check accounts]: @[local_rapid_response_networks]
[Search location tags]: [City Name] + immigration keywords
```

**Facebook:**
```
[Search in relevant groups]:
- "[CITY] Immigration Support"
- "[CITY] Rapid Response"
- "[CITY] Community Safety"
```

**Telegram (if used locally):**
```
[Check channels]: [Local alert channels]
[Search in groups]: Immigration + [City]
```

## Neighborhood-Specific Searches

[CUSTOMIZE with your local neighborhoods and demographics]

### High-Activity Neighborhoods

**[NEIGHBORHOOD_1] (Known for [community characteristics]):**
```
ICE [NEIGHBORHOOD_1] [CITY_NAME]
immigration raid [NEIGHBORHOOD_1]
federal agents [NEIGHBORHOOD_1]
[ZIP_CODE_1] ICE activity
```

**[NEIGHBORHOOD_2]:**
```
ICE [NEIGHBORHOOD_2] [CITY_NAME]
immigration enforcement [NEIGHBORHOOD_2]
[STREET_NAME_1 in neighborhood] federal agents
```

**[NEIGHBORHOOD_3]:**
```
[Similar pattern for each neighborhood]
```

### Business District Searches

**[BUSINESS_DISTRICT]:**
```
ICE raid [BUSINESS_DISTRICT]
workplace raid [CITY_NAME]
business inspection ICE [CITY_NAME]
[MAJOR_EMPLOYER_AREA] immigration
```

### Residential Area Searches

**[RESIDENTIAL_AREA_1]:**
```
ICE home raid [CITY_NAME]
residential enforcement [NEIGHBORHOOD]
[APARTMENT_COMPLEX_NAME] ICE (if relevant)
```

## Weekly Deep Dive Queries

### Comprehensive News Review

**All Major Outlets (Run Sunday):**
```
[For each local source]:
site:[source].com ICE [date range]
site:[source].com immigration [date range]
site:[source].com "federal agents" [date range]
```

**Date Range Syntax:**
- Google: Use "Tools" → "Custom range"
- Example: Past 7 days, Past month

### Court and Legal Searches

**PACER (Federal Court):**
```
[Log into PACER for your district]
Party name search: "Immigration and Customs Enforcement"
Party name search: "Customs and Border Protection"
Case type: Civil Rights, Habeas Corpus
Date range: Past 7 days
```

**State/County Courts:**
```
[LOCAL_COUNTY] court immigration
[COUNTY] jail ICE holds
immigration detainer [COUNTY]
```

**Legal Organization Reports:**
```
site:[LOCAL_LEGAL_AID].org ICE report
site:[ACLU_LOCAL].org immigration enforcement
site:[IMMIGRANT_RIGHTS_ORG].org [CITY_NAME] ICE
```

### Community Organization Monitoring

**Key Organizations:**
[CUSTOMIZE with your local orgs]
```
site:[ORG_1].org ICE activity
site:[ORG_2].org immigration enforcement report
site:[ORG_3].org [CITY_NAME] update
```

**Check these sections:**
- News/Press releases
- Community alerts
- Reports/Publications
- Social media feeds

### Pattern Analysis Searches

**Vehicle Descriptions:**
```
"black SUV" ICE [CITY_NAME]
"white van" federal agents [CITY_NAME]
"unmarked vehicle" immigration [CITY_NAME]
[KNOWN_PLATE_NUMBER] ICE
```

**Location Patterns:**
```
[REPEATED_LOCATION] ICE multiple
[INTERSECTION] federal agents history
[LANDMARK] immigration enforcement
```

**Temporal Patterns:**
```
ICE early morning [CITY_NAME]
immigration raid 6am [CITY_NAME]
[DAY_OF_WEEK] ICE activity [CITY_NAME]
```

## Special Event Monitoring

### Court Days

**Immigration Court Locations:**
```
[COURT_ADDRESS] ICE presence
[COURT_BUILDING_NAME] federal agents
immigration court [CITY_NAME] enforcement
```

**Search on court hearing days:**
- Early morning (before hearings)
- Midday (during lunch)
- End of day (after hearings)

### Community Events

**Large Gatherings:**
```
[EVENT_NAME] ICE presence
[FESTIVAL_NAME] immigration enforcement
[LOCATION] security federal agents
```

**Religious Sites:**
```
[CHURCH_NAME] ICE activity
[MOSQUE_NAME] federal agents
faith community immigration [CITY_NAME]
```

### School Proximity

**Near Schools:**
```
school ICE [CITY_NAME]
[SCHOOL_NAME] federal agents
education institution immigration [CITY_NAME]
```

## Advanced Search Techniques

### Boolean Operators

**AND (all terms must appear):**
```
ICE AND [CITY_NAME] AND detention
```

**OR (any term can appear):**
```
ICE OR "federal agents" OR "immigration enforcement"
```

**NOT (exclude terms):**
```
ICE [CITY_NAME] -job -hiring -careers
(Excludes job postings)
```

**Phrase Search:**
```
"Operation [NAME]" [CITY]
"community alert" [NEIGHBORHOOD]
```

### Proximity Searches

**Google (AROUND operator):**
```
ICE AROUND(5) [NEIGHBORHOOD]
detention AROUND(3) [CITY_NAME]
```

### Wildcard Searches

**Asterisk for unknown words:**
```
ICE * raid [CITY]
federal * enforcement [CITY]
```

### Date-Specific Searches

**Exact Date:**
```
ICE [CITY_NAME] 10/13/2025
```

**Date Range:**
```
ICE [CITY_NAME] after:2025-10-01 before:2025-10-31
```

## Source-Type Specific Strategies

### News Articles

**Local Coverage:**
- Check each local outlet daily
- Set up Google Alerts (see below)
- Subscribe to RSS feeds if available
- Follow reporters who cover immigration

**Useful Search Modifiers:**
```
site:[news-site].com ICE intitle:[CITY]
site:[news-site].com filetype:pdf immigration report
```

### Video Content

**YouTube:**
```
ICE [CITY_NAME] recent
immigration raid [CITY_NAME] video
[CITY] federal agents footage
```

**TikTok:**
```
#ICE[CITY]
#Immigration[CITY]
[Search location]: [City]
```

**Local TV News Archives:**
```
site:[tv-station].com video ICE [CITY]
```

### Government Sources

**ICE Press Releases:**
```
site:ice.gov [STATE_NAME]
site:ice.gov [CITY_NAME]
site:ice.gov "ERO [NEAREST_FIELD_OFFICE]"
```

**CBP Press:**
```
site:cbp.gov [STATE_NAME]
site:cbp.gov [REGION]
```

**State/Local Government:**
```
site:[state].gov immigration enforcement
site:[city].gov ICE cooperation
[MAYOR_NAME] ICE statement
```

## Automated Monitoring Setup

### Google Alerts

**Recommended Alerts:**
[Set up at google.com/alerts]

1. `ICE [CITY_NAME]`
2. `immigration enforcement [CITY_NAME]`
3. `[OPERATION_NAME]` (if applicable)
4. `federal agents [CITY_NAME] detention`
5. `[LOCAL_RAPID_RESPONSE_ORG] alert`

**Alert Settings:**
- Frequency: As-it-happens or Once a day
- Sources: Automatic or News
- Language: All languages (for bilingual communities)
- Region: [Your country/region]
- Deliver to: [Your email]

### RSS Feeds

**If news sources offer RSS:**
```
[news-site].com/rss/immigration
[news-site].com/feed?tag=ICE
```

**Use RSS reader:**
- Feedly, Inoreader, or similar
- Create folder: "ICE Monitoring [CITY]"

### Social Media Monitoring

**Twitter Lists:**
1. Create list: "ICE Monitoring [CITY]"
2. Add:
   - Local rapid response networks
   - Local news immigration reporters
   - Community organizations
   - Legal aid groups
   - Advocates/activists

**Instagram Following:**
- [Local rapid response accounts]
- [Community organizations]
- [Immigration lawyers]
- Set notifications to "All Posts"

## Verification Strategies

### Cross-Reference Searches

When you find a potential incident:

**Verify with multiple sources:**
```
[LOCATION] + [DATE] + ICE
[LOCATION] + [DATE] + federal agents
[NEIGHBORHOOD] + [DATE] + immigration
```

**Check all platforms:**
1. Twitter/X search
2. Instagram location tags
3. Facebook community groups
4. Local news sites
5. Rapid response networks

### Reverse Image Search

**If you find an image/video:**
1. Google Image Search
2. TinEye reverse search
3. Check image metadata (date, location)

**Verify:**
- Is image from your city?
- Is date recent?
- Has image been used before?

### Geolocation Verification

**Verify locations using:**
1. Google Maps Street View
2. Landmark identification
3. Street sign confirmation
4. Business verification
5. Local knowledge

## Search Quality Tips

### DO:
✅ Search daily (morning + evening minimum)
✅ Use multiple search terms
✅ Check multiple platforms
✅ Verify with multiple sources
✅ Note search date and time
✅ Document null results (nothing found)
✅ Adjust queries based on results
✅ Learn local terminology

### DON'T:
❌ Rely on single source
❌ Skip days during monitoring periods
❌ Ignore non-English sources
❌ Accept first result without verification
❌ Search only one platform
❌ Forget to check community sources
❌ Overlook patterns in null results

## Troubleshooting

### "I'm not finding anything"

**Possible reasons:**
1. No activity (good!)
2. Activity not yet reported
3. Wrong search terms
4. Sources not publishing
5. Delayed reporting

**Solutions:**
- Expand to regional searches
- Check if sources are active
- Try alternative terms
- Wait 24-48 hours for news cycle
- Check social media more frequently

### "Too many irrelevant results"

**Solutions:**
- Add negative keywords: `-job -hiring`
- Use phrase search: "ICE raid"
- Add location: `[CITY_NAME]`
- Use site-specific searches
- Narrow date range

### "Sources are in language I don't speak"

**Solutions:**
- Use Google Translate on web pages
- Use browser auto-translate
- Partner with bilingual volunteers
- Focus on visual content (images/videos)
- Document and seek translation help

## Search Schedule Templates

### Minimal (Weekly Only)
**Sunday, 60 minutes:**
- All core queries (30 min)
- Site-specific searches (15 min)
- Community org check (15 min)

### Moderate (3x per week)
**Monday/Wednesday/Friday, 20 minutes each:**
- Core queries (10 min)
- Top 3 news sites (5 min)
- Social media (5 min)

### Intensive (Daily)
**Every morning (15 min):**
- Core queries
- Top news sites
- Social media check

**Every evening (15 min):**
- Same as morning
- Verify any morning findings

**Sunday (60 min):**
- Full deep dive
- Weekly pattern analysis

## Custom Query Development

### Build Your Own Queries

**Formula:**
```
[TOPIC] + [LOCATION] + [TIME] + [SOURCE_FILTER]
```

**Examples:**
```
ICE + [NEIGHBORHOOD] + today + site:[news].com
federal agents + [STREET_NAME] + yesterday
detention + [CITY] + this week + site:instagram.com
```

### Test and Refine

1. **Run query**
2. **Review results** - Relevant? Useful?
3. **Adjust** - Add/remove terms
4. **Document** - Save effective queries
5. **Share** - Help others in your community

---

## Query Library Template

**Save your most effective queries:**

```
[QUERY_NAME]
Query: [actual search terms]
Platform: [where to run it]
Frequency: [how often]
Notes: [why it's useful]

Example:
Early Morning Activity Check
Query: ICE [CITY_NAME] 6am OR 7am OR "early morning"
Platform: Twitter, Google News
Frequency: Daily at 9am
Notes: Catches reports of dawn raids
```

---

## Location-Specific Customization

[CUSTOMIZE based on your geography]

### Border Region Adjustments
- Add: checkpoint searches
- Add: port of entry monitoring  
- Add: desert area searches
- Include: rescue operation news

### Interior Location Adjustments
- Focus: home raids
- Focus: courthouse enforcement
- Focus: workplace raids
- Focus: transportation hubs

### Urban vs. Rural
**Urban:**
- Neighborhood-specific searches
- Public transit monitoring
- Dense housing searches

**Rural:**
- County-wide searches
- Agricultural work site monitoring
- Wider geographic net

---

**Remember:** Search strategies should evolve based on what you find. Document your most effective queries and share them with your community!

---

## Appendix: Search Operators Reference

### Google Search Operators
- `site:` - Search specific website
- `"phrase"` - Exact phrase
- `-term` - Exclude term
- `OR` - Either term
- `*` - Wildcard
- `after:YYYY-MM-DD` - After date
- `before:YYYY-MM-DD` - Before date
- `intitle:` - Term in title
- `inurl:` - Term in URL
- `filetype:` - Specific file type
- `related:` - Related sites

### Social Media
**Twitter/X:**
- `from:user` - From specific account
- `to:user` - To specific account
- `since:YYYY-MM-DD` - After date
- `until:YYYY-MM-DD` - Before date
- `filter:links` - Contains links
- `filter:media` - Contains media

**Instagram:**
- Location tags
- Hashtag combinations
- Account searches
- Saved searches

---

**Template Version 1.0** - Customize for your location and needs!
