# Critical Thinking Framework

## Argument Quality Assessment

### Evidence Evaluation Matrix

| Evidence Type | Strength | Red Flags |
|--------------|----------|-----------|
| Peer-reviewed research | High | Sample size, conflicts of interest |
| Original data | High | Collection methodology, bias |
| Expert consensus | Medium-High | Field consensus vs. single expert |
| Case studies | Medium | Selection bias, generalizability |
| Anecdotes | Low | Not representative |
| "Studies show..." (no citation) | Very Low | Vague, unverifiable |

### Logical Fallacy Checklist

**Causal Fallacies:**
- [ ] Post hoc (A before B ≠ A caused B)
- [ ] Correlation ≠ Causation
- [ ] Oversimplified cause (single factor explains complex phenomenon)

**Evidence Fallacies:**
- [ ] Cherry-picking (selective evidence)
- [ ] Survivorship bias (only successful cases visible)
- [ ] Hasty generalization (small sample → broad claim)

**Rhetorical Fallacies:**
- [ ] Ad hominem (attack person, not argument)
- [ ] Appeal to authority (without expertise in relevant field)
- [ ] Strawman (misrepresenting opponent's position)
- [ ] Slippery slope (extreme outcome without justification)
- [ ] False dichotomy (only 2 options when more exist)

**Statistical Fallacies:**
- [ ] Base rate neglect (ignoring prior probability)
- [ ] Absolute vs. relative risk confusion
- [ ] Misleading averages (mean hiding distribution)

## Critical Questions Protocol

### Level 1: Comprehension
- What is the core claim?
- What evidence supports it?
- What are the key assumptions?

### Level 2: Analysis
- Is the evidence sufficient for the claim?
- Are there logical gaps?
- What's missing from this argument?

### Level 3: Evaluation
- How strong is this argument overall?
- What would strengthen/weaken it?
- What are alternative explanations?

### Level 4: Synthesis
- How does this fit with other knowledge?
- Where might the author be correct despite flaws?
- What's the charitable interpretation?

## Source Credibility Assessment

**Author Background:**
- Relevant expertise in the field?
- Potential conflicts of interest?
- Track record of accuracy?

**Publication Context:**
- Peer-reviewed? Editorial standards?
- Primary source or interpretation?
- Publication date (currency)?

**Motivation Analysis:**
- What's the author's goal? (inform/persuade/sell)
- Who benefits from this claim?
- What's the intended audience?

## Counter-Evidence Search

When analyzing strong claims, actively look for:
1. Studies with opposite findings
2. Expert disagreement
3. Failed replications
4. Boundary conditions (when doesn't it work?)

## Balanced Evaluation Template

```markdown
## Argument Strengths
- [What's well-supported]
- [Strong evidence points]

## Argument Weaknesses  
- [Logical gaps]
- [Weak or missing evidence]

## Unanswered Questions
- [What the argument doesn't address]

## Conditional Truth
This argument is strongest when: [context]
This argument is weakest when: [context]
```

## Steelmanning Practice

Before criticizing, construct the **strongest possible version** of the argument:
1. Fill in logical gaps charitably
2. Add best possible supporting evidence
3. Address obvious objections
4. THEN evaluate this strongest version

This prevents attacking strawmen and ensures fair evaluation.
