---
name: rank-tracker
description: Tracks and analyzes keyword ranking positions over time for both traditional search results and AI-generated responses. Monitors ranking changes, identifies trends, and alerts on significant movements.
---

# Rank Tracker

This skill helps you track, analyze, and report on keyword ranking positions over time. It monitors both traditional SERP rankings and AI/GEO visibility to provide comprehensive search performance insights.

## When to Use This Skill

- Setting up ranking tracking for new campaigns
- Monitoring keyword position changes
- Analyzing ranking trends over time
- Comparing rankings against competitors
- Tracking SERP feature appearances
- Monitoring AI Overview inclusions
- Creating ranking reports for stakeholders

## What This Skill Does

1. **Position Tracking**: Records and tracks keyword rankings
2. **Trend Analysis**: Identifies ranking patterns over time
3. **Movement Detection**: Flags significant position changes
4. **Competitor Comparison**: Benchmarks against competitors
5. **SERP Feature Tracking**: Monitors featured snippets, PAA
6. **GEO Visibility Tracking**: Tracks AI citation appearances
7. **Report Generation**: Creates ranking performance reports

## How to Use

### Set Up Tracking

```
Set up rank tracking for [domain] targeting these keywords: [keyword list]
```

### Analyze Rankings

```
Analyze ranking changes for [domain] over the past [time period]
```

### Compare to Competitors

```
Compare my rankings to [competitor] for [keywords]
```

### Generate Reports

```
Create a ranking report for [domain/campaign]
```

## Instructions

When a user requests rank tracking or analysis:

1. **Set Up Keyword Tracking**

   ```markdown
   ## Rank Tracking Setup
   
   ### Tracking Configuration
   
   **Domain**: [domain]
   **Tracking Location**: [country/city]
   **Device**: [Mobile/Desktop/Both]
   **Language**: [language]
   **Update Frequency**: [Daily/Weekly/Monthly]
   
   ### Keywords to Track
   
   | Keyword | Volume | Current Rank | Type | Priority |
   |---------|--------|--------------|------|----------|
   | [keyword 1] | [vol] | [rank] | Primary | High |
   | [keyword 2] | [vol] | [rank] | Primary | High |
   | [keyword 3] | [vol] | [rank] | Secondary | Medium |
   | [keyword 4] | [vol] | [rank] | Long-tail | Medium |
   | [keyword 5] | [vol] | [rank] | Brand | High |
   
   ### Competitor Tracking
   
   Track these competitors for benchmark:
   1. [Competitor 1] - [domain]
   2. [Competitor 2] - [domain]
   3. [Competitor 3] - [domain]
   
   ### Tracking Categories
   
   | Category | Keywords | Description |
   |----------|----------|-------------|
   | Brand | [X] | Brand name variations |
   | Product | [X] | Product-related terms |
   | Informational | [X] | Educational queries |
   | Commercial | [X] | Buying intent terms |
   ```

2. **Record Current Rankings**

   ```markdown
   ## Current Ranking Snapshot
   
   **Date**: [date]
   **Domain**: [domain]
   
   ### Ranking Overview
   
   | Position Range | Keyword Count | % of Total |
   |----------------|---------------|------------|
   | #1 | [X] | [X]% |
   | #2-3 | [X] | [X]% |
   | #4-10 | [X] | [X]% |
   | #11-20 | [X] | [X]% |
   | #21-50 | [X] | [X]% |
   | #51-100 | [X] | [X]% |
   | Not ranking | [X] | [X]% |
   
   ### Position Distribution
   
   ```
   Position 1:     ████████ [X] keywords
   Position 2-3:   ██████ [X] keywords
   Position 4-10:  ████████████████ [X] keywords
   Position 11-20: ████████████ [X] keywords
   Position 21+:   ██████████ [X] keywords
   ```
   
   ### Detailed Rankings
   
   | Keyword | Position | URL | SERP Features | Change |
   |---------|----------|-----|---------------|--------|
   | [kw 1] | 3 | [url] | Featured Snippet | +2 ↑ |
   | [kw 2] | 7 | [url] | PAA | -1 ↓ |
   | [kw 3] | 12 | [url] | None | New |
   | [kw 4] | 1 | [url] | Featured Snippet | — |
   ```

3. **Analyze Ranking Changes**

   ```markdown
   ## Ranking Change Analysis
   
   **Period**: [start date] to [end date]
   
   ### Overall Movement
   
   | Metric | Start | End | Change |
   |--------|-------|-----|--------|
   | Avg Position | [X] | [Y] | [+/-Z] |
   | Keywords in Top 10 | [X] | [Y] | [+/-Z] |
   | Keywords in Top 3 | [X] | [Y] | [+/-Z] |
   | Keywords #1 | [X] | [Y] | [+/-Z] |
   
   ### Biggest Improvements 📈
   
   | Keyword | Old Rank | New Rank | Change | Est. Traffic Impact |
   |---------|----------|----------|--------|---------------------|
   | [kw 1] | 15 | 4 | +11 | +[X] visits/mo |
   | [kw 2] | 25 | 9 | +16 | +[X] visits/mo |
   | [kw 3] | 8 | 2 | +6 | +[X] visits/mo |
   
   **Why improved**:
   - [kw 1]: [reason - e.g., content update, new backlinks]
   - [kw 2]: [reason]
   
   ### Biggest Declines 📉
   
   | Keyword | Old Rank | New Rank | Change | Est. Traffic Impact |
   |---------|----------|----------|--------|---------------------|
   | [kw 1] | 3 | 12 | -9 | -[X] visits/mo |
   | [kw 2] | 7 | 18 | -11 | -[X] visits/mo |
   
   **Why declined**:
   - [kw 1]: [reason - e.g., competitor update, algo change]
   - [kw 2]: [reason]
   
   **Recommended actions**:
   - [kw 1]: [action to recover]
   - [kw 2]: [action to recover]
   
   ### Stable Keywords
   
   [X] keywords remained within ±3 positions (stable)
   
   ### New Rankings
   
   | Keyword | Position | URL | Notes |
   |---------|----------|-----|-------|
   | [kw 1] | [pos] | [url] | [notes] |
   
   ### Lost Rankings
   
   | Keyword | Last Position | URL | Action |
   |---------|---------------|-----|--------|
   | [kw 1] | [pos] | [url] | [investigate/refresh] |
   ```

4. **Track SERP Features**

   ```markdown
   ## SERP Feature Tracking
   
   ### Feature Ownership
   
   | Feature | Your Count | Competitor Avg | Opportunity |
   |---------|------------|----------------|-------------|
   | Featured Snippets | [X] | [Y] | [+/-Z] |
   | People Also Ask | [X] | [Y] | [+/-Z] |
   | Image Pack | [X] | [Y] | [+/-Z] |
   | Video Results | [X] | [Y] | [+/-Z] |
   | Local Pack | [X] | [Y] | [+/-Z] |
   
   ### Featured Snippet Status
   
   | Keyword | You Own? | Current Owner | Winnable? |
   |---------|----------|---------------|-----------|
   | [kw 1] | ✅ Yes | You | Maintain |
   | [kw 2] | ❌ No | [Competitor] | High |
   | [kw 3] | ❌ No | [Competitor] | Medium |
   
   ### PAA Appearances
   
   | Question | Your Answer? | Position | Action |
   |----------|--------------|----------|--------|
   | [Question 1] | ✅/❌ | [pos] | [action] |
   | [Question 2] | ✅/❌ | [pos] | [action] |
   ```

5. **Track GEO/AI Visibility**

   ```markdown
   ## AI/GEO Visibility Tracking
   
   ### AI Overview Presence
   
   | Keyword | AI Overview | You Cited? | Citation Position |
   |---------|-------------|------------|-------------------|
   | [kw 1] | Yes | ✅ | 1st source |
   | [kw 2] | Yes | ✅ | 3rd source |
   | [kw 3] | Yes | ❌ | Not cited |
   | [kw 4] | No | N/A | N/A |
   
   ### AI Citation Rate
   
   | Metric | Value |
   |--------|-------|
   | Keywords with AI Overview | [X]/[Total] ([Y]%) |
   | Your citations in AI Overview | [X]/[Y] ([Z]%) |
   | Avg citation position | [X] |
   
   ### GEO Performance Trend
   
   | Period | AI Overviews Tracked | Your Citations | Rate |
   |--------|---------------------|----------------|------|
   | Last week | [X] | [Y] | [Z]% |
   | 2 weeks ago | [X] | [Y] | [Z]% |
   | Month ago | [X] | [Y] | [Z]% |
   
   ### GEO Improvement Opportunities
   
   | Keyword | Has AI Overview | You Cited? | Content Gap |
   |---------|-----------------|------------|-------------|
   | [kw 1] | Yes | No | Need clearer definition |
   | [kw 2] | Yes | No | Missing quotable stats |
   ```

6. **Compare Against Competitors**

   ```markdown
   ## Competitor Ranking Comparison
   
   ### Share of Voice
   
   | Domain | Keywords Ranked | Avg Position | Visibility |
   |--------|-----------------|--------------|------------|
   | [Your site] | [X] | [Y] | [Z]% |
   | [Competitor 1] | [X] | [Y] | [Z]% |
   | [Competitor 2] | [X] | [Y] | [Z]% |
   | [Competitor 3] | [X] | [Y] | [Z]% |
   
   ### Head-to-Head Comparison
   
   **You vs [Competitor 1]**:
   
   | Keyword | Your Rank | Their Rank | Winner |
   |---------|-----------|------------|--------|
   | [kw 1] | 3 | 7 | You ✅ |
   | [kw 2] | 12 | 5 | Them ❌ |
   | [kw 3] | 1 | 4 | You ✅ |
   
   **Summary**: You win [X]/[Y] keywords vs [Competitor 1]
   
   ### Competitor Movement Alerts
   
   | Competitor | Keyword | Their Change | Threat Level |
   |------------|---------|--------------|--------------|
   | [Comp 1] | [kw] | +15 positions | 🔴 High |
   | [Comp 2] | [kw] | +8 positions | 🟡 Medium |
   ```

7. **Generate Ranking Report**

   ```markdown
   # Ranking Performance Report
   
   **Domain**: [domain]
   **Report Period**: [start] to [end]
   **Generated**: [date]
   
   ## Executive Summary
   
   **Overall Trend**: [Improving/Stable/Declining]
   
   | Metric | Value | vs Last Period | Status |
   |--------|-------|----------------|--------|
   | Total keywords tracked | [X] | [+/-Y] | [status] |
   | Keywords in top 10 | [X] | [+/-Y] | [status] |
   | Keywords in top 3 | [X] | [+/-Y] | [status] |
   | Average position | [X] | [+/-Y] | [status] |
   | Estimated traffic | [X] | [+/-Y]% | [status] |
   
   ## Position Distribution
   
   ```
   Position 1:     ████████████ [X]%
   Position 2-3:   ████████ [X]%
   Position 4-10:  ████████████████ [X]%
   Position 11-20: ██████████ [X]%
   Position 21+:   ████ [X]%
   ```
   
   ## Key Highlights
   
   ### Wins 🎉
   - [Achievement 1]
   - [Achievement 2]
   - [Achievement 3]
   
   ### Concerns ⚠️
   - [Issue 1]
   - [Issue 2]
   
   ### Opportunities 💡
   - [Opportunity 1]
   - [Opportunity 2]
   
   ## Detailed Analysis
   
   ### Top Performing Keywords
   
   | Keyword | Position | Change | Traffic | Notes |
   |---------|----------|--------|---------|-------|
   | [kw 1] | 1 | — | [X] | Stable leader |
   | [kw 2] | 2 | +3 | [X] | Growing |
   | [kw 3] | 3 | +5 | [X] | Big improvement |
   
   ### Keywords Needing Attention
   
   | Keyword | Position | Change | Issue | Recommended Action |
   |---------|----------|--------|-------|-------------------|
   | [kw 1] | 15 | -8 | Dropped | Refresh content |
   | [kw 2] | 22 | -5 | Competitor surge | Analyze competitor |
   
   ## SERP Feature Report
   
   | Feature | Count | Change | Competitor Avg |
   |---------|-------|--------|----------------|
   | Featured Snippets | [X] | [+/-Y] | [Z] |
   | PAA | [X] | [+/-Y] | [Z] |
   
   ## GEO/AI Visibility Report
   
   | Metric | This Period | Last Period | Trend |
   |--------|-------------|-------------|-------|
   | AI Overview appearances | [X] | [Y] | [↑/↓] |
   | Your citations | [X] | [Y] | [↑/↓] |
   | Citation rate | [X]% | [Y]% | [↑/↓] |
   
   ## Competitive Position
   
   **Share of Voice Ranking**: #[X] of [Y] competitors
   
   | Rank | Domain | Visibility |
   |------|--------|------------|
   | 1 | [domain] | [X]% |
   | 2 | [domain] | [X]% |
   | 3 | [domain] | [X]% |
   
   ## Recommendations
   
   ### Immediate Actions
   1. [Action] for [keyword] - [expected impact]
   2. [Action] for [keyword] - [expected impact]
   
   ### This Month
   1. [Action]
   2. [Action]
   
   ### Next Quarter
   1. [Strategic action]
   2. [Strategic action]
   
   ## Next Report
   
   Scheduled: [date]
   Focus areas: [areas to monitor]
   ```

## Example

**User**: "Analyze my ranking changes for the past month"

**Output**:

```markdown
# Ranking Analysis: December 2024

## Summary

Your average position improved from 15.3 to 12.8 (-2.5 positions = better)
Keywords in top 10 increased from 12 to 17 (+5)

## Biggest Wins

| Keyword | Old | New | Change | Why |
|---------|-----|-----|--------|-----|
| email marketing tips | 18 | 5 | +13 | Content refresh worked |
| best crm software | 24 | 11 | +13 | New backlinks acquired |
| sales automation | 15 | 7 | +8 | Schema markup added |

## Needs Attention

| Keyword | Old | New | Change | Action |
|---------|-----|-----|--------|--------|
| marketing automation | 4 | 12 | -8 | Competitor HubSpot published new guide |

**Recommended**: Update your marketing automation guide with 2024 statistics and examples.
```

## Tracking Best Practices

1. **Track consistently** - Same time, same device, same location
2. **Include enough keywords** - 50-200 for meaningful data
3. **Segment by intent** - Track brand, commercial, informational separately
4. **Monitor competitors** - Context makes your data meaningful
5. **Track SERP features** - Position 1 without snippet may lose to position 4 with snippet
6. **Include GEO metrics** - AI visibility increasingly important

## Related Skills

- [keyword-research](../../research/keyword-research/) - Find keywords to track
- [serp-analysis](../../research/serp-analysis/) - Understand SERP composition
- [alert-manager](../alert-manager/) - Set up ranking alerts
- [performance-reporter](../performance-reporter/) - Comprehensive reporting

