# {{BRAND_NAME}} Brand Guidelines

**Version**: {{VERSION}}
**Last Updated**: {{DATE}}
**Created by**: Brand Analysis

---

## Table of Contents
1. [Brand Story](#brand-story)
2. [Visual Identity](#visual-identity)
3. [Voice and Messaging](#voice-and-messaging)
4. [Brand Applications](#brand-applications)
5. [Usage Examples](#usage-examples)

---

## Brand Story

### Mission Statement
{{MISSION_STATEMENT}}

### Vision Statement
{{VISION_STATEMENT}}

### Core Values
{{CORE_VALUES_LIST}}

### Brand Personality
{{BRAND_PERSONALITY_DESCRIPTION}}

### Brand Archetype
**Primary**: {{PRIMARY_ARCHETYPE}}
**Secondary**: {{SECONDARY_ARCHETYPE}}

{{ARCHETYPE_DESCRIPTION}}

---

## Visual Identity

### Logo

#### Primary Logo
{{LOGO_DESCRIPTION}}

**Usage Guidelines**:
- Clear space: {{CLEAR_SPACE_RULE}}
- Minimum size: {{MINIMUM_SIZE}}
- File formats: SVG (preferred), PNG, EPS

#### Logo Variations
- **Full Color**: For standard use on light backgrounds
- **Monochrome**: For single-color applications
- **Reversed**: For use on dark backgrounds
- **Icon**: For small-space applications

**Do's**:
- ✓ Maintain proper clear space
- ✓ Use approved color versions
- ✓ Maintain aspect ratio

**Don'ts**:
- ✗ Distort or stretch the logo
- ✗ Change logo colors
- ✗ Add effects or shadows
- ✗ Rotate the logo

### Color Palette

#### Primary Colors
{{PRIMARY_COLORS_WITH_CODES}}

**Usage**: Primary colors should dominate brand materials, representing approximately 60-70% of color usage.

#### Secondary Colors
{{SECONDARY_COLORS_WITH_CODES}}

**Usage**: Secondary colors support and complement primary colors, used for accents and highlights (20-30% of usage).

#### Neutral Colors
{{NEUTRAL_COLORS_WITH_CODES}}

**Usage**: For backgrounds, text, and supporting elements (10-20% of usage).

#### Accessibility
All color combinations meet WCAG 2.1 AA standards for contrast:
{{ACCESSIBILITY_NOTES}}

### Typography

#### Primary Typeface
**Font Family**: {{PRIMARY_FONT}}
**Weights**: {{AVAILABLE_WEIGHTS}}
**Usage**: Headers, titles, key messaging

**Hierarchy**:
- H1: {{H1_SPECS}}
- H2: {{H2_SPECS}}
- H3: {{H3_SPECS}}

#### Secondary Typeface
**Font Family**: {{SECONDARY_FONT}}
**Weights**: {{AVAILABLE_WEIGHTS}}
**Usage**: Body text, descriptions, supporting content

**Specifications**:
- Body: {{BODY_SPECS}}
- Caption: {{CAPTION_SPECS}}

#### Font Pairing Rules
{{FONT_PAIRING_GUIDELINES}}

### Imagery Style

#### Photography
{{PHOTOGRAPHY_GUIDELINES}}

**Characteristics**:
- {{PHOTO_CHARACTERISTIC_1}}
- {{PHOTO_CHARACTERISTIC_2}}
- {{PHOTO_CHARACTERISTIC_3}}

#### Illustration
{{ILLUSTRATION_GUIDELINES}}

**Style Notes**:
- {{ILLUSTRATION_NOTE_1}}
- {{ILLUSTRATION_NOTE_2}}

#### Iconography
{{ICON_STYLE_DESCRIPTION}}

**Icon Guidelines**:
- Style: {{ICON_STYLE}}
- Weight: {{ICON_WEIGHT}}
- Corner radius: {{ICON_RADIUS}}
- Grid: {{ICON_GRID}}

---

## Voice and Messaging

### Brand Voice
{{BRAND_VOICE_DESCRIPTION}}

**Key Characteristics**:
1. {{VOICE_TRAIT_1}}: {{TRAIT_1_DESCRIPTION}}
2. {{VOICE_TRAIT_2}}: {{TRAIT_2_DESCRIPTION}}
3. {{VOICE_TRAIT_3}}: {{TRAIT_3_DESCRIPTION}}

### Tone Variations

The brand voice remains consistent, but tone adapts to context:

| Context | Tone | Example |
|---------|------|---------|
| {{CONTEXT_1}} | {{TONE_1}} | {{EXAMPLE_1}} |
| {{CONTEXT_2}} | {{TONE_2}} | {{EXAMPLE_2}} |
| {{CONTEXT_3}} | {{TONE_3}} | {{EXAMPLE_3}} |

### Language Guidelines

**Do Use**:
- {{LANGUAGE_DO_1}}
- {{LANGUAGE_DO_2}}
- {{LANGUAGE_DO_3}}

**Avoid**:
- {{LANGUAGE_DONT_1}}
- {{LANGUAGE_DONT_2}}
- {{LANGUAGE_DONT_3}}

### Key Messages

#### Value Proposition
{{VALUE_PROPOSITION}}

#### Messaging Pillars
1. **{{PILLAR_1_NAME}}**: {{PILLAR_1_DESCRIPTION}}
2. **{{PILLAR_2_NAME}}**: {{PILLAR_2_DESCRIPTION}}
3. **{{PILLAR_3_NAME}}**: {{PILLAR_3_DESCRIPTION}}

### Taglines
- Primary: {{PRIMARY_TAGLINE}}
- Secondary: {{SECONDARY_TAGLINE}}

---

## Brand Applications

### Digital

#### Website
{{WEBSITE_GUIDELINES}}

#### Social Media
{{SOCIAL_MEDIA_GUIDELINES}}

**Platform-Specific Notes**:
- **Instagram**: {{INSTAGRAM_NOTES}}
- **LinkedIn**: {{LINKEDIN_NOTES}}
- **Twitter**: {{TWITTER_NOTES}}
- **Facebook**: {{FACEBOOK_NOTES}}

#### Email
{{EMAIL_GUIDELINES}}

### Print

#### Business Collateral
{{PRINT_GUIDELINES}}

#### Packaging
{{PACKAGING_GUIDELINES}}

### Environmental

#### Signage
{{SIGNAGE_GUIDELINES}}

#### Office Space
{{OFFICE_SPACE_GUIDELINES}}

---

## Usage Examples

### Good Examples
{{GOOD_EXAMPLES_DESCRIPTION}}

### Bad Examples
{{BAD_EXAMPLES_DESCRIPTION}}

---

## Brand Consistency Checklist

Before releasing any brand material, verify:

**Visual Elements**:
- [ ] Logo usage follows guidelines
- [ ] Colors match approved palette
- [ ] Typography follows hierarchy
- [ ] Imagery style is consistent
- [ ] Layout maintains brand principles

**Voice and Messaging**:
- [ ] Tone matches brand personality
- [ ] Language aligns with guidelines
- [ ] Key messages are reinforced
- [ ] Content serves brand goals

**Quality Standards**:
- [ ] All materials are high-quality
- [ ] Brand promise is communicated
- [ ] Target audience is considered
- [ ] Brand experience is cohesive

---

## Resources and Contacts

### Asset Downloads
{{ASSET_DOWNLOAD_LOCATIONS}}

### Brand Team Contacts
{{BRAND_TEAM_CONTACTS}}

### Approval Process
{{APPROVAL_PROCESS}}

---

**Questions?** Contact {{BRAND_CONTACT_EMAIL}}
