# Market Analysis Frameworks

## Market Opportunity Assessment

### TAM/SAM/SOM Analysis
- **TAM (Total Addressable Market)**: Total market demand for a product/service
- **SAM (Serviceable Available Market)**: Segment of TAM targeted by your products/services
- **SOM (Serviceable Obtainable Market)**: Portion of SAM you can realistically capture

### Market Size Indicators
- Number of potential customers
- Average revenue per customer
- Market growth rate (CAGR)
- Geographic distribution
- Industry spending trends

## Competitive Landscape

### Porter's Five Forces
1. **Threat of New Entrants**: Barriers to entry, capital requirements
2. **Bargaining Power of Suppliers**: Supplier concentration, switching costs
3. **Bargaining Power of Buyers**: Customer concentration, price sensitivity
4. **Threat of Substitutes**: Alternative solutions, switching costs
5. **Competitive Rivalry**: Number of competitors, market growth rate

### Competitor Analysis Dimensions
- Direct competitors (same solution, same market)
- Indirect competitors (different solution, same problem)
- Adjacent competitors (similar solution, different market)
- Emerging threats (new technologies, business models)

## Problem-Solution Fit

### Problem Validation Criteria
- **Frequency**: How often does the problem occur?
- **Intensity**: How painful is the problem?
- **Willingness to Pay**: Are customers paying for solutions now?
- **Market Accessibility**: Can you reach affected customers?

### Solution Evaluation
- **Unique Value Proposition**: What makes your solution different?
- **Competitive Advantage**: Sustainable differentiation factors
- **Technology Moat**: Defensibility through technology
- **Network Effects**: Does value increase with more users?

## Market Trends Analysis

### Trend Categories
- **Technological**: AI/ML, automation, new platforms
- **Economic**: GDP growth, consumer spending, investment climate
- **Social**: Demographics, behavior changes, cultural shifts
- **Regulatory**: New laws, compliance requirements, policy changes
- **Environmental**: Sustainability, climate concerns

### Trend Validation
- Google Trends data
- Industry reports and analyst predictions
- Patent filings and academic research
- VC investment patterns
- Job market signals

## Business Model Viability

### Revenue Model Assessment
- Pricing strategy alignment with market
- Customer acquisition cost (CAC)
- Lifetime value (LTV)
- LTV:CAC ratio (healthy = 3:1 or higher)
- Payback period (ideally < 12 months)

### Unit Economics
- Gross margin per customer
- Contribution margin
- Operating leverage potential
- Scalability factors

## Go-to-Market Strategy

### Market Entry Considerations
- Beachhead market identification
- Distribution channels
- Customer acquisition strategy
- Sales cycle length
- Partnership opportunities

### Positioning Framework
- Target customer persona
- Core problem addressed
- Unique value proposition
- Key differentiators
- Proof points and credibility

## Risk Assessment

### Critical Risks
- **Market Risk**: Market size too small, wrong timing
- **Execution Risk**: Team gaps, operational challenges
- **Technology Risk**: Technical feasibility, scalability
- **Competitive Risk**: Incumbents, better-funded competitors
- **Regulatory Risk**: Compliance, licensing requirements
- **Financial Risk**: Funding requirements, burn rate

## Validation Signals

### Positive Indicators
- Growing market with favorable trends
- Multiple customer segments with shared problem
- Existing budget/spending for similar solutions
- Low customer acquisition costs
- Strong word-of-mouth potential
- Regulatory tailwinds

### Warning Signs
- Shrinking or stagnant market
- Heavy reliance on single customer segment
- High customer acquisition costs
- Long sales cycles (>6 months for B2B)
- Strong incumbents with high switching costs
- Unclear monetization path
