# Research Templates and Data Sources

## Web Search Query Templates

### Market Size Research
- "[industry] market size [year]"
- "[industry] market forecast [year]-[year+5]"
- "global [product/service] market analysis"
- "[industry] CAGR growth rate"
- "number of [target customers] worldwide"

### Competitive Research
- "[product/service] alternatives"
- "[company name] competitors"
- "best [product category] [year]"
- "[product] vs [competitor] comparison"
- "[industry] market leaders"

### Problem Validation
- "[target audience] pain points [industry]"
- "challenges facing [industry]"
- "[target audience] biggest problems"
- "why do [target audience] need [solution type]"

### Trend Analysis
- "[industry] trends [year]"
- "future of [industry]"
- "[technology] adoption rate"
- "[industry] investment report [year]"
- "[industry] emerging technologies"

### Customer Insights
- "[target audience] behavior study"
- "[industry] customer survey [year]"
- "[product category] user demographics"
- "how [target audience] choose [product type]"

### Pricing Research
- "[product category] average price"
- "[product/service] pricing models"
- "[industry] pricing strategies"
- "cost of [solution] for [target audience]"

## Reliable Data Sources by Category

### Market Research & Statistics
- Statista (market data and statistics)
- Grand View Research (industry reports)
- MarketsandMarkets (market forecasts)
- IBISWorld (industry analysis)
- Gartner (technology research)
- Forrester (market analysis)
- IDC (tech market intelligence)

### Financial & Business Data
- Crunchbase (startup funding, company data)
- PitchBook (private equity data)
- CB Insights (venture capital trends)
- SEC filings (public company data)
- Bloomberg (financial news and data)
- Yahoo Finance (public company metrics)

### Industry News & Trends
- TechCrunch (tech startups)
- VentureBeat (tech industry)
- The Information (tech news)
- Protocol (tech policy and business)
- Industry-specific trade publications

### Academic & Research
- Google Scholar (academic papers)
- arXiv (preprint research papers)
- SSRN (social science research)
- PubMed (medical research)
- IEEE Xplore (technology research)

### Consumer Insights
- Nielsen (consumer behavior)
- Pew Research (demographic trends)
- McKinsey reports (business insights)
- Deloitte insights (industry analysis)
- Bain reports (strategy insights)

### Government & Regulatory
- US Census Bureau (demographics)
- Bureau of Labor Statistics (employment)
- USPTO (patent data)
- FDA (regulatory approvals)
- Country-specific regulatory bodies

### Technology & Patents
- Google Patents (patent search)
- USPTO database (US patents)
- Product Hunt (new product launches)
- GitHub (open source projects)
- Stack Overflow (developer trends)

## Search Strategy Best Practices

### Multi-Source Validation
- Cross-reference data from at least 3 sources
- Prioritize recent data (within 2 years for fast-moving industries)
- Look for consensus vs. outliers
- Note methodology differences

### Source Quality Hierarchy
1. **Primary sources**: Company reports, government data, original research
2. **Reputable analysts**: Gartner, Forrester, McKinsey
3. **Industry publications**: Trade journals, specialized news
4. **General business press**: WSJ, Bloomberg, Reuters
5. **Aggregators**: Secondary analysis, blog posts

### Red Flags for Unreliable Data
- No cited sources or methodology
- Promotional content disguised as research
- Outdated information (>3 years old for tech)
- Suspiciously precise forecasts without explanation
- Contradicts multiple other sources

## Report Structure Template

### Executive Summary
- Startup idea overview
- Core finding (viable/not viable/conditional)
- Key supporting evidence
- Critical recommendations

### Market Analysis
- Market size and growth
- Target customer segments
- Market trends and drivers
- Entry barriers and opportunities

### Competitive Landscape
- Direct and indirect competitors
- Competitive positioning
- Differentiation opportunities
- Market gaps

### Problem-Solution Fit
- Problem validation
- Current solutions and limitations
- Proposed solution advantages
- Customer value proposition

### Business Model Assessment
- Revenue model viability
- Unit economics potential
- Scalability analysis
- Financial requirements

### Risk Analysis
- Critical risks identified
- Mitigation strategies
- Deal-breakers vs. manageable challenges

### Positioning Recommendations
- Target market segments
- Value proposition refinement
- Go-to-market approach
- Differentiation strategy

### Next Steps
- Immediate validation actions
- Information gaps to fill
- Key assumptions to test
- Recommended pivots (if any)
