# auto-format-python

## Overview
Automatically format Python files with `black` immediately after editing.

**Event Type:** `PostToolUse`
**Complexity:** beginner
**Language:** python

## How It Works
Triggers immediately after Write/Edit tools complete

1. Claude Code detects the configured event
2. Hook matcher checks if conditions are met
3. Hook command executes with safety wrappers
4. Result is processed (silent failure on errors)

## Use Cases
- Auto-format Python files with black
- Auto-format JavaScript/TypeScript with prettier
- Auto-format Rust with rustfmt

## Prerequisites
- Python 3.6+
- black (pip install black)

## Installation

### Manual Installation

1. Open your Claude Code settings file:
   - **Project-level:** `.claude/settings.json`
   - **User-level:** `~/.claude/settings.json`

2. Add this hook configuration to the `hooks` array:

```json
{
  "hooks": {
    "PostToolUse": [
      {
        "matcher": {
          "tool_names": ["Write", "Edit"]
        },
        "hooks": [
          {
            "type": "command",
            "command": "# Check if black is installed\nif ! command -v black &> /dev/null; then\n    exit 0\nfi\n\n# Format the file based on type\nif [[ \"$CLAUDE_TOOL_FILE_PATH\" == *.py ]]; then\n    black \"$CLAUDE_TOOL_FILE_PATH\" || exit 0\nfi",
            "timeout": 60
          }
        ]
      }
    ]
  }
}
```

3. Save the file and restart Claude Code.

## Configuration

### Customize Behavior
You can modify the hook by editing `hook.json`:

**Available Customizations:**

**TOOL:** Formatting tool to use
- Options: python, javascript, typescript, rust, go

**FORMAT_LOGIC:** Language-specific formatting logic

**FILE_PATTERNS:** Glob patterns for target files
- Options: python, javascript, typescript, rust, go

## Safety Notes
Must complete in <5 seconds. Uses silent failure mode.

**Safety Features:**
- ✅ Tool detection prevents errors if dependencies missing
- ✅ Silent failure mode (`|| exit 0`) never interrupts workflow
- ✅ Appropriate timeout settings
- ✅ No destructive operations

## Troubleshooting

### Hook Not Triggering
1. Check that the event type matches your use case
2. Verify file patterns in matcher (if applicable)
3. Check Claude Code logs: `~/.claude/logs/`

### Command Errors
1. Verify required tools are installed
2. Test command manually in terminal
3. Check timeout settings

## Advanced

### Combining with Other Hooks
You can combine this hook with others by adding them to the same event type array.

### Custom Modifications
- Combine with `isort` for import sorting
- Add `mypy` for type checking
- Configure black in `pyproject.toml`

---
**Generated by hook-factory** | 2025-10-30
**Template:** post_tool_use_format
**Version:** 1.0
