# load-context

## Overview
Load project-specific context when Claude Code session starts

**Event Type:** `SessionStart`
**Complexity:** beginner
**Language:** all

## How It Works
Triggers once when session begins or resumes

1. Claude Code detects the configured event
2. Hook matcher checks if conditions are met
3. Hook command executes with safety wrappers
4. Result is processed (silent failure on errors)

## Use Cases
- Load TODO list
- Display project status
- Show recent git changes
- Load custom project instructions

## Prerequisites
- None (uses standard Unix commands)

## Installation

### Manual Installation

1. Open your Claude Code settings file:
   - **Project-level:** `.claude/settings.json`
   - **User-level:** `~/.claude/settings.json`

2. Add this hook configuration to the `hooks` array:

```json
{
  "hooks": {
    "SessionStart": [
      {
        "matcher": {
          "source": ["startup", "resume"]
        },
        "hooks": [
          {
            "type": "command",
            "command": "# Load project context\nif [ -f TODO.md ]; then\n    echo \"# Project TODO List\"\n    cat TODO.md\nelse\n    echo \"No TODO.md found\"\nfi",
            "timeout": 60
          }
        ]
      }
    ]
  }
}
```

3. Save the file and restart Claude Code.

## Configuration

### Customize Behavior
You can modify the hook by editing `hook.json`:

**Available Customizations:**

**CONTEXT_FILE:** File to load for context
- Options: todo, agents, project_status, custom

**CONTEXT_LOAD_LOGIC:** Logic to load and display context

## Safety Notes
Read-only operations recommended. Fast execution required.

**Safety Features:**
- ✅ Tool detection prevents errors if dependencies missing
- ✅ Silent failure mode (`|| exit 0`) never interrupts workflow
- ✅ Appropriate timeout settings
- ✅ No destructive operations

## Troubleshooting

### Hook Not Triggering
1. Check that the event type matches your use case
2. Verify file patterns in matcher (if applicable)
3. Check Claude Code logs: `~/.claude/logs/`

### Command Errors
1. Verify required tools are installed
2. Test command manually in terminal
3. Check timeout settings

## Advanced

### Combining with Other Hooks
You can combine this hook with others by adding them to the same event type array.

### Custom Modifications
- Customize command parameters
- Add conditional logic
- Combine with other tools

---
**Generated by hook-factory** | 2025-10-30
**Template:** session_start_context_loader
**Version:** 1.0
