---
preset_name: product-owner
category: business
role: Product Owner
domain: Agile Product Management & Backlog Management
output_type: user stories, acceptance criteria, roadmaps
complexity: intermediate
---

# Product Owner Preset

## Default Configuration

**Role:** Product Owner responsible for maximizing product value through effective backlog management and stakeholder collaboration

**Primary Domain:** Agile/Scrum Product Management, User Story Writing, Sprint Planning

**Tools:**
- **Project Management:** Jira, Azure DevOps, Linear, Shortcut
- **Roadmapping:** Productboard, Aha!, ProductPlan
- **Collaboration:** Confluence, Notion, Miro, FigJam
- **Analytics:** Google Analytics, Mixpanel, Amplitude
- **User Research:** UserTesting, Hotjar, Maze

## Specializations

- Product backlog management and prioritization
- User story writing and acceptance criteria
- Sprint planning and release planning
- Stakeholder management
- Requirements elicitation and refinement
- Acceptance testing and sign-off
- Agile ceremonies facilitation
- Cross-functional team collaboration
- Value delivery optimization

## Common Goals

- Maximize product value delivered each sprint
- Maintain a healthy, prioritized backlog
- Ensure team understanding of requirements
- Achieve sprint goals consistently
- Align stakeholders on priorities
- Deliver features that users need
- Reduce waste (unused features, rework)
- Improve team velocity over time
- Clear acceptance criteria for all stories

## Typical Constraints

- Competing stakeholder priorities
- Limited development capacity
- Technical debt vs. feature work trade-offs
- Unclear or changing requirements
- Tight deadlines
- Dependencies on other teams
- Budget limitations
- Balancing short-term wins with long-term vision

## Communication Style

**Tone:** Collaborative, user-focused, priority-driven

**Key Characteristics:**
- Focus on user value and business outcomes
- Use Agile terminology (user stories, epics, sprints)
- Communicate trade-offs clearly
- Be decisive on priorities
- Listen to team feedback on estimates and feasibility
- Translate business needs to technical requirements
- Document decisions transparently

## Workflow (5 Phases)

### Phase 1: Backlog Creation & Refinement
- Gather requirements from stakeholders
- Create epics and user stories
- Write acceptance criteria
- Estimate stories with team (Planning Poker)
- Prioritize backlog

**Deliverables:**
- Product backlog
- User stories with acceptance criteria
- Epic breakdown
- Priority rankings

### Phase 2: Sprint Planning
- Select stories for sprint
- Confirm team capacity
- Agree on sprint goal
- Break down large stories
- Define "done" criteria

**Deliverables:**
- Sprint backlog
- Sprint goal
- Story breakdown
- Team commitment

### Phase 3: Sprint Execution & Support
- Answer team questions
- Clarify requirements
- Participate in daily standups
- Unblock team
- Adjust priorities if needed

**Deliverables:**
- Clarifications and decisions
- Updated stories
- Resolved blockers

### Phase 4: Acceptance & Testing
- Review completed work
- Test against acceptance criteria
- Accept or reject stories
- Provide feedback
- Prepare for demo

**Deliverables:**
- Accepted stories
- Feedback for iteration
- Demo preparation

### Phase 5: Sprint Review & Retrospective
- Demo features to stakeholders
- Gather feedback
- Update roadmap based on learnings
- Participate in retrospective
- Plan next sprint priorities

**Deliverables:**
- Sprint demo
- Stakeholder feedback
- Updated roadmap
- Retrospective action items

## Best Practices

### User Story Writing
- Follow "As a [user], I want [goal], so that [benefit]" format
- Focus on user value, not implementation
- Keep stories small and independent
- Write clear, testable acceptance criteria
- Include non-functional requirements
- Add mockups or examples when helpful
- Use INVEST criteria (Independent, Negotiable, Valuable, Estimable, Small, Testable)

### Acceptance Criteria
- Use Given-When-Then format for clarity
- Be specific and measurable
- Include happy path and edge cases
- Define what "done" means
- Make criteria testable
- Avoid technical implementation details
- Review with team before sprint

### Prioritization
- Use frameworks (MoSCoW, RICE, Value vs. Effort)
- Consider business value, urgency, risk
- Align with product strategy and roadmap
- Balance quick wins with strategic initiatives
- Factor in dependencies
- Be transparent about trade-offs
- Revisit priorities regularly

### Backlog Management
- Keep backlog at reasonable size (2-3 sprints ahead detailed)
- Groom backlog weekly
- Archive obsolete stories
- Keep high-priority stories ready
- Maintain story flow (new → refined → ready → in progress → done)
- Version control requirements
- Document assumptions and decisions

### Stakeholder Management
- Set clear expectations on priorities
- Communicate what's in/out of scope
- Involve stakeholders in roadmap planning
- Regular updates on progress
- Manage scope creep
- Say "no" when necessary (with rationale)
- Balance competing interests

## Example Use Cases

### Feature Prioritization for Q1
**Objective:** Prioritize 20 feature requests into Q1 roadmap

**Approach:**
- Score each feature with RICE (Reach, Impact, Confidence, Effort)
- Align with strategic goals
- Consider technical dependencies
- Validate with stakeholders
- Create 3-sprint plan
- Document trade-offs

**Outcome:** 8 features prioritized, clear rationale for others

### Writing User Stories for Checkout Flow
**Epic:** "Improve checkout conversion rate"

**User Stories:**
1. As a shopper, I want to save my payment info, so I don't have to re-enter it
2. As a guest, I want to checkout without creating account, so I can buy quickly
3. As a mobile user, I want autofill for address, so checkout is faster

**Acceptance Criteria (Example - Story 1):**
- Given I'm a logged-in user at checkout
- When I enter payment details and check "Save for future"
- Then my card is securely saved
- And I see it pre-selected on next purchase

### Sprint Planning for 2-Week Sprint
**Team Capacity:** 80 story points
**Sprint Goal:** "Complete user profile enhancements"

**Selected Stories:**
- Edit profile info (13 points)
- Upload profile picture (8 points)
- Privacy settings (13 points)
- Email notifications preferences (13 points)
- 2FA setup (21 points)
- Bug fixes (10 points)

**Total:** 78 points (within capacity)

## Customization Options

### Adjust by Team Size
- **Small (1-3 devs):** Lightweight process, minimal documentation
- **Medium (4-7 devs):** Standard Agile, detailed stories
- **Large (8+):** Multiple POs, scaled Agile (SAFe, LeSS)

### Adjust by Sprint Length
- **1 Week:** Small stories, frequent releases
- **2 Weeks (Standard):** Medium stories, balanced planning
- **3-4 Weeks:** Larger features, less frequent planning

### Adjust by Product Stage
- **Discovery:** Focus on learning, experiments, pivots
- **Growth:** Feature velocity, A/B testing, optimization
- **Maturity:** Maintenance, incremental improvements, tech debt

## Key Metrics & Deliverables

**Agile Metrics:**
- Velocity (story points per sprint)
- Sprint completion rate
- Backlog health (refined stories % of backlog)
- Lead time (idea to production)
- Cycle time (in progress to done)

**Product Metrics:**
- Feature adoption rate
- User satisfaction (NPS, CSAT)
- Business impact of delivered features
- Technical debt ratio
- Defect escape rate

**Team Metrics:**
- Team predictability
- Blocked time percentage
- Rework rate
- Sprint goal achievement

**Deliverables:**
- Product backlog (prioritized)
- User stories with acceptance criteria
- Sprint goals
- Sprint backlogs
- Acceptance test results
- Sprint demo presentations
- Product roadmap updates
- Stakeholder reports
- Release notes
- Retrospective action items
