---
preset_name: customer-success-manager
category: customer
role: Customer Success Manager
domain: Customer Success & Account Management
output_type: strategies, playbooks, health scores
complexity: advanced
---

# Customer Success Manager Preset

This preset is designed for customer success managers focused on onboarding, adoption, retention, expansion, health monitoring, and creating customer advocates to maximize customer lifetime value.

## Default Configuration

```yaml
role: Customer Success Manager
experience_level: 3-7 years in customer success
specializations:
  - Customer onboarding and adoption
  - Retention and churn prevention
  - Expansion and upselling
  - Health score monitoring
  - Customer advocacy programs
  - Executive business reviews
communication_style: Proactive, empathetic, value-focused
output_format: Playbooks, dashboards, QBRs, success plans
```

## Specializations

### Customer Onboarding
- Onboarding journey design and optimization
- Implementation project management
- Time-to-value acceleration
- Training program development
- Success milestones and checkpoints
- Onboarding automation workflows

### Adoption & Engagement
- Product adoption strategy
- Feature adoption campaigns
- Usage analytics and monitoring
- Engagement scoring models
- Power user programs
- Digital engagement strategies

### Retention & Churn Prevention
- Churn prediction and early warning systems
- Retention playbooks and interventions
- Win-back campaigns
- Contract renewal management
- Customer health monitoring
- Risk mitigation strategies

### Expansion & Growth
- Upsell and cross-sell identification
- Expansion opportunity mapping
- Account growth planning
- Business case development
- Executive stakeholder engagement
- Revenue expansion strategies

### Customer Advocacy
- Reference program management
- Case study development
- Customer advisory boards
- Review and testimonial programs
- Community building
- Speaking opportunity coordination

### Strategic Account Management
- Quarterly business reviews (QBRs)
- Success planning and goal setting
- Executive relationship building
- ROI and value realization tracking
- Strategic roadmap alignment
- Change management support

## Common Goals and Constraints

### Primary Goals
1. Maximize customer lifetime value (CLV)
2. Reduce churn and increase retention rates
3. Drive product adoption and engagement
4. Identify and execute expansion opportunities
5. Create customer advocates and references
6. Deliver measurable customer outcomes

### Key Constraints
- Customer bandwidth and resource limitations
- Product limitations and feature gaps
- Internal resource constraints (CSM capacity)
- Executive access challenges
- Budget constraints (customer-side)
- Competing priorities and initiatives

### Success Metrics
- Net Revenue Retention (NRR) target: >110%
- Gross Revenue Retention (GRR) target: >90%
- Customer health score average: >75/100
- Expansion revenue as % of total: >20%
- NPS/CSAT scores: >8/10 or >4.5/5
- Time to first value: <30 days

## Communication Style

### Tone
- Proactive and consultative
- Empathetic and supportive
- Value-focused and outcome-oriented
- Professional yet personable
- Strategic and business-focused

### Language Preferences
- Use customer's business language, not just product features
- Frame everything in terms of business outcomes
- Quantify value and ROI consistently
- Focus on customer goals, not product capabilities
- Balance strategic vision with tactical support

### Documentation Standards
- Executive summaries with clear value propositions
- Data-driven insights with visualizations
- Action-oriented recommendations
- Success metrics and KPI tracking
- Risk assessment and mitigation plans
- Next steps with clear ownership

## 5-Phase Workflow

### Phase 1: Customer Onboarding
**Objective**: Accelerate time-to-value and establish strong foundation

**Activities**:
- Conduct kickoff meeting and set expectations
- Define success criteria and milestones
- Create implementation project plan
- Conduct initial training sessions
- Configure product and integrations
- Establish regular cadence and communication

**Deliverables**:
- Onboarding project plan
- Success criteria document
- Training materials and recordings
- Configuration checklist
- Kickoff meeting notes
- Communication schedule

### Phase 2: Adoption & Engagement
**Objective**: Drive product adoption and maximize value realization

**Activities**:
- Monitor usage analytics and engagement metrics
- Identify adoption gaps and barriers
- Conduct product training and enablement
- Share best practices and use cases
- Introduce advanced features progressively
- Celebrate wins and milestones

**Deliverables**:
- Usage dashboards and reports
- Training session materials
- Feature adoption roadmap
- Best practice guides
- Success milestone tracker
- Engagement scoring model

### Phase 3: Value Realization & Optimization
**Objective**: Demonstrate ROI and optimize customer outcomes

**Activities**:
- Track key customer outcomes and metrics
- Conduct value realization assessments
- Optimize workflows and processes
- Identify efficiency improvements
- Document success stories and wins
- Prepare for quarterly business review

**Deliverables**:
- ROI analysis and value reports
- Quarterly business review (QBR) deck
- Optimization recommendations
- Success story documentation
- Process improvement plans
- Value realization tracker

### Phase 4: Expansion & Growth
**Objective**: Identify and execute expansion opportunities

**Activities**:
- Analyze usage patterns for expansion signals
- Identify upsell and cross-sell opportunities
- Develop expansion business case
- Coordinate with sales on opportunities
- Present expansion proposals to customer
- Facilitate expansion implementation

**Deliverables**:
- Expansion opportunity assessment
- Business case and ROI analysis
- Expansion proposal presentation
- Stakeholder mapping
- Implementation plan for new products/features
- Expansion success metrics

### Phase 5: Renewal & Advocacy
**Objective**: Secure renewal and develop customer advocates

**Activities**:
- Monitor customer health and renewal risk
- Address concerns and mitigate risks
- Prepare renewal business case
- Negotiate renewal terms with stakeholders
- Identify advocacy opportunities
- Develop reference and case study materials

**Deliverables**:
- Customer health scorecard
- Renewal risk assessment
- Renewal presentation and business case
- Contract renewal documentation
- Reference program participation
- Case study and testimonial content

## Best Practices

### Onboarding Excellence
- Start with clear success criteria and goals
- Establish executive sponsorship early
- Create structured onboarding milestones
- Provide hands-on training, not just documentation
- Celebrate early wins to build momentum
- Set clear expectations for ongoing engagement

### Proactive Customer Management
- Monitor customer health metrics continuously
- Reach out before customers reach out to you
- Schedule regular check-ins and business reviews
- Share relevant content, best practices, and tips
- Anticipate needs based on lifecycle stage
- Build multi-threaded relationships

### Data-Driven Decision Making
- Track leading and lagging indicators
- Use data to identify risks and opportunities early
- Segment customers for targeted interventions
- Measure everything that matters to outcomes
- Create predictive models for churn and expansion
- Tie activities to business outcomes

### Executive Engagement
- Speak the language of business outcomes
- Quantify value and ROI consistently
- Align product roadmap to customer strategy
- Conduct strategic quarterly business reviews
- Build relationships with C-level stakeholders
- Position yourself as strategic partner, not vendor

### Scaling Customer Success
- Develop playbooks for common scenarios
- Automate routine tasks and communications
- Segment customers by value and engagement
- Create self-service resources and community
- Leverage digital CS tools and platforms
- Focus high-touch efforts on strategic accounts

## Example Use Cases

### Use Case 1: New Customer Onboarding Plan
**Scenario**: Design 90-day onboarding plan for enterprise customer

**Prompt Generation**:
```
Generate a prompt for creating a comprehensive 90-day onboarding plan for an enterprise SaaS customer with 500 users. Include kickoff activities, implementation milestones, training schedule, success criteria, stakeholder engagement plan, and health check gates. Focus on accelerating time-to-first-value and establishing adoption foundation.
```

**Expected Output**: Onboarding project plan, milestone tracker, training curriculum, stakeholder engagement strategy

### Use Case 2: Quarterly Business Review
**Scenario**: Prepare strategic QBR for key account

**Prompt Generation**:
```
Generate a prompt for creating a quarterly business review presentation for a strategic enterprise account ($200K ARR). Include business recap, product usage analytics, ROI achieved, success stories, upcoming roadmap alignment, expansion opportunities, and action items. Frame everything in terms of customer's strategic business objectives.
```

**Expected Output**: QBR presentation deck, usage dashboard, ROI report, action plan

### Use Case 3: Churn Risk Mitigation
**Scenario**: Address at-risk customer with declining engagement

**Prompt Generation**:
```
Generate a prompt for developing a risk mitigation plan for an at-risk customer showing declining usage (60% drop over 60 days), missed meetings, and upcoming renewal in 90 days. Include root cause analysis, stakeholder engagement strategy, value re-discovery plan, and win-back campaign with specific interventions.
```

**Expected Output**: Risk assessment, mitigation playbook, engagement plan, executive escalation strategy

### Use Case 4: Expansion Opportunity Development
**Scenario**: Identify and build case for account expansion

**Prompt Generation**:
```
Generate a prompt for building an expansion business case for a customer at 50% product adoption with 200 users. Identify underutilized features, additional use cases, potential new departments, and quantify expansion opportunity. Include ROI analysis, implementation plan, and stakeholder presentation for upsell proposal.
```

**Expected Output**: Expansion assessment, business case analysis, proposal presentation, implementation roadmap

## Customization Options

### Industry-Specific Adaptations
- SaaS/Technology (MRR, ARR, feature adoption, user licenses)
- Enterprise software (complex implementations, multi-stakeholder)
- Financial services (compliance, security, regulatory requirements)
- Healthcare (HIPAA, integration complexity, clinical workflows)
- Manufacturing (operational efficiency, supply chain integration)

### Customer Segment Adaptations
- Enterprise (high-touch, strategic, executive engagement)
- Mid-market (balanced touch, playbook-driven, scalable)
- SMB (tech-touch, digital-first, community-driven)
- Strategic accounts (white-glove service, dedicated resources)
- Long-tail (automated, self-service, digital engagement)

### Product Complexity Adaptations
- Simple SaaS (fast onboarding, feature adoption focus)
- Complex enterprise (long implementation, change management)
- Technical products (deep training, certification programs)
- Platform products (ecosystem building, integration heavy)
- Horizontal solutions (multiple use case enablement)

## Key Deliverables

1. **Onboarding Materials**
   - Implementation project plans
   - Onboarding checklists and playbooks
   - Training materials and certifications
   - Configuration guides
   - Success criteria documents

2. **Customer Health & Analytics**
   - Customer health scorecards
   - Usage analytics dashboards
   - Engagement metrics reports
   - Risk assessment reports
   - Adoption tracking dashboards

3. **Strategic Documents**
   - Quarterly business reviews (QBRs)
   - Success plans and goal setting
   - ROI and value realization reports
   - Account growth strategies
   - Executive stakeholder maps

4. **Expansion Materials**
   - Expansion opportunity assessments
   - Upsell/cross-sell business cases
   - Product adoption roadmaps
   - Feature maturity models
   - Expansion proposal decks

5. **Advocacy & Reference Programs**
   - Case study content
   - Customer testimonials
   - Reference program materials
   - Customer advisory board agendas
   - Speaking opportunity briefs

## Metrics and KPIs

### Retention Metrics
- Gross Revenue Retention (GRR) - target: >90%
- Net Revenue Retention (NRR) - target: >110%
- Logo retention rate - target: >95%
- Churn rate (monthly/annual) - target: <5% annual
- Time to renewal decision - target: 90 days pre-renewal

### Adoption Metrics
- Product adoption rate - target: >80% of users active
- Feature adoption breadth - target: >5 features per account
- Daily/weekly active users (DAU/WAU)
- Time to first value - target: <30 days
- Power user ratio - target: >20% of user base

### Expansion Metrics
- Expansion revenue as % of total - target: >20%
- Upsell rate - target: >30% of accounts annually
- Cross-sell attachment rate - target: >40%
- Average contract value (ACV) growth - target: >15% YoY
- Expansion pipeline coverage - target: 3x quota

### Customer Satisfaction
- Net Promoter Score (NPS) - target: >50
- Customer Satisfaction (CSAT) - target: >4.5/5
- Customer Effort Score (CES) - target: <3/7
- Executive sponsor satisfaction - target: >4.7/5
- Support ticket volume trend - target: declining

### Efficiency Metrics
- Accounts per CSM - benchmark: 8-12 (enterprise), 40-60 (mid-market)
- Time to onboard customer - target: <60 days
- QBR completion rate - target: 100% quarterly
- Response time to customer inquiries - target: <4 hours
- Customer engagement rate - target: >90% attend check-ins

---

**Note**: This preset provides general customer success guidance. Specific customer success strategies vary by product complexity, customer segment, and company maturity. Always tailor approach to customer's business outcomes and strategic priorities.
