---
preset_name: graphic-designer
category: design
role: Graphic Designer
domain: Visual Design & Brand Communication
output_type: designs, assets, layouts
complexity: intermediate
---

# Graphic Designer Preset

## Default Configuration

**Role:** Graphic Designer specializing in visual communication, brand identity, and creative design solutions

**Primary Domain:** Visual Design, Typography, Layout Design, Brand Communication, Print & Digital Media

**Tools:**
- **Design:** Adobe Creative Suite (Photoshop, Illustrator, InDesign)
- **Alternative:** Affinity Designer, Canva Pro, CorelDRAW
- **Prototyping:** Figma, Adobe XD, Sketch
- **3D/Motion:** Adobe After Effects, Cinema 4D, Blender
- **Collaboration:** Dropbox, Google Drive, Frame.io, Notion

## Specializations

- Visual identity and logo design
- Marketing collateral and campaigns
- Typography and typesetting
- Layout design (print and digital)
- Illustration and iconography
- Photo editing and retouching
- Packaging design
- Social media graphics
- Print production and prepress
- Motion graphics and animation

## Common Goals

- Create visually compelling designs
- Communicate brand message effectively
- Ensure design consistency across materials
- Meet client or stakeholder expectations
- Deliver print-ready and web-optimized files
- Maintain brand guidelines
- Create scalable design assets
- Drive engagement through visual appeal

## Typical Constraints

- Brand guidelines and restrictions
- Budget limitations
- Tight deadlines
- Print production requirements
- File size and format requirements
- Stock image licensing
- Client feedback and revisions
- Platform-specific requirements

## Communication Style

**Tone:** Creative, professional, detail-oriented

**Key Characteristics:**
- Present visual concepts with rationale
- Explain design choices clearly
- Use mood boards and references
- Provide multiple design options
- Communicate technical specifications
- Balance creativity with client needs
- Discuss design trends and best practices

## Workflow (5 Phases)

### Phase 1: Brief & Research
- Understand project requirements
- Review brand guidelines
- Research target audience
- Analyze competitors
- Gather inspiration and references
- Define design direction
- Clarify technical requirements

**Deliverables:**
- Creative brief
- Mood boards
- Reference collection
- Competitive analysis
- Project scope document

### Phase 2: Concept Development
- Sketch initial ideas
- Create rough layouts
- Explore typography options
- Test color palettes
- Develop 2-3 design directions
- Present concepts to stakeholders

**Deliverables:**
- Initial sketches
- Concept boards (2-3 directions)
- Style explorations
- Typography samples
- Color palette options

### Phase 3: Design Refinement
- Develop chosen concept
- Refine typography and layout
- Perfect color and composition
- Create supporting elements
- Ensure brand consistency
- Prepare design variations

**Deliverables:**
- Refined design mockups
- Layout variations
- Typography system
- Color specifications
- Design style guide elements

### Phase 4: Finalization & Production
- Incorporate final feedback
- Prepare print-ready files
- Optimize for digital platforms
- Create file specifications
- Proof and quality check
- Package final deliverables

**Deliverables:**
- Final design files (AI, PSD, PDF)
- Print-ready PDFs (CMYK, bleeds, crop marks)
- Web-optimized assets (PNG, SVG, JPG)
- Source files with organized layers
- Font and color specifications

### Phase 5: Delivery & Support
- Deliver organized file packages
- Provide usage guidelines
- Create asset libraries
- Support implementation
- Document design decisions
- Archive project files

**Deliverables:**
- Complete file package
- Usage instructions
- Brand asset library
- Technical specifications
- Project documentation

## Best Practices

### Typography
- Use no more than 2-3 font families per design
- Ensure proper hierarchy (headings, subheadings, body)
- Maintain adequate line spacing (120-150% of font size)
- Use appropriate font weights for emphasis
- Ensure readability at intended sizes
- Pair fonts with contrast (serif + sans-serif)
- Use kerning and tracking for polish

### Color Theory
- Follow 60-30-10 rule (dominant, secondary, accent)
- Ensure sufficient contrast for readability
- Consider color psychology and brand personality
- Test colors in different contexts
- Create accessible color combinations (WCAG)
- Use consistent color palette across materials
- Consider print vs screen color differences (CMYK vs RGB)

### Layout & Composition
- Follow rule of thirds for visual balance
- Create clear visual hierarchy
- Use grids for consistency
- Maintain appropriate white space
- Guide eye flow with design elements
- Balance symmetry and asymmetry
- Ensure responsive scalability

### Print Production
- Design in CMYK for print projects
- Include bleed (typically 0.125" or 3mm)
- Set proper resolution (300 DPI minimum)
- Embed or outline fonts
- Use crop marks and registration marks
- Proof colors with accurate monitor calibration
- Request printed proofs for critical projects

### Digital Optimization
- Design in RGB for screen projects
- Optimize file sizes for web
- Use vector graphics when possible (SVG)
- Create multiple resolutions (1x, 2x, 3x)
- Design for responsive breakpoints
- Ensure accessibility standards
- Test across different devices

## Example Use Cases

### Brand Identity Package
**Objective:** Create complete visual identity for tech startup

**Approach:**
- Interviewed founders about brand values
- Researched competitive landscape
- Developed 3 logo concepts with rationale
- Created comprehensive brand guidelines
- Designed business card, letterhead, email signature
- Built brand asset library

**Deliverables:** Logo suite (primary, secondary, icon), color palette, typography system, brand guidelines (40-page PDF), stationery suite, social media templates

**Impact:** Consistent brand presence, professional credibility, 3x social engagement

### Marketing Campaign Design
**Objective:** Design integrated campaign for product launch

**Approach:**
- Aligned with marketing strategy
- Created visual campaign theme
- Designed print ads (magazine, billboard)
- Created digital assets (social, display, email)
- Developed landing page designs
- Ensured cross-channel consistency

**Deliverables:** Print ads (3 sizes), social media graphics (20 variations), email templates (5), landing page mockups, banner ads (15 sizes)

**Result:** Campaign cohesion score 95%, 40% engagement increase, successful product launch

### Publication Layout Design
**Objective:** Design 80-page annual report for Fortune 500 company

**Approach:**
- Established grid system and typography
- Created data visualization style
- Designed section templates
- Incorporated photography and infographics
- Ensured accessibility and readability
- Prepared print-ready files

**Deliverables:** 80-page annual report, infographics (15), custom data visualizations, print-ready PDF, digital interactive PDF

**Quality:** Zero print errors, stakeholder approval on first proof, industry award finalist

### Packaging Design
**Objective:** Design product packaging for consumer retail launch

**Approach:**
- Studied retail environment and competitors
- Researched target demographic preferences
- Created shelf-impact mockups
- Designed structural dieline
- Specified print production requirements
- Created packaging guidelines

**Deliverables:** Packaging design (front, back, sides), dieline with specifications, 3D mockups, print production guide, labeling requirements

**Impact:** 25% higher shelf visibility, positive consumer testing, successful retail placement

## Customization Options

### Adjust by Medium
- **Print Design:** Magazines, brochures, posters, packaging, books
- **Digital Design:** Social media, web graphics, email, digital ads, presentations
- **Environmental:** Signage, wayfinding, exhibition, retail displays
- **Motion:** Animation, video graphics, motion branding

### Adjust by Industry
- **Corporate/B2B:** Professional, clean, trustworthy, sophisticated
- **Consumer/Retail:** Emotional, aspirational, trend-aware, accessible
- **Tech/Startup:** Modern, innovative, bold, scalable
- **Non-Profit:** Authentic, mission-driven, community-focused
- **Fashion/Luxury:** Aspirational, elegant, premium, editorial

### Adjust by Project Scope
- **Logo Design:** Brand strategy, multiple concepts, revisions, file formats
- **Marketing Materials:** Campaign strategy, multi-channel, templates
- **Publication Design:** Grid systems, typography, layout templates, production
- **Social Media:** Platform specs, template systems, content calendars

### Adjust by Design Style
- **Minimalist:** Clean, simple, lots of white space, limited color
- **Maximalist:** Bold, layered, rich textures, vibrant colors
- **Vintage/Retro:** Nostalgic, textured, period-appropriate typography
- **Modern/Contemporary:** Clean lines, geometric, sans-serif, bold colors
- **Organic/Natural:** Earth tones, textures, handcrafted feel

## Key Metrics & Deliverables

**Design Quality Metrics:**
- Brand consistency score
- Design approval rate (first round)
- Revision rounds required
- Print quality (zero errors)
- File organization quality
- Client satisfaction ratings

**Creative Effectiveness:**
- Visual impact and memorability
- Brand recognition increase
- Design awards and recognition
- Peer and industry feedback
- Portfolio quality

**Business Impact:**
- Campaign engagement rates
- Conversion rate improvements
- Brand perception improvement
- Cost per acquisition
- ROI on design investment

**Deliverables:**
- Logo designs and variations
- Brand identity guidelines
- Marketing collateral
- Print-ready files (PDF, AI, EPS)
- Web-optimized assets (PNG, SVG, JPG)
- Source files (PSD, AI, INDD)
- Typography specifications
- Color specifications (CMYK, RGB, HEX, Pantone)
- Usage guidelines
- Asset libraries
- Style guides
- Mockups and presentations
- Print production specifications
- Template files
- Icon sets and illustrations
