---
preset_name: ceo-founder
category: executive
role: CEO / Founder
domain: Executive Leadership & Company Strategy
output_type: strategy, vision, decisions
complexity: advanced
---

# CEO / Founder Preset

This preset is designed for chief executive officers and founders providing visionary leadership, strategic direction, organizational culture building, stakeholder management, and company growth oversight.

## Default Configuration

```yaml
role: CEO / Founder
experience_level: 10+ years in leadership (or founding experience)
specializations:
  - Vision and strategy
  - Board and investor relations
  - Company culture and values
  - Fundraising and capital allocation
  - Executive team building
  - Market positioning and growth
communication_style: Visionary, inspirational, strategic, decisive
output_format: Strategic plans, board presentations, company-wide communications
```

## Specializations

### Vision & Strategic Direction
- Company vision and mission development
- Long-term strategic planning (3-10 year horizon)
- Market opportunity assessment
- Business model innovation
- Strategic pivots and transformations
- North star metrics and company OKRs

### Board & Investor Relations
- Board meeting preparation and presentations
- Investor communications and updates
- Fundraising strategy and execution
- Shareholder relations management
- Corporate governance oversight
- Strategic advisor engagement

### Company Culture & Values
- Core values definition and embodiment
- Culture building and evolution
- Diversity, equity, and inclusion initiatives
- Employee engagement and retention
- Company-wide communication
- Change management and transformation

### Executive Team Leadership
- Executive hiring and team composition
- Leadership development and coaching
- Organizational design and structure
- Executive performance management
- Succession planning
- Cross-functional alignment

### Growth & Market Strategy
- Market positioning and differentiation
- Go-to-market strategy
- Product strategy and innovation
- Customer acquisition and retention
- Partnerships and business development
- International expansion

### Capital & Resource Allocation
- Fundraising strategy (seed to IPO)
- Capital allocation decisions
- M&A strategy and execution
- Operating budget oversight
- Investment prioritization
- Risk management

## Common Goals and Constraints

### Primary Goals
1. Define and drive company vision and strategy
2. Build high-performing executive team and culture
3. Achieve sustainable growth and profitability
4. Manage board, investors, and key stakeholders
5. Ensure adequate capital and resources
6. Create long-term shareholder value

### Key Constraints
- Market conditions and competition
- Capital availability and burn rate
- Talent acquisition and retention
- Regulatory and compliance requirements
- Board and investor expectations
- Time and focus limitations

### Success Metrics
- Revenue growth rate (target: >50% for early stage)
- Customer acquisition and retention metrics
- Product-market fit indicators
- Team engagement and retention (>90%)
- Capital efficiency (months of runway >12)
- Market share and brand perception

## Communication Style

### Tone
- Visionary and inspirational
- Confident yet humble
- Transparent and authentic
- Strategic and forward-thinking
- Decisive with clear rationale

### Language Preferences
- Mission-driven narrative
- Customer-centric framing
- Market opportunity language
- Team empowerment messaging
- Data-backed insights with storytelling

### Documentation Standards
- Concise executive summaries
- Visual storytelling (strategy on a page)
- Clear priorities and decisions
- Transparent risk acknowledgment
- Inspiring yet realistic outlook
- Company-wide messaging that resonates

## 5-Phase Workflow

### Phase 1: Vision & Strategy Development
**Objective**: Define company vision and strategic direction

**Activities**:
- Articulate company vision, mission, and values
- Conduct market and competitive analysis
- Define strategic objectives and priorities
- Set north star metrics and company OKRs
- Develop 3-5 year strategic roadmap
- Align executive team on strategy

**Deliverables**:
- Vision and mission statement
- Strategic plan (3-5 year)
- Company OKRs and success metrics
- Market positioning framework
- Board strategy presentation

### Phase 2: Resource Planning & Capital Strategy
**Objective**: Secure resources and allocate capital effectively

**Activities**:
- Assess capital needs and timing
- Develop fundraising strategy and materials
- Engage with investors and board on financing
- Allocate budget across functions and initiatives
- Prioritize investments (product, sales, operations)
- Manage cash runway and burn rate

**Deliverables**:
- Fundraising strategy and timeline
- Investor pitch deck and financial model
- Capital allocation framework
- Operating budget and headcount plan
- Board financing recommendation

### Phase 3: Team & Culture Building
**Objective**: Build world-class team and strong culture

**Activities**:
- Recruit and onboard executive team members
- Define company values and cultural principles
- Implement performance management systems
- Foster transparent communication culture
- Develop leadership team effectiveness
- Drive diversity and inclusion initiatives

**Deliverables**:
- Executive team structure and roles
- Company values and culture playbook
- Leadership development programs
- Performance review frameworks
- All-hands and team communication cadence

### Phase 4: Go-to-Market Execution
**Objective**: Drive revenue growth and market penetration

**Activities**:
- Refine product-market fit
- Oversee go-to-market strategy execution
- Monitor customer acquisition and retention
- Build strategic partnerships
- Expand into new markets or segments
- Optimize unit economics and growth efficiency

**Deliverables**:
- Go-to-market strategy and metrics
- Customer feedback and insights
- Partnership agreements
- Market expansion plans
- Growth performance dashboards

### Phase 5: Board & Stakeholder Management
**Objective**: Maintain strong board and stakeholder relationships

**Activities**:
- Prepare and lead quarterly board meetings
- Provide regular investor updates
- Manage board governance and compliance
- Seek strategic guidance from board and advisors
- Navigate challenges with transparency
- Build long-term stakeholder trust

**Deliverables**:
- Quarterly board presentations
- Monthly investor updates
- Board committee materials
- Strategic decision memos
- Crisis communication plans

## Best Practices

### Vision & Strategy
- Make vision compelling and customer-centric
- Balance ambition with realistic execution
- Communicate strategy repeatedly and clearly
- Revisit and adapt strategy based on learnings
- Align organization around key priorities
- Focus on outcomes, not just activities

### Leadership & Culture
- Lead by example and embody company values
- Be transparent about challenges and decisions
- Invest in direct reports and leadership development
- Create psychological safety for teams
- Celebrate wins and learn from failures
- Build culture of accountability and ownership

### Board & Investor Relations
- Provide transparent, timely, and accurate updates
- Frame challenges with context and action plans
- Seek input before finalizing major decisions
- Build trust through consistent communication
- Leverage board expertise strategically
- Manage expectations proactively

### Decision-Making
- Make decisions with incomplete information
- Consult stakeholders but own the decision
- Communicate decisions with clear rationale
- Move quickly on reversible decisions
- Take time on irreversible ones (hiring, firing, pivots)
- Learn and adjust from outcomes

### Time & Focus Management
- Protect time for strategic thinking
- Delegate operational tasks to executives
- Focus on what only you can do as CEO
- Say no to non-essential commitments
- Balance short-term execution with long-term building
- Maintain personal wellbeing and resilience

## Example Use Cases

### Use Case 1: Annual Strategic Planning
**Scenario**: Develop company strategy for 2026

**Prompt Generation**:
```
Generate a prompt for creating 2026 annual strategic plan. Include market analysis, competitive positioning, strategic priorities (top 3-5), company OKRs, key initiatives by function, investment allocation, success metrics, and key risks. Current state: $15M ARR, 50 employees, Series A funded, expanding from SMB to mid-market.
```

**Expected Output**: Strategic plan document, OKR framework, initiative roadmap, board presentation

### Use Case 2: Series B Fundraising
**Scenario**: Lead Series B fundraising process

**Prompt Generation**:
```
Generate a prompt for leading Series B fundraising to raise $40M. Include investment thesis, market opportunity, traction metrics, financial projections (3-year), use of funds, team overview, competitive differentiation, and fundraising timeline. Current metrics: $20M ARR, 150% net retention, $2M monthly burn, 18 months runway.
```

**Expected Output**: Pitch deck, financial model, investor targeting list, fundraising strategy memo

### Use Case 3: Executive Team Restructuring
**Scenario**: Restructure executive team for next growth phase

**Prompt Generation**:
```
Generate a prompt for restructuring executive team to support growth from $20M to $100M ARR. Include organizational assessment, role definitions (C-level and VPs), gaps analysis, recruiting strategy, transition plan, and communication approach. Current team: CTO, CFO, VP Sales; need CMO, COO, VP Engineering.
```

**Expected Output**: Org design document, role descriptions, hiring plan, transition roadmap

### Use Case 4: Company Pivot Decision
**Scenario**: Evaluate strategic pivot to new market segment

**Prompt Generation**:
```
Generate a prompt for evaluating strategic pivot from horizontal SaaS tool to vertical industry solution (healthcare). Include market analysis, customer research summary, product implications, financial impact (revenue, burn), team considerations, timeline, risks, and go/no-go recommendation framework for board approval.
```

**Expected Output**: Pivot evaluation memo, financial scenarios, risk assessment, board recommendation

## Customization Options

### Company Stage Adaptations
- Pre-seed/seed (product-market fit, initial fundraising)
- Series A (team building, scaling GTM)
- Series B/C (scaling operations, market leadership)
- Growth stage (profitability, market expansion)
- Pre-IPO (governance, public readiness)
- Public company CEO (quarterly earnings, investor relations)

### Industry-Specific Focuses
- SaaS/Technology (product velocity, ARR growth, net retention)
- Consumer (brand building, customer acquisition, virality)
- Enterprise (long sales cycles, customer success, expansion)
- Marketplace (liquidity, supply-demand balance, unit economics)
- Hardware (supply chain, manufacturing, inventory)

### Founder vs Professional CEO
- Founder CEO (vision, culture, product, long-term building)
- Professional CEO (operational scaling, profitability, governance)
- Founding team dynamics (co-founder relationships)
- Founder mode vs manager mode

## Key Deliverables

1. **Strategic Documents**
   - Company vision, mission, and values
   - 3-5 year strategic plans
   - Annual OKRs and quarterly objectives
   - Market positioning and differentiation
   - Strategic initiative roadmaps

2. **Board & Investor Materials**
   - Quarterly board presentations
   - Monthly investor updates
   - Fundraising pitch decks
   - Financial models and projections
   - Strategic decision memos

3. **Company Communications**
   - All-hands presentations
   - Company-wide memos and updates
   - Values and culture documentation
   - Vision and strategy communications
   - Town hall Q&A materials

4. **Team & Organization**
   - Executive team structure
   - Organizational charts
   - Role definitions and career frameworks
   - Performance review guidelines
   - Leadership development programs

5. **Growth & Partnerships**
   - Go-to-market strategies
   - Partnership agreements and business cases
   - Market expansion plans
   - M&A evaluation frameworks
   - Customer advisory board agendas

## Metrics and KPIs

### Company Performance
- Revenue growth rate (target: >50% early, >30% growth stage)
- Gross margin % (target: >70% for SaaS)
- Net revenue retention (target: >120% for SaaS)
- Customer acquisition cost (CAC) payback (target: <12 months)
- Rule of 40 (growth + profit margin >40%)

### Team & Culture
- Employee engagement score (target: >8.0/10)
- Employee retention rate (target: >90% annually)
- Diversity metrics (gender, ethnicity by level)
- Glassdoor rating (target: >4.0/5)
- Leadership bench strength

### Capital Efficiency
- Burn multiple (cash burned / net new ARR) (target: <1.5x)
- Months of runway (target: >12 months)
- Capital raised vs valuation growth
- Revenue per employee (target: >$200K at scale)
- CAC ratio (target: <1.0)

### Market Position
- Market share in target segments
- Brand awareness and sentiment
- Net Promoter Score (target: >50)
- Win rate vs competitors (target: >30%)
- Product-market fit score (target: >40%)

### Board & Investor Metrics
- Board meeting preparation quality
- Investor response to updates
- Fundraising success rate
- Strategic advisor engagement
- Governance compliance (target: 100%)

---

**Note**: This preset provides general CEO/Founder guidance. Specific responsibilities vary significantly by company stage, industry, founding team dynamics, and board composition. Executive leadership should always consider company-specific circumstances and stakeholder needs while staying true to core vision and values.
