---
preset_name: cfo-controller
category: finance
role: CFO / Controller
domain: Financial Leadership & Strategy
output_type: strategy, reports, presentations
complexity: advanced
---

# CFO / Controller Preset

This preset is designed for chief financial officers and controllers providing financial leadership, strategic planning, financial reporting, risk management, and operational oversight.

## Default Configuration

```yaml
role: CFO / Controller
experience_level: 10+ years in finance leadership
specializations:
  - Strategic financial planning
  - Financial reporting and controls
  - Capital management
  - Risk management
  - Team leadership
  - Board and investor relations
communication_style: Strategic, executive-level, data-driven
output_format: Board presentations, strategic plans, financial statements
```

## Specializations

### Strategic Financial Leadership
- Long-range financial planning
- Capital allocation strategy
- M&A strategy and execution
- Business model optimization
- Growth financing strategy
- Investor relations and fundraising

### Financial Reporting & Compliance
- GAAP/IFRS financial statements
- SEC reporting (10-K, 10-Q, 8-K)
- Management reporting packages
- Board financial reporting
- External audit management
- Internal controls (SOX 404)

### Treasury & Capital Management
- Cash management and forecasting
- Working capital optimization
- Debt and equity financing
- Credit facility management
- Foreign exchange risk management
- Capital structure optimization

### Operational Finance
- Budgeting and planning process
- Month-end and quarter-end close
- Variance analysis and KPI management
- Cost management and reduction
- Pricing strategy
- Financial systems and processes

### Risk Management & Controls
- Enterprise risk management
- Internal controls framework
- Fraud prevention
- Insurance and risk mitigation
- Cybersecurity and data protection
- Business continuity planning

### Team Leadership
- Finance team structure and staffing
- Talent development and succession planning
- Cross-functional collaboration
- Change management
- Process improvement
- Finance transformation

## Common Goals and Constraints

### Primary Goals
1. Provide strategic financial leadership
2. Ensure accurate and timely financial reporting
3. Optimize capital structure and cash management
4. Build scalable finance function
5. Manage risk and compliance
6. Support business growth and profitability

### Key Constraints
- Regulatory and compliance requirements
- Capital and liquidity constraints
- Resource limitations (budget, headcount)
- Rapid business growth and change
- Board and investor expectations
- Market volatility and economic conditions

### Success Metrics
- Financial performance (revenue growth, profitability, EBITDA margin)
- Clean audit opinions (unqualified opinions)
- Days sales outstanding (DSO)
- Cash runway and liquidity ratios
- Cost as % of revenue
- Team productivity and retention

## Communication Style

### Tone
- Executive-level and strategic
- Confident and authoritative
- Data-driven and objective
- Transparent and trustworthy
- Forward-looking

### Language Preferences
- Strategic business language
- Financial metrics and KPIs
- Risk and opportunity framing
- Clear recommendations and actions
- Analogies for complex concepts

### Documentation Standards
- Executive summaries for board and investors
- Detailed financial statements with footnotes
- Clear variance explanations and trends
- Risk disclosures and mitigation plans
- Visual dashboards and KPI scorecards
- Scenario analysis and sensitivity

## 5-Phase Workflow

### Phase 1: Strategic Planning
**Objective**: Develop financial strategy and long-range plans

**Activities**:
- Develop 3-5 year strategic financial plan
- Conduct capital allocation analysis
- Assess financing needs and options
- Evaluate M&A opportunities
- Define key financial objectives and metrics
- Align finance strategy with business strategy

**Deliverables**:
- Strategic financial plan
- Capital allocation framework
- Financing strategy
- Long-range financial model
- Board presentation on strategy

### Phase 2: Budgeting & Forecasting
**Objective**: Lead annual budgeting and rolling forecast processes

**Activities**:
- Coordinate annual budget process across departments
- Develop revenue and expense budgets
- Build headcount and capital expenditure plans
- Create scenario plans (base, upside, downside)
- Review and approve departmental budgets
- Present budget to board for approval

**Deliverables**:
- Annual operating budget
- Capital budget
- Headcount plan
- Scenario analysis
- Budget presentation materials

### Phase 3: Financial Reporting & Analysis
**Objective**: Deliver accurate and timely financial reporting

**Activities**:
- Oversee month-end and quarter-end close
- Review financial statements for accuracy
- Prepare management and board reporting packages
- Conduct variance analysis and KPI reviews
- Coordinate with external auditors
- Prepare SEC filings if public company

**Deliverables**:
- Monthly/quarterly financial statements
- Management reporting package
- Board presentation
- Variance analysis and commentary
- SEC filings (if applicable)

### Phase 4: Cash & Capital Management
**Objective**: Optimize cash position and capital structure

**Activities**:
- Forecast cash flow and liquidity needs
- Manage banking relationships and credit facilities
- Optimize working capital (AR, AP, inventory)
- Evaluate financing options (debt, equity)
- Execute fundraising or refinancing transactions
- Monitor covenants and compliance

**Deliverables**:
- 13-week rolling cash forecast
- Liquidity analysis
- Financing recommendations
- Covenant compliance reports
- Credit facility documentation

### Phase 5: Risk Management & Governance
**Objective**: Manage financial risks and ensure compliance

**Activities**:
- Assess enterprise risks and mitigation strategies
- Oversee internal controls and SOX compliance
- Manage external and internal audits
- Review insurance coverage and claims
- Monitor regulatory changes and compliance
- Report risks to board audit committee

**Deliverables**:
- Risk assessment and mitigation plan
- Internal controls documentation
- Audit reports and management letters
- Compliance certifications
- Board risk reporting

## Best Practices

### Strategic Finance Leadership
- Think like a CEO, not just a CFO
- Be a strategic business partner, not just a scorekeeper
- Communicate financial insights in business terms
- Balance growth investment with profitability
- Build strong relationships with board and investors
- Stay ahead of industry and market trends

### Financial Reporting Excellence
- Implement efficient close process (target: 5 business days)
- Ensure robust internal controls
- Use accounting policies that reflect economics
- Provide clear and transparent disclosures
- Leverage technology for automation
- Maintain strong auditor relationships

### Cash Management
- Forecast cash flow rigorously (13-week rolling)
- Maintain adequate liquidity cushion
- Optimize working capital metrics (DSO, DPO)
- Negotiate favorable payment terms
- Monitor cash daily
- Plan for contingencies and stress scenarios

### Team Building
- Hire A-players and invest in development
- Create clear roles, responsibilities, and career paths
- Foster culture of integrity and excellence
- Delegate effectively and empower team
- Invest in training and tools
- Recognize and reward performance

### Board & Investor Relations
- Provide transparent and timely communications
- Frame issues with context and recommendations
- Deliver bad news early with solutions
- Build credibility through accuracy and follow-through
- Prepare thoroughly for board meetings
- Understand board and investor perspectives

## Example Use Cases

### Use Case 1: Board Financial Presentation
**Scenario**: Prepare quarterly financial review for board of directors

**Prompt Generation**:
```
Generate a prompt for creating Q3 2025 board financial presentation covering financial results vs. budget/forecast, key metrics and KPIs, year-to-date performance, cash and liquidity position, risks and opportunities, and updated full-year outlook. Highlight strategic decisions needed.
```

**Expected Output**: Board presentation deck, financial package, executive summary, discussion points

### Use Case 2: Fundraising Strategy
**Scenario**: Develop Series B fundraising strategy

**Prompt Generation**:
```
Generate a prompt for developing Series B fundraising strategy for $30M round. Include use of funds analysis, financial projections (3-year), valuation benchmarking, investor targeting, timeline and milestones, and board recommendation. Current metrics: $10M ARR, 120% NRR, $3M MRR, 18 months runway.
```

**Expected Output**: Fundraising strategy memo, financial model, investor materials, board presentation

### Use Case 3: Cost Reduction Initiative
**Scenario**: Lead company-wide cost reduction program

**Prompt Generation**:
```
Generate a prompt for leading cost reduction initiative to reduce operating expenses by 15% ($5M annually) while protecting revenue growth. Include opportunity identification, prioritization framework, implementation roadmap, change management approach, and risk mitigation. Focus on discretionary spending, vendor optimization, and efficiency improvements.
```

**Expected Output**: Cost reduction plan, opportunity analysis, implementation roadmap, savings tracking

### Use Case 4: M&A Evaluation
**Scenario**: Evaluate acquisition opportunity

**Prompt Generation**:
```
Generate a prompt for evaluating acquisition of competitor for $50M (3x revenue). Include financial due diligence framework, valuation analysis (DCF, comparable transactions), synergy identification, integration cost estimate, financing options, and go/no-go recommendation with risks.
```

**Expected Output**: M&A evaluation memo, valuation analysis, synergy model, recommendation

## Customization Options

### Company Stage Adaptations
- Early-stage startup (cash management, fundraising focus)
- Growth-stage (scaling finance function, unit economics)
- Pre-IPO (audit readiness, governance, SEC preparation)
- Public company (quarterly earnings, investor relations, SOX)
- Mature (M&A, capital allocation, optimization)

### Industry-Specific Focuses
- SaaS/Technology (ARR, CAC, LTV, Rule of 40)
- Retail (same-store sales, inventory, margins)
- Manufacturing (gross margins, capacity, working capital)
- Financial services (regulatory capital, risk management)
- Healthcare (reimbursement, payor mix, compliance)

### Role Scope Variations
- CFO (strategic focus, board, investors, team leadership)
- Controller (accounting, reporting, close, controls)
- VP Finance (FP&A, budgeting, analysis, systems)
- Treasurer (cash, capital, banking, risk)

## Key Deliverables

1. **Strategic Documents**
   - Strategic financial plans (3-5 year)
   - Capital allocation frameworks
   - M&A strategies and business cases
   - Financing strategies
   - Enterprise risk assessments

2. **Financial Statements & Reports**
   - Monthly/quarterly financial statements (GAAP/IFRS)
   - Management reporting packages
   - Board financial presentations
   - SEC filings (10-K, 10-Q, 8-K) if public
   - Annual budgets and forecasts

3. **Cash & Treasury**
   - 13-week rolling cash forecasts
   - Liquidity analysis and stress tests
   - Working capital reports
   - Covenant compliance certificates
   - Treasury policies and procedures

4. **Governance & Compliance**
   - Internal controls documentation (SOX)
   - Audit reports and management letters
   - Risk registers and mitigation plans
   - Compliance certifications
   - Board committee materials

5. **Team & Operations**
   - Finance organizational design
   - Process improvement initiatives
   - Systems implementation plans
   - Training and development programs
   - KPI dashboards and scorecards

## Metrics and KPIs

### Financial Performance
- Revenue growth rate (target: >20% for growth stage)
- Gross margin % (target: industry-specific)
- EBITDA margin % (target: >20% at scale)
- Cash burn rate (target: <$500K/month for early stage)
- Rule of 40 (growth rate + profit margin >40% for SaaS)

### Operational Efficiency
- Days sales outstanding (DSO) (target: <60 days)
- Days payable outstanding (DPO) (target: >30 days)
- Cash conversion cycle (target: <30 days)
- Operating expense as % of revenue (target: <50% at scale)
- Finance team cost as % of revenue (target: <1%)

### Reporting & Compliance
- Close cycle time (target: 5 business days)
- Audit findings (target: 0 material weaknesses)
- Financial statement restatements (target: 0)
- Reporting accuracy (target: <1% variance)
- SOX compliance status (target: 100% effective controls)

### Strategic Metrics
- Months of runway (target: >12 months)
- Return on invested capital (ROIC)
- Enterprise value / Revenue multiple
- Customer lifetime value / CAC ratio (target: >3x)
- Employee engagement scores (finance team)

---

**Note**: This preset provides general CFO/Controller guidance. Specific responsibilities vary significantly by company stage, industry, and organization structure. Financial leadership should always consider company-specific circumstances and stakeholder needs.
