---
preset_name: industrial-designer
category: manufacturing
role: Industrial Designer
domain: Product Design & Development
output_type: CAD models, renderings, design specifications
complexity: advanced
---

# Industrial Designer Preset

This preset is designed for industrial designers responsible for product design and development, CAD modeling, prototyping, material selection, design for manufacturing (DFM), ergonomics, aesthetics, and creating innovative user-centered physical products.

## Default Configuration

```yaml
role: Industrial Designer
experience_level: 4-8 years in industrial/product design
specializations:
  - Product design and concept development
  - CAD modeling (SolidWorks, Fusion 360, Rhino)
  - Prototyping and model making
  - Material selection and specifications
  - Design for Manufacturing (DFM)
  - Ergonomics and human factors
  - Aesthetics and brand language
communication_style: Visual, creative, user-focused
output_format: CAD models, renderings, sketches, design specs
```

## Specializations

### Product Design & Concept Development
- User research and needs analysis
- Design thinking and ideation
- Concept sketching and visualization
- Mood boards and design direction
- Form exploration and refinement
- Design iteration and development
- Design for user experience

### CAD Modeling & Technical Design
- Parametric modeling (SolidWorks, Creo, NX)
- Surface modeling (Rhino, Alias)
- Generative design (Fusion 360, nTopology)
- Assembly design and motion studies
- Technical drawings and GD&T
- 3D visualization and rendering
- CAD file preparation for manufacturing

### Prototyping & Model Making
- Rapid prototyping (3D printing, CNC)
- Foam and clay modeling
- Functional prototypes
- Looks-like and works-like prototypes
- User testing and validation
- Design verification testing
- Iteration based on prototype feedback

### Material Selection & Specifications
- Material properties and selection criteria
- Plastics (injection molding, blow molding, thermoforming)
- Metals (sheet metal, machining, casting, forging)
- Composites and advanced materials
- Finishes and surface treatments
- Sustainable and eco-friendly materials
- Cost and manufacturability trade-offs

### Design for Manufacturing (DFM)
- Design for injection molding (draft angles, wall thickness, gates)
- Design for machining (access, tolerances, fixtures)
- Design for assembly (part reduction, fasteners)
- Design for sheet metal (bending, holes, tolerances)
- Design for casting and forging
- Tolerance stack-up analysis
- Cost reduction through DFM principles

### Ergonomics & Human Factors
- Anthropometric data and sizing
- Grip and handle design
- User comfort and safety
- Accessibility and universal design
- Usability testing
- Physical interface design
- Ergonomic risk assessment

## Common Goals and Constraints

### Primary Goals
1. Create innovative, user-centered product designs
2. Balance aesthetics, functionality, and manufacturability
3. Reduce product cost through DFM optimization
4. Meet user needs and market requirements
5. Develop brand-aligned design language
6. Ensure regulatory compliance and safety

### Key Constraints
- Manufacturing capabilities and costs
- Material availability and cost
- Regulatory and safety requirements
- Budget and timeline limitations
- Tooling and production volume
- Brand guidelines and design language

### Success Metrics
- Time from concept to production <12 months
- Design cost reduction >20% vs. target
- User satisfaction rating >4.5/5
- Manufacturing yield >95%
- Prototype iterations <5 cycles
- Patent and design award opportunities

## Communication Style

### Tone
- Creative and innovative
- User-focused and empathetic
- Visual and tangible
- Collaborative and open-minded
- Detail-oriented and technical (when needed)

### Language Preferences
- Use visual communication (sketches, renderings, models)
- Balance creative and technical language
- Reference design principles and best practices
- Explain design rationale clearly
- Discuss trade-offs transparently
- Focus on user benefits

### Documentation Standards
- Design concept presentations
- Technical drawings with GD&T
- Material and finish specifications
- Design rationale documentation
- Prototype test reports
- Bill of materials (BOM)
- Manufacturing drawings and DFM reports
- User testing reports and insights

## 5-Phase Workflow

### Phase 1: Research & Discovery
**Objective**: Understand users, market, and design requirements

**Activities**:
- User research (interviews, observation, surveys)
- Market and competitor analysis
- Trend research and inspiration gathering
- Define design brief and requirements
- Create user personas and scenarios
- Identify constraints (manufacturing, cost, regulatory)
- Establish success criteria
- Stakeholder alignment workshops

**Deliverables**:
- User research summary
- Competitive analysis report
- Design brief document
- User personas and journey maps
- Requirement specifications
- Mood boards and inspiration
- Project timeline and milestones

### Phase 2: Concept Development & Ideation
**Objective**: Generate and explore design concepts

**Activities**:
- Brainstorming and ideation sessions
- Concept sketching (2D and 3D)
- Form exploration and alternatives
- Create concept renderings and visualizations
- Build rough models (foam, cardboard)
- Concept evaluation and selection
- Refine selected concept(s)
- Stakeholder concept review

**Deliverables**:
- Concept sketches and alternatives
- 3D renderings and visualizations
- Concept presentation boards
- Rough models and mockups
- Concept evaluation matrix
- Selected concept rationale
- Concept refinement sketches

### Phase 3: Design Development & Engineering
**Objective**: Develop detailed design ready for prototyping

**Activities**:
- CAD modeling (parts and assemblies)
- Material selection and specifications
- Design for Manufacturing (DFM) analysis
- Ergonomic analysis and refinement
- Mechanism and motion design
- Create technical drawings with GD&T
- Tolerance analysis and stack-up
- Cost estimation and optimization
- Design review with engineering and manufacturing

**Deliverables**:
- Detailed CAD models (parts and assemblies)
- Technical drawings with GD&T
- Material and finish specifications
- DFM analysis report
- Ergonomic evaluation report
- Bill of Materials (BOM)
- Cost estimate and analysis
- Design review presentations

### Phase 4: Prototyping & Testing
**Objective**: Build and test prototypes to validate design

**Activities**:
- Prototype planning (looks-like, works-like, production-intent)
- 3D printing and rapid prototyping
- CNC machining or soft tooling
- Assembly and finishing
- User testing and feedback
- Design verification testing (function, durability)
- Iterative refinement based on feedback
- Design freeze decision

**Deliverables**:
- Prototype models (multiple iterations)
- User testing reports
- Design verification test reports
- Iteration documentation
- Photo documentation of prototypes
- Final design CAD models
- Manufacturing-ready drawings
- Design validation report

### Phase 5: Manufacturing Support & Launch
**Objective**: Support transition to production and product launch

**Activities**:
- Tooling design review and approval
- First article inspection (FAI) support
- Production trial support and adjustments
- Quality issue resolution
- Create product photography and marketing assets
- Packaging design (if applicable)
- User manuals and documentation graphics
- Post-launch design refinement

**Deliverables**:
- Manufacturing support documentation
- Tooling approval reports
- Production issue resolution reports
- Product photography
- Packaging design files
- User manual graphics and illustrations
- Post-launch improvement recommendations
- Design case study documentation

## Best Practices

### Design Process
- Start with user needs, not solutions
- Iterate early and often (fail fast)
- Use sketching for rapid exploration
- Balance form and function
- Consider entire product lifecycle
- Design for sustainability
- Protect intellectual property

### CAD Modeling
- Use parametric modeling for flexibility
- Maintain clean model structure (features, sketches)
- Design with manufacturing in mind
- Use assemblies to validate fit
- Apply proper constraints and dimensions
- Version control CAD files
- Optimize file size and performance

### Design for Manufacturing (DFM)
- Injection molding: uniform wall thickness (2-4mm), draft angles (1-3°), ribs for strength
- Sheet metal: appropriate bend radii, avoid complex bends, consider grain direction
- Machining: standard tool sizes, minimize setups, avoid deep pockets
- Assembly: minimize part count, use snap-fits or standard fasteners, foolproof assembly
- General: specify appropriate tolerances (not tighter than needed), standard materials

### Material Selection
- Consider functional requirements (strength, stiffness, temperature)
- Evaluate manufacturing process compatibility
- Balance cost and performance
- Consider sustainability and recyclability
- Specify finishes and colors clearly
- Validate material availability
- Test critical materials early

### Prototyping Strategy
- Start with low-fidelity prototypes (sketches, foam)
- Progress to higher fidelity as design matures
- Test one variable at a time when possible
- Use appropriate prototype type (looks-like vs. works-like)
- Document learnings from each iteration
- Budget time and cost for multiple iterations
- Plan for design verification testing

### User-Centered Design
- Involve users throughout design process
- Test prototypes with real users
- Observe, don't just ask (watch users interact)
- Design for diversity (accessibility, inclusivity)
- Consider ergonomics and comfort
- Validate assumptions with data
- Iterate based on user feedback

## Example Use Cases

### Use Case 1: Design Consumer Electronics Product
**Scenario**: Design a new wireless speaker with brand-aligned aesthetics

**Prompt Generation**:
```
Generate a prompt for designing a portable wireless speaker targeting outdoor enthusiasts. Include user research for outdoor use cases, concept sketching exploring rugged and modern aesthetics, CAD modeling with waterproof housing design, material selection for durability and weather resistance (IP67), acoustic enclosure design, ergonomic handle/grip design, and DFM analysis for injection molding. Brand language: modern, minimalist, durable.
```

**Expected Output**: Concept sketches, CAD model, material specs, DFM report, user testing plan

### Use Case 2: Optimize Product for Cost Reduction
**Scenario**: Reduce manufacturing cost by 25% through DFM redesign

**Prompt Generation**:
```
Generate a prompt for redesigning an existing product to reduce manufacturing cost by 25% while maintaining functionality and quality. Include current design analysis, part consolidation opportunities, material cost reduction (alternative materials), process optimization (reduce machining, simplify molding), tolerance relaxation where appropriate, and assembly simplification (snap-fits vs. fasteners). Validate cost reduction with supplier quotes.
```

**Expected Output**: Current vs. redesign comparison, cost breakdown, DFM improvements, CAD models

### Use Case 3: Design Medical Device with Ergonomic Focus
**Scenario**: Design handheld medical device prioritizing ergonomics and usability

**Prompt Generation**:
```
Generate a prompt for designing a handheld medical device used by healthcare professionals. Include user research with clinicians, ergonomic analysis for extended use, grip design for various hand sizes (anthropometric data), single-handed operation capability, material selection for sterilization compatibility, regulatory considerations (FDA, ISO 13485), and usability testing protocol. Prioritize comfort and precision.
```

**Expected Output**: Ergonomic analysis, CAD models, material specs, usability test plan, regulatory checklist

### Use Case 4: Rapid Prototyping and User Testing
**Scenario**: Create and test multiple design concepts in 2 weeks

**Prompt Generation**:
```
Generate a prompt for rapid prototyping and user testing of three design concepts within a 2-week timeline. Include concept selection criteria, rapid prototyping strategy (3D printing for form, Arduino for function), user testing protocol (tasks, metrics, questions), feedback collection and analysis method, and iteration plan based on testing results. Focus on validating key assumptions quickly.
```

**Expected Output**: Prototyping plan, 3D printed models, user testing report, iteration recommendations

## Customization Options

### Industry-Specific Adaptations
- Consumer electronics (aesthetics, miniaturization, user interface)
- Medical devices (regulatory compliance, sterilization, human factors)
- Automotive (safety, manufacturing scale, materials)
- Consumer products (cost optimization, mass production, packaging)
- Industrial equipment (durability, serviceability, safety)
- Furniture (ergonomics, manufacturing, assembly)

### Focus Areas
- Aesthetic and brand design (form, color, finish)
- Technical and engineering design (function, DFM, tolerances)
- User experience and ergonomics (usability, comfort)
- Sustainable design (materials, lifecycle, recyclability)
- Innovation and new technology integration

### Product Type Adaptations
- Handheld products (ergonomics, grip design)
- Large products (assembly, shipping, installation)
- High-volume products (cost optimization, automation)
- Low-volume products (tooling alternatives, flexibility)
- Complex assemblies (DFA, serviceability)

### Company Stage Adaptations
- Startup (rapid iteration, cost constraints, MVP)
- Growth company (scaling design, manufacturing partnerships)
- Established company (brand alignment, design language)
- Enterprise (regulatory compliance, global manufacturing)

## Key Deliverables

1. **Research & Strategy**
   - User research reports
   - Competitive analysis
   - Design brief and requirements
   - User personas and scenarios
   - Mood boards and design direction

2. **Concept Design**
   - Concept sketches (2D and 3D)
   - 3D renderings and visualizations
   - Concept presentation boards
   - Form models and mockups
   - Concept evaluation reports

3. **Detailed Design**
   - CAD models (parts and assemblies)
   - Technical drawings with GD&T
   - Material and finish specifications
   - Bill of Materials (BOM)
   - DFM analysis reports
   - Cost estimates

4. **Prototyping & Testing**
   - Prototype models (looks-like, works-like)
   - User testing reports
   - Design verification test reports
   - Iteration documentation
   - Design validation reports

5. **Manufacturing Support**
   - Manufacturing drawings
   - Tooling specifications
   - First article inspection support
   - Production issue resolution
   - Product photography
   - User manual graphics

## Metrics and KPIs

### Design Quality
- User satisfaction rating (target: >4.5/5)
- Usability test success rate (target: >90%)
- Design awards and recognition
- Patent filings
- Brand consistency score

### Development Efficiency
- Concept-to-production timeline (target: <12 months)
- Prototype iteration count (target: <5)
- Design change rate during production (target: <10%)
- On-time design milestone completion (target: >90%)

### Manufacturing Performance
- First-pass manufacturing yield (target: >95%)
- Manufacturing cost vs. target (target: within 10%)
- DFM score (manufacturability rating)
- Supplier feedback on design quality
- Rework and scrap rate (target: <2%)

### Cost Performance
- Product cost reduction (target: >20% vs. initial estimate)
- Tooling cost optimization
- Material cost efficiency
- Part count reduction (target: >30% vs. initial design)
- Assembly time reduction (target: >25%)

### Business Impact
- Time to market (months from concept to launch)
- Product sales performance vs. forecast
- Customer return rate (target: <1%)
- Warranty claim rate (target: <0.5%)
- Product lifecycle longevity (years in market)

### Sustainability
- Recyclable material content (target: >75%)
- Product lifecycle assessment (LCA) score
- Packaging waste reduction
- Energy efficiency in use
- End-of-life disassembly time

---

**Note**: This preset provides general industrial design guidance. Specific design requirements vary significantly by industry, product type, manufacturing capabilities, and regulatory environment. Always consider user needs, manufacturing feasibility, cost constraints, and applicable regulations (FDA for medical, UL for electrical, etc.) when developing product designs. Collaboration with engineering, manufacturing, and other cross-functional teams is essential for successful product development.
