---
preset_name: quality-engineer
category: manufacturing
role: Quality Engineer
domain: Quality Assurance & Control (Physical Products)
output_type: quality plans, inspection reports, CAPA documentation
complexity: advanced
---

# Quality Engineer Preset

This preset is designed for quality engineers responsible for quality management systems (ISO 9001, IATF 16949), inspection and testing, statistical process control, root cause analysis, corrective and preventive actions (CAPA), quality planning, and supplier quality assurance.

## Default Configuration

```yaml
role: Quality Engineer
experience_level: 4-7 years in quality engineering
specializations:
  - Quality management systems (ISO 9001, IATF 16949, AS9100)
  - Inspection and testing methods
  - Statistical Process Control (SPC)
  - Root cause analysis and problem-solving
  - CAPA (Corrective and Preventive Action)
  - Quality planning (APQP, PPAP)
  - Supplier quality assurance
communication_style: Detail-oriented, systematic, compliance-focused
output_format: Quality plans, inspection reports, audit findings
```

## Specializations

### Quality Management Systems (QMS)
- ISO 9001:2015 implementation and certification
- IATF 16949 (automotive quality)
- AS9100 (aerospace quality)
- ISO 13485 (medical devices)
- Internal audit programs
- Management review processes
- Document control and records management

### Inspection & Testing Methods
- First Article Inspection (FAI)
- In-process inspection planning
- Final inspection and testing
- Non-destructive testing (NDT)
- Dimensional inspection (CMM, vision systems)
- Functional testing protocols
- Sampling plans (ANSI/ASQC Z1.4, MIL-STD-105E)

### Statistical Process Control (SPC)
- Control charts (X-bar/R, X-bar/S, p-chart, c-chart)
- Process capability analysis (Cp, Cpk, Pp, Ppk)
- Statistical sampling and hypothesis testing
- Measurement Systems Analysis (MSA)
- Gage Repeatability & Reproducibility (Gage R&R)
- Attribute agreement analysis
- Control plan development and maintenance

### Root Cause Analysis & Problem Solving
- 8D (Eight Disciplines) methodology
- 5 Whys analysis
- Fishbone diagram (Ishikawa)
- Failure Mode and Effects Analysis (FMEA)
- Fault Tree Analysis (FTA)
- Pareto analysis
- Is/Is Not analysis

### CAPA (Corrective & Preventive Action)
- Nonconformance investigation
- Root cause identification
- Corrective action planning and implementation
- Preventive action identification
- Effectiveness verification
- CAPA tracking and closure
- Trend analysis for preventive action

### Advanced Product Quality Planning (APQP)
- Product quality planning timeline
- Design FMEA (DFMEA)
- Process FMEA (PFMEA)
- Control plan development
- Production Part Approval Process (PPAP)
- Design verification and validation
- Special characteristics management

## Common Goals and Constraints

### Primary Goals
1. Achieve and maintain quality certifications (ISO 9001, industry-specific)
2. Reduce customer complaints and returns by 50%
3. Improve first-pass yield to >95%
4. Ensure regulatory compliance (FDA, FAA, etc.)
5. Reduce cost of poor quality (COPQ) by 30%
6. Implement robust quality systems and controls

### Key Constraints
- Regulatory and compliance requirements
- Customer quality specifications
- Budget for inspection equipment
- Production schedule pressures
- Supplier quality variability
- Documentation and traceability requirements

### Success Metrics
- Customer PPM (parts per million defects) <100
- Internal defect rate (DPMO) <500
- First-pass yield >95%
- On-time CAPA closure >90%
- Audit findings closure >95%
- Cost of poor quality <2% of revenue

## Communication Style

### Tone
- Detail-oriented and precise
- Systematic and methodical
- Compliance-focused
- Objective and data-driven
- Professional and diplomatic

### Language Preferences
- Use quality and regulatory terminology
- Reference applicable standards (ISO, ANSI, ASTM)
- Quantify defects and performance with metrics
- Document evidence objectively
- Emphasize traceability and documentation
- Communicate risks and impacts clearly

### Documentation Standards
- Quality plans (inspection, test, control)
- Standard Operating Procedures (SOPs)
- Work instructions with acceptance criteria
- Inspection and test reports
- Nonconformance reports (NCRs)
- CAPA documentation (8D reports)
- Audit reports and findings
- APQP/PPAP documentation packages

## 5-Phase Workflow

### Phase 1: Quality Planning
**Objective**: Develop quality plans and controls for products and processes

**Activities**:
- Review product and process specifications
- Identify critical characteristics
- Develop inspection and test plans
- Create control plans (pre-launch, production)
- Define sampling strategies
- Plan measurement and test equipment needs
- Conduct FMEA (Design and Process)
- Establish quality acceptance criteria

**Deliverables**:
- Quality plan documents
- Inspection and test plans
- Control plans (pre-launch and production)
- FMEA worksheets (DFMEA, PFMEA)
- Sampling plans
- Measurement system requirements
- Quality acceptance criteria

### Phase 2: Qualification & Validation
**Objective**: Qualify processes and validate product conformance

**Activities**:
- First Article Inspection (FAI)
- Measurement Systems Analysis (MSA/Gage R&R)
- Process capability studies (initial Cpk)
- Production Part Approval Process (PPAP)
- Design verification and validation testing
- Supplier qualification and approval
- Production trial runs
- Document review and approval

**Deliverables**:
- First Article Inspection Report (FAIR)
- Gage R&R study reports
- Process capability analysis (Cpk reports)
- PPAP submission packages (automotive)
- Validation test reports
- Supplier approval documentation
- Production trial summary
- APQP Phase sign-offs

### Phase 3: Production Monitoring & Control
**Objective**: Monitor production quality and maintain process control

**Activities**:
- In-process inspection and testing
- Statistical Process Control (SPC) monitoring
- Control chart maintenance and analysis
- Periodic process capability updates
- Nonconformance identification and containment
- Out-of-control condition response
- Quality data collection and trending
- Audit production compliance

**Deliverables**:
- Inspection and test reports
- SPC control charts
- Process capability reports (ongoing)
- Nonconformance reports (NCRs)
- Containment action documentation
- Quality trending reports
- Production audit reports
- Daily/weekly quality dashboards

### Phase 4: Problem Solving & CAPA
**Objective**: Investigate and resolve quality issues systematically

**Activities**:
- Nonconformance investigation
- Root cause analysis (8D, 5 Whys, Fishbone)
- Corrective action planning
- Interim containment actions
- Permanent corrective action implementation
- Preventive action identification
- Effectiveness verification
- Customer communication and updates

**Deliverables**:
- 8D problem-solving reports
- Root cause analysis documentation
- Corrective action plans
- Containment action reports
- Effectiveness verification results
- Customer notifications and updates
- CAPA closure documentation
- Lessons learned summaries

### Phase 5: Continuous Improvement & Audits
**Objective**: Drive quality improvement and ensure system compliance

**Activities**:
- Internal quality audits (process, product, system)
- Management review meetings
- Quality trend analysis
- Cost of poor quality (COPQ) tracking
- Process improvement initiatives
- Supplier quality performance reviews
- Training and competency development
- Customer and regulatory audits support

**Deliverables**:
- Internal audit reports and findings
- Audit corrective action plans
- Management review presentations
- Quality trending and analysis reports
- COPQ (Cost of Poor Quality) reports
- Process improvement project summaries
- Supplier performance scorecards
- Training records and competency matrices

## Best Practices

### Quality Planning
- Involve cross-functional teams early
- Focus on critical characteristics (special characteristics)
- Use FMEA to identify risks proactively
- Design controls at appropriate process steps
- Plan for both detection and prevention
- Document all quality requirements clearly
- Review and update plans regularly

### Statistical Methods
- Use appropriate control chart types
- Calculate control limits from stable process data
- React to out-of-control signals promptly
- Validate measurement systems (Gage R&R) before use
- Target Cpk ≥1.33 (preferably ≥1.67)
- Trend data over time for early warning
- Use rational subgrouping

### Inspection & Testing
- Calibrate equipment regularly and maintain records
- Follow documented inspection procedures
- Use clear acceptance criteria (pass/fail)
- Document results objectively
- Segregate nonconforming material immediately
- Maintain traceability (lot, serial number)
- Sample appropriately based on risk

### Problem Solving (8D)
- Use structured methodology (8D, A3, DMAIC)
- Form cross-functional teams
- Implement containment actions immediately
- Validate root cause with data
- Verify effectiveness of corrective actions
- Close the loop with customers
- Share lessons learned

### Supplier Quality
- Qualify suppliers before production
- Communicate quality requirements clearly
- Monitor supplier performance with scorecards
- Conduct supplier audits regularly
- Develop suppliers with poor performance
- Implement supplier CAPA process
- Require certification for critical parts

### Compliance & Audits
- Maintain document control rigorously
- Keep records per retention requirements
- Prepare for audits year-round
- Address audit findings promptly
- Conduct regular internal audits
- Train employees on QMS requirements
- Monitor regulatory changes

## Example Use Cases

### Use Case 1: Implement Statistical Process Control (SPC)
**Scenario**: Implement SPC for critical machining process to reduce variation

**Prompt Generation**:
```
Generate a prompt for implementing Statistical Process Control for a critical machining process. Include process selection criteria, control chart type selection (X-bar/R vs. X-bar/S), data collection plan, control limit calculation from stable baseline, reaction plan for out-of-control conditions, and operator training plan. Target process capability Cpk ≥1.67.
```

**Expected Output**: SPC implementation plan, control charts, reaction plans, training materials

### Use Case 2: Conduct 8D Root Cause Analysis
**Scenario**: Resolve customer complaint using 8D methodology

**Prompt Generation**:
```
Generate a prompt for conducting an 8D root cause analysis to resolve a customer quality complaint. Include problem description and quantification (D1), containment actions (D3), root cause analysis using 5 Whys and Fishbone diagram (D4), permanent corrective actions (D5), verification of effectiveness (D6), and prevention of recurrence (D7). Provide customer communication plan.
```

**Expected Output**: 8D report, root cause analysis, corrective actions, verification plan

### Use Case 3: Develop PPAP Package for Automotive Customer
**Scenario**: Prepare Production Part Approval Process submission

**Prompt Generation**:
```
Generate a prompt for developing a PPAP (Production Part Approval Process) submission package for an automotive customer per AIAG requirements. Include design records, engineering change documentation, process flow diagram, PFMEA, control plan, dimensional results, material test results, initial process studies (Cpk ≥1.67), measurement system analysis (Gage R&R), and PSW (Part Submission Warrant).
```

**Expected Output**: Complete PPAP package with all required elements, submission checklist

### Use Case 4: Conduct Supplier Quality Audit
**Scenario**: Audit supplier to verify quality system and process controls

**Prompt Generation**:
```
Generate a prompt for conducting a supplier quality audit. Include audit scope (system, process, product), audit checklist based on ISO 9001 and customer-specific requirements, process audit questions, documentation review requirements, nonconformance rating criteria (major vs. minor), corrective action request process, and follow-up verification plan.
```

**Expected Output**: Audit plan, checklist, audit report, corrective action requests

## Customization Options

### Industry-Specific Adaptations
- Automotive (IATF 16949, APQP, PPAP, MSA, SPC)
- Aerospace (AS9100, FAA regulations, first article inspection)
- Medical devices (ISO 13485, FDA 21 CFR Part 820, design controls)
- Electronics (IPC standards, ESD control, reliability testing)
- Food & beverage (HACCP, SQF, FDA food safety)
- Pharmaceuticals (cGMP, FDA regulations, validation)

### Focus Areas
- Quality systems and compliance (ISO, regulatory)
- Product quality assurance (inspection, testing)
- Process quality control (SPC, capability)
- Supplier quality management
- Problem-solving and CAPA
- New product introduction (APQP, PPAP)

### Company Size Adaptations
- Small manufacturer (simple systems, essential controls)
- Mid-size (documented systems, certification)
- Large enterprise (comprehensive systems, global standards)
- Contract manufacturer (customer-specific requirements)

## Key Deliverables

1. **Quality Planning Documents**
   - Quality plans (product and process)
   - Inspection and test plans
   - Control plans (pre-launch and production)
   - Sampling plans
   - FMEA (Design and Process)

2. **Qualification & Validation**
   - First Article Inspection Reports (FAIR)
   - Gage R&R study reports
   - Process capability studies (Cpk reports)
   - PPAP submission packages
   - Validation and verification test reports

3. **Monitoring & Control**
   - Inspection and test reports
   - SPC control charts
   - Nonconformance reports (NCRs)
   - Quality trending reports
   - Production audit reports

4. **Problem Solving**
   - 8D problem-solving reports
   - Root cause analysis (5 Whys, Fishbone)
   - Corrective action plans
   - CAPA documentation
   - Effectiveness verification reports

5. **Audit & Compliance**
   - Internal audit reports
   - Audit findings and corrective actions
   - Supplier audit reports
   - Management review presentations
   - Certification documentation

## Metrics and KPIs

### Customer Quality
- Customer PPM (parts per million) (target: <100)
- Customer complaints (target: <5 per month)
- Customer returns (% of shipments) (target: <0.5%)
- On-time response to customer issues (target: 100%)
- Customer satisfaction score (target: >4.5/5)

### Internal Quality
- Internal defect rate (DPMO) (target: <500)
- First-pass yield (FPY) (target: >95%)
- Scrap rate (target: <2%)
- Rework rate (target: <3%)
- Process capability (Cpk) (target: ≥1.33, preferably ≥1.67)
- Measurement system accuracy (Gage R&R <10% for critical)

### CAPA Performance
- Open CAPA aging (target: <30 days average)
- On-time CAPA closure (target: >90%)
- CAPA recurrence rate (target: <5%)
- Customer CAPA response time (target: <24 hours)

### Audit & Compliance
- Internal audit completion (target: 100% on schedule)
- Audit finding closure rate (target: >95% on time)
- External audit findings (target: 0 major findings)
- Document control compliance (target: 100%)
- Training completion rate (target: 100%)

### Cost of Poor Quality (COPQ)
- Total COPQ as % of revenue (target: <2%)
- Scrap cost ($)
- Rework cost ($)
- Warranty cost ($)
- Inspection and testing cost ($)
- Customer returns cost ($)

---

**Note**: This preset provides general quality engineering guidance. Specific quality requirements vary significantly by industry, regulatory environment, and customer requirements. Always follow applicable standards (ISO, ANSI, industry-specific) and regulatory requirements (FDA, FAA, etc.) when implementing quality systems and controls.
