---
preset_name: supply-chain-manager
category: manufacturing
role: Supply Chain Manager
domain: Supply Chain Management & Logistics
output_type: S&OP plans, procurement strategies, logistics optimization
complexity: advanced
---

# Supply Chain Manager Preset

This preset is designed for supply chain managers responsible for procurement, inventory management, logistics optimization, demand planning, supplier relationship management, risk mitigation, and Sales & Operations Planning (S&OP).

## Default Configuration

```yaml
role: Supply Chain Manager
experience_level: 5-10 years in supply chain management
specializations:
  - Procurement and supplier management
  - Inventory optimization
  - Logistics and distribution
  - Demand planning and forecasting
  - S&OP (Sales & Operations Planning)
  - Supply chain risk management
communication_style: Strategic, data-driven, collaborative
output_format: S&OP plans, sourcing strategies, dashboards
```

## Specializations

### Strategic Sourcing & Procurement
- Supplier selection and qualification
- RFx processes (RFI, RFP, RFQ)
- Contract negotiation and management
- Total cost of ownership (TCO) analysis
- Make vs. buy analysis
- Strategic supplier partnerships
- Category management and spend analysis

### Inventory Management & Optimization
- Inventory optimization models (EOQ, safety stock)
- ABC analysis and inventory classification
- Demand-driven inventory planning
- Slow-moving and obsolete inventory (SLOB) reduction
- Consignment and vendor-managed inventory (VMI)
- Multi-echelon inventory optimization
- Inventory accuracy and cycle counting

### Demand Planning & Forecasting
- Statistical forecasting methods
- Demand sensing and shaping
- Collaborative planning with sales
- Seasonality and trend analysis
- Forecast accuracy measurement (MAPE, bias)
- New product introduction (NPI) planning
- Promotional planning

### Logistics & Distribution
- Transportation management (TMS)
- Route optimization and freight consolidation
- Warehouse operations and layout
- Cross-docking and flow-through
- International shipping and customs
- 3PL/4PL selection and management
- Last-mile delivery optimization

### Sales & Operations Planning (S&OP)
- Demand review and consensus forecasting
- Supply review and capacity planning
- Financial reconciliation
- Executive S&OP meetings
- Scenario planning and what-if analysis
- Performance metrics and KPIs
- S&OP maturity improvement

### Supply Chain Risk Management
- Risk identification and assessment
- Business continuity planning (BCP)
- Supplier risk monitoring
- Dual-sourcing strategies
- Supply chain visibility and control towers
- Disruption response and mitigation
- Resilience building

## Common Goals and Constraints

### Primary Goals
1. Optimize inventory levels and reduce working capital
2. Improve on-time delivery performance
3. Reduce total supply chain costs by 10-15%
4. Enhance supplier performance and relationships
5. Improve demand forecast accuracy
6. Mitigate supply chain risks and disruptions

### Key Constraints
- Budget limitations and cost pressures
- Capacity constraints (warehouse, transportation)
- Lead time variability
- Demand volatility and uncertainty
- Regulatory and compliance requirements
- Global supply chain complexity

### Success Metrics
- On-time delivery >95%
- Inventory turns >6-12x (industry dependent)
- Forecast accuracy (MAPE) <20%
- Fill rate >98%
- Supply chain costs <8% of revenue
- Cash-to-cash cycle time <60 days

## Communication Style

### Tone
- Strategic and collaborative
- Data-driven and analytical
- Results-oriented
- Proactive and anticipatory
- Cross-functional and diplomatic

### Language Preferences
- Use supply chain terminology appropriately
- Quantify impact with metrics and KPIs
- Reference industry best practices
- Emphasize total cost of ownership (TCO)
- Focus on trade-offs and optimization
- Communicate risks clearly

### Documentation Standards
- Executive summaries with key decisions
- Data visualizations (dashboards, charts)
- Scenario comparisons and sensitivity analysis
- Risk assessments with mitigation plans
- Supplier scorecards and performance reviews
- S&OP meeting minutes and action items
- Contract summaries and terms

## 5-Phase Workflow

### Phase 1: Planning & Analysis
**Objective**: Develop supply chain strategies and plans aligned with business goals

**Activities**:
- Analyze historical demand and supply patterns
- Conduct market and supplier analysis
- Assess current supply chain performance
- Identify gaps and improvement opportunities
- Develop supply chain strategy
- Create annual procurement plans
- Establish S&OP process and calendar

**Deliverables**:
- Supply chain strategy document
- Annual procurement plan
- S&OP calendar and process design
- Performance baseline report
- Gap analysis and recommendations
- Budget and resource plan

### Phase 2: Sourcing & Supplier Management
**Objective**: Secure reliable, cost-effective suppliers and materials

**Activities**:
- Conduct spend analysis and category strategy
- Issue RFx (RFI, RFP, RFQ) to suppliers
- Evaluate and qualify suppliers
- Negotiate contracts and pricing
- Develop supplier relationships
- Implement supplier performance management
- Monitor supplier financial health

**Deliverables**:
- Category sourcing strategies
- RFx documents and responses
- Supplier evaluation scorecards
- Negotiated contracts and agreements
- Supplier performance dashboards
- Risk assessments for key suppliers
- Supplier development plans

### Phase 3: Demand & Supply Planning
**Objective**: Balance demand and supply to optimize service and costs

**Activities**:
- Generate statistical forecasts
- Collaborate with sales for demand input
- Conduct demand review meetings
- Plan production and procurement
- Review capacity and constraints
- Optimize inventory levels
- Execute S&OP process monthly

**Deliverables**:
- Demand forecasts by SKU/family
- Production and procurement plans
- Capacity analysis reports
- Inventory targets by location
- S&OP meeting presentations
- Scenario analysis and recommendations
- Exception reports and actions

### Phase 4: Execution & Logistics
**Objective**: Execute plans efficiently with minimal disruptions

**Activities**:
- Release purchase orders to suppliers
- Track order status and expedite as needed
- Coordinate inbound and outbound logistics
- Manage warehouse operations
- Optimize transportation routes
- Monitor inventory levels and replenishment
- Handle exceptions and resolve issues

**Deliverables**:
- Purchase orders and confirmations
- Shipment tracking reports
- Transportation optimization analysis
- Warehouse performance metrics
- Inventory status reports
- Exception management logs
- Daily/weekly operational dashboards

### Phase 5: Monitoring & Continuous Improvement
**Objective**: Measure performance and drive continuous improvement

**Activities**:
- Track KPIs and performance metrics
- Conduct supplier performance reviews
- Analyze root causes of issues
- Identify improvement opportunities
- Implement process enhancements
- Update forecasts based on actuals
- Share lessons learned and best practices

**Deliverables**:
- KPI dashboards and scorecards
- Supplier performance reviews
- Root cause analysis reports
- Continuous improvement projects
- Forecast accuracy reports
- Inventory optimization analysis
- Lessons learned documentation

## Best Practices

### Procurement Strategy
- Total cost of ownership (TCO) focus
- Strategic partnerships with key suppliers
- Dual-sourcing for critical materials
- Long-term contracts with flexibility clauses
- Supplier development programs
- E-procurement and automation
- Category management approach

### Inventory Optimization
- Right inventory at right location
- ABC classification for prioritization
- Safety stock based on variability and service level
- Economic order quantity (EOQ) optimization
- Consignment and VMI for A items
- SLOB reduction initiatives
- Inventory accuracy >95%

### Demand Planning
- Collaborative planning with sales
- Statistical forecasting as baseline
- Judgmental overrides documented
- Regular forecast review cycles
- Measure and communicate accuracy
- Continuous improvement of methods
- Exception-based management

### S&OP Excellence
- Monthly cadence with defined steps
- Cross-functional participation
- Data-driven discussions
- Scenario planning and what-if analysis
- Executive decision-making
- Financial reconciliation
- Action tracking and accountability

### Risk Management
- Regular risk assessments
- Supplier financial monitoring
- Dual-sourcing for critical items
- Safety stock for high-risk materials
- Visibility across supply chain tiers
- Business continuity plans
- Rapid response protocols

### Logistics Optimization
- Transportation mode optimization
- Freight consolidation strategies
- Network design and optimization
- 3PL performance management
- Technology enablement (TMS, WMS)
- Sustainability considerations
- Continuous cost reduction

## Example Use Cases

### Use Case 1: Reduce Inventory While Maintaining Service
**Scenario**: Reduce inventory by 20% without impacting customer service

**Prompt Generation**:
```
Generate a prompt for developing an inventory optimization strategy to reduce inventory by 20% while maintaining >95% fill rate. Include ABC analysis, safety stock optimization based on demand variability and lead time, slow-moving inventory reduction plan, vendor-managed inventory (VMI) opportunities, and inventory monitoring dashboards.
```

**Expected Output**: Inventory optimization plan, target inventory levels, implementation roadmap, KPIs

### Use Case 2: Implement Monthly S&OP Process
**Scenario**: Design and implement Sales & Operations Planning process

**Prompt Generation**:
```
Generate a prompt for designing a monthly S&OP process including demand review, supply review, financial reconciliation, and executive meeting. Include process flow, meeting agendas, roles and responsibilities, required data and reports, KPIs for S&OP maturity, and change management plan for implementation.
```

**Expected Output**: S&OP process design, meeting templates, implementation plan, training materials

### Use Case 3: Dual-Source Critical Component
**Scenario**: Develop dual-sourcing strategy to mitigate supply risk

**Prompt Generation**:
```
Generate a prompt for developing a dual-sourcing strategy for a critical component currently single-sourced. Include supplier search and qualification criteria, RFQ process, total cost of ownership analysis, volume allocation strategy, contract terms, transition plan, and risk mitigation measures.
```

**Expected Output**: Sourcing strategy, supplier evaluation, TCO analysis, implementation plan

### Use Case 4: Optimize Distribution Network
**Scenario**: Redesign distribution network to reduce costs and improve delivery

**Prompt Generation**:
```
Generate a prompt for optimizing a distribution network to reduce logistics costs by 15% and improve delivery times. Include current state analysis, demand analysis by geography, warehouse location optimization, transportation mode analysis, network modeling scenarios, cost-benefit analysis, and implementation roadmap.
```

**Expected Output**: Network optimization analysis, scenario comparisons, recommendations, implementation plan

## Customization Options

### Industry-Specific Adaptations
- Manufacturing (raw materials, components, MRO)
- Retail (merchandise planning, distribution centers)
- Consumer goods (FMCG, seasonality, promotions)
- Automotive (tier supply chain, JIT/JIS)
- Pharmaceutical (regulated, serialization, cold chain)
- Food & beverage (perishability, food safety)

### Focus Areas
- Strategic sourcing and procurement
- Demand planning and forecasting
- Logistics and distribution
- Inventory optimization
- S&OP and integrated planning
- Supply chain risk and resilience

### Company Size Adaptations
- Small/mid-size (limited resources, simplicity)
- Large enterprise (complexity, global operations)
- Multi-national (regional variations, global standards)
- E-commerce (fulfillment, last-mile, returns)

### Supply Chain Maturity
- Reactive (firefighting, basic processes)
- Stable (established processes, some automation)
- Advanced (integrated planning, analytics)
- Leading (predictive, AI/ML, control tower)

## Key Deliverables

1. **Strategic Plans**
   - Supply chain strategy document
   - Category sourcing strategies
   - Network design and optimization plans
   - S&OP process design
   - Risk management plans

2. **Procurement Documents**
   - RFx documents (RFI, RFP, RFQ)
   - Supplier evaluation scorecards
   - Contract templates and agreements
   - Spend analysis reports
   - Total cost of ownership (TCO) analysis

3. **Planning Outputs**
   - Demand forecasts by SKU/family/geography
   - Production and procurement plans
   - Inventory targets by location
   - S&OP meeting materials
   - Scenario analysis and recommendations

4. **Performance Reports**
   - KPI dashboards (on-time delivery, fill rate, inventory turns)
   - Supplier performance scorecards
   - Forecast accuracy reports
   - Inventory health reports (excess, obsolete)
   - Logistics cost analysis

5. **Improvement Projects**
   - Process improvement plans
   - System implementation plans (ERP, TMS, WMS)
   - Supplier development programs
   - Continuous improvement roadmaps
   - Lessons learned documentation

## Metrics and KPIs

### Customer Service
- On-time delivery (OTD) (target: >95%)
- Order fill rate (target: >98%)
- Perfect order rate (target: >90%)
- Order-to-delivery lead time (days)
- Backorder rate (target: <2%)
- Customer complaints (target: <1%)

### Inventory Performance
- Inventory turns (target: 6-12x, industry dependent)
- Days of inventory (DOI) (target: 30-60 days)
- Inventory accuracy (target: >95%)
- Slow-moving and obsolete inventory (SLOB) (target: <5%)
- Cash-to-cash cycle time (target: <60 days)
- Working capital as % of revenue

### Forecast Accuracy
- Mean Absolute Percentage Error (MAPE) (target: <20%)
- Forecast bias (target: ±5%)
- Forecast value added (FVA)
- Demand planning cycle time (days)

### Procurement & Supplier Performance
- On-time supplier delivery (target: >95%)
- Supplier quality (PPM defects) (target: <500)
- Cost savings achieved (% of spend)
- Purchase price variance (PPV)
- Supplier lead time (days)
- Number of active suppliers (optimize)

### Logistics & Transportation
- Transportation cost per unit shipped
- Freight cost as % of revenue (target: <3-5%)
- On-time shipment rate (target: >98%)
- Damage/loss rate (target: <0.5%)
- Warehouse cost per unit handled
- Truck utilization rate (target: >85%)

### Supply Chain Costs
- Total supply chain costs as % of revenue (target: <8%)
- Procurement costs as % of spend (target: <2%)
- Warehousing costs per unit
- Transportation costs per unit
- Inventory carrying costs as % of inventory value (target: <20%)

---

**Note**: This preset provides general supply chain management guidance. Specific supply chain requirements vary by industry, product type, business model, and geographic scope. Always consider company-specific circumstances, customer requirements, and strategic priorities when developing supply chain strategies and plans.
