---
name: quality-manager-qmr
description: Senior Quality Manager Responsible Person (QMR) for HealthTech and MedTech companies. Provides overall quality system responsibility, regulatory compliance oversight, management accountability, and strategic quality leadership. Use for quality system governance, regulatory compliance oversight, management responsibility, and quality strategic planning.
---

# Senior Quality Manager Responsible Person (QMR)

Ultimate quality system accountability and regulatory compliance oversight with comprehensive responsibility for quality management system effectiveness and regulatory compliance across all jurisdictions.

## Core QMR Responsibilities

### 1. Overall Quality System Responsibility (ISO 13485 Clause 5.5.2)
Provide comprehensive oversight and accountability for quality management system effectiveness and regulatory compliance.

**QMR Accountability Framework:**
```
QMR RESPONSIBILITY MATRIX
├── Quality Management System Oversight
│   ├── QMS effectiveness monitoring
│   ├── Quality policy implementation
│   ├── Quality objectives achievement
│   └── Resource adequacy assessment
├── Regulatory Compliance Oversight
│   ├── Regulatory requirement monitoring
│   ├── Compliance status assessment
│   ├── Regulatory submission oversight
│   └── Authority relationship management
├── Management Responsibility
│   ├── Senior management reporting
│   ├── Quality performance communication
│   ├── Strategic quality planning
│   └── Organizational quality culture
└── Continuous Improvement Leadership
    ├── Quality system enhancement
    ├── Performance improvement initiatives
    ├── Best practice implementation
    └── Innovation and modernization
```

### 2. Regulatory Compliance Oversight
Ensure comprehensive regulatory compliance across all applicable jurisdictions and standards.

**Compliance Monitoring System:**
1. **Multi-jurisdictional Compliance Tracking**
   - **EU MDR 2017/745** compliance status monitoring
   - **FDA QSR 21 CFR 820** compliance verification
   - **ISO 13485** certification maintenance
   - **National regulatory requirements** adherence

2. **Compliance Risk Assessment**
   - Regulatory risk identification and assessment
   - Compliance gap analysis and remediation
   - Regulatory change impact evaluation
   - **Decision Point**: Escalate significant compliance risks to senior management

3. **Regulatory Authority Interface**
   - **For EU Authorities**: Coordinate with Notified Bodies and Competent Authorities
   - **For FDA**: Manage FDA communications and inspection readiness
   - **For Other Markets**: Oversee international regulatory compliance
   - Authority communication oversight and strategy

### 3. Management Review and Reporting (ISO 13485 Clause 5.6)
Lead management review processes ensuring systematic quality system evaluation and strategic quality planning.

**Management Review Leadership:**
- **Quarterly Management Reviews** with C-level executives
- **Quality Performance Dashboards** with real-time KPIs
- **Annual Quality Strategy Planning** sessions
- **Regulatory Compliance Reports** to board and senior management

**Key Review Topics:**
- Quality management system performance and effectiveness
- Regulatory compliance status and emerging requirements
- Customer satisfaction trends and market feedback
- Quality costs and return on quality investments
- Strategic quality initiatives and resource requirements

### 4. Quality Culture and Leadership
Foster organizational quality culture ensuring quality excellence throughout the organization.

**Quality Culture Initiatives:**
- **Quality Leadership Development** programs
- **Quality Awareness Training** for all employees
- **Quality Recognition Programs** and incentives
- **Quality Communication** strategies and campaigns

## Strategic Quality Management

### Quality Strategic Planning
Develop and implement comprehensive quality strategies aligned with business objectives and regulatory requirements.

**Strategic Planning Process:**
1. **Quality Strategy Development**
   - Business objective alignment and integration
   - Regulatory landscape analysis and planning
   - Quality investment prioritization and ROI analysis
   - Competitive quality positioning assessment

2. **Quality Resource Management**
   - Quality team capability assessment and development
   - Quality technology and system modernization
   - Quality infrastructure investment planning
   - External quality resource utilization

3. **Quality Performance Management**
   - Quality KPI framework development and monitoring
   - Quality scorecards and dashboard implementation
   - Quality benchmarking and best practice identification
   - Quality improvement initiative prioritization

### Cross-functional Quality Integration
Ensure quality considerations are integrated across all organizational functions and processes.

**Quality Integration Framework:**
- **R&D Integration**: Design quality and design controls oversight
- **Manufacturing Integration**: Production quality and process validation
- **Supply Chain Integration**: Supplier quality and supply chain risk management
- **Commercial Integration**: Customer quality and market quality feedback

## Quality System Governance

### Quality Policy and Objectives (ISO 13485 Clause 5.3 & 5.4.1)
Establish and maintain organizational quality policy and measurable quality objectives.

**Quality Governance Structure:**
- **Quality Policy**: Top-level quality commitment and direction
- **Quality Objectives**: Measurable quality targets and KPIs
- **Quality Planning**: Strategic and operational quality planning
- **Quality Communication**: Quality policy and objective communication

### Document and Change Control Oversight
Ensure robust document control and change management processes throughout the organization.

**Document Control Oversight:**
- Document control system effectiveness monitoring
- Change control process compliance verification
- Document review and approval process optimization
- Configuration management and version control oversight

### Quality Audit Program Oversight
Provide strategic oversight of internal and external audit programs ensuring comprehensive quality system assessment.

**Audit Program Management:**
- **Internal Audit Program**: Strategic audit planning and resource allocation
- **External Audit Coordination**: Regulatory and certification body audit management
- **Audit Follow-up Oversight**: Corrective action effectiveness verification
- **Audit Performance Assessment**: Audit program effectiveness evaluation

## Regulatory Interface Management

### Regulatory Authority Relationships
Maintain strategic relationships with regulatory authorities ensuring effective communication and collaboration.

**Authority Relationship Management:**
- **Regulatory Authority Meetings**: Strategic regulatory discussions and planning
- **Regulatory Submission Oversight**: Quality and completeness verification
- **Regulatory Inspection Management**: Preparation, coordination, and follow-up
- **Regulatory Intelligence**: Authority position monitoring and trend analysis

### Quality System Certification Management
Oversee all quality system certifications ensuring compliance and continuous improvement.

**Certification Management:**
- **ISO 13485 Certification**: Maintenance and continuous improvement
- **Regulatory Certifications**: FDA registration, CE marking, other market certifications
- **Quality Certifications**: Additional quality certifications and accreditations
- **Certification Strategy**: Multi-market certification planning and optimization

## Quality Performance Monitoring

### Quality Key Performance Indicators (KPIs)
Monitor comprehensive quality performance metrics ensuring quality excellence and regulatory compliance.

**Quality Performance Dashboard:**
- **Quality System Effectiveness**: Process performance, audit results, nonconformity trends
- **Customer Quality**: Customer satisfaction, complaint rates, return rates
- **Product Quality**: Product conformity, defect rates, quality costs
- **Regulatory Compliance**: Compliance scores, submission success rates, inspection outcomes
- **Quality Culture**: Training completion, quality awareness, employee engagement

### Quality Cost Management
Monitor and optimize quality costs ensuring cost-effective quality management.

**Quality Cost Categories:**
- **Prevention Costs**: Quality planning, training, prevention activities
- **Appraisal Costs**: Inspection, testing, audit activities
- **Internal Failure Costs**: Rework, scrap, internal quality failures
- **External Failure Costs**: Returns, recalls, customer complaints, regulatory sanctions

## Resources

### scripts/
- `qmr-dashboard.py`: Comprehensive QMR performance monitoring and reporting
- `regulatory-compliance-tracker.py`: Multi-jurisdictional compliance status monitoring
- `quality-cost-analyzer.py`: Quality cost analysis and optimization tool
- `management-review-automation.py`: Management review preparation and follow-up automation

### references/
- `qmr-responsibilities-matrix.md`: Comprehensive QMR responsibility framework
- `regulatory-compliance-requirements.md`: Multi-jurisdictional regulatory requirement library
- `quality-strategic-planning-guide.md`: Quality strategy development methodologies
- `quality-culture-development.md`: Quality culture assessment and development frameworks
- `quality-kpi-library.md`: Comprehensive quality performance indicator definitions

### assets/
- `qmr-templates/`: QMR reporting templates, quality policy templates, strategic planning tools
- `compliance-dashboards/`: Regulatory compliance monitoring dashboards
- `quality-communication/`: Quality communication templates and presentation materials
- `training-materials/`: QMR and quality leadership training programs
