# Validation Report Template

Copy and fill in this template when generating validation reports.

---

```markdown
# Validation Report: [Brief Title of What's Being Validated]

**Date**: [YYYY-MM-DD]
**Validated By**: strategic-cto-mentor
**Subject**: [Plan/Architecture/Proposal] for [System/Feature/Initiative]
**Requested By**: [Who asked for validation]

---

## 1. Verdict

### VERDICT: [GOOD / NEEDS MAJOR WORK / BAD]

**Confidence**: [High / Medium / Low]

> [One-sentence summary explaining the verdict. Be direct and specific.]

**Risk Profile**:
| Dimension | Rating | Notes |
|-----------|--------|-------|
| Business Impact | [Low/Med/High] | [Brief note] |
| Technical Risk | [Low/Med/High] | [Brief note] |
| Timeline Risk | [Low/Med/High] | [Brief note] |
| Team Risk | [Low/Med/High] | [Brief note] |

---

## 2. What You Got Right

### Strength 1: [Specific thing done well]
[Why this matters and what it demonstrates about the thinking]

### Strength 2: [Specific thing done well]
[Why this matters and what to preserve]

### Strength 3: [Specific thing done well] *(optional)*
[Why this matters]

---

## 3. Critical Flaws

### Flaw 1: [Clear title describing the flaw]

**The Problem**:
[Specific description of what's wrong]

**Why It Matters**:
[Business or technical impact - quantify if possible]

**Consequence If Not Addressed**:
[What happens if this goes to production/implementation as-is]

**Evidence**:
> [Quote from proposal or specific data point that supports this flaw]

---

### Flaw 2: [Clear title]

**The Problem**:
[Description]

**Why It Matters**:
[Impact]

**Consequence If Not Addressed**:
[Outcome]

**Evidence**:
> [Supporting evidence]

---

### Flaw 3: [Clear title] *(if applicable)*

[Same format]

---

## 4. What You're Not Considering

### Hidden Assumptions

| Assumption Made | Reality Check | Risk |
|-----------------|---------------|------|
| [What was assumed as fact] | [Why it might not be true] | [Consequence] |
| [Another assumption] | [Reality] | [Risk] |

### Blindspots

1. **[Blindspot title]**: [Description of what wasn't considered and why it matters]

2. **[Blindspot title]**: [Description]

### Scenarios Not Explored

- **What if [scenario]?** [Why this matters]
- **What if [scenario]?** [Why this matters]

---

## 5. The Real Question

<!-- Use ONE of these formats: -->

<!-- If reframe is needed: -->
### Problem Reframe Needed

**You're asking**: "[The stated question/problem]"

**But the real question might be**: "[Reframed question that gets at the actual issue]"

**Why this matters**: [Explanation of why the reframe changes the approach]

<!-- OR if problem is correctly framed: -->
### Problem is Correctly Framed

The problem definition is appropriate. The proposal correctly identifies [what it correctly identifies] and is solving the right problem.

---

## 6. What Bulletproof Looks Like

For this [plan/architecture/proposal] to be ready for implementation, it must:

### Must-Have Criteria
- [ ] **[Criterion 1]**: [Measurable definition of success]
- [ ] **[Criterion 2]**: [Measurable definition]
- [ ] **[Criterion 3]**: [Measurable definition]

### Evidence Required
- [ ] [What proof would validate the assumptions]
- [ ] [What data would confirm the approach]

### Validation Checkpoints
- [ ] [Checkpoint 1]: Before [milestone], confirm [what]
- [ ] [Checkpoint 2]: At [milestone], verify [what]

---

## 7. Recommended Path Forward

<!-- Choose the appropriate section based on verdict: -->

### For GOOD Verdict:

**Proceed with implementation**, noting the following:

1. **Before starting**: [Minor adjustments]
2. **During implementation**: [What to monitor]
3. **Validation checkpoints**: [When to pause and verify]

**Minor improvements to consider**:
- [Suggestion 1]
- [Suggestion 2]

---

### For NEEDS MAJOR WORK Verdict:

**Do not proceed until the following are addressed**:

1. **[Area 1]**:
   - What to fix: [Specific change]
   - Suggested approach: [How to fix]
   - Who should do this: [cto-architect / team / external]

2. **[Area 2]**:
   - What to fix: [Specific change]
   - Suggested approach: [How]
   - Who should do this: [Who]

**Recommended workflow**:
1. Route back to cto-architect for revision
2. Address critical flaws 1 and 2
3. Re-validate before proceeding

**Timeline impact**: [Estimate of delay this introduces]

---

### For BAD Verdict:

**Do not proceed. Fundamental rethinking required.**

**Why this can't be fixed incrementally**:
[Explanation of why revision won't work]

**Alternative approaches to consider**:
1. **[Alternative 1]**: [Brief description and trade-offs]
2. **[Alternative 2]**: [Brief description and trade-offs]

**Recommended next steps**:
1. [Step 1 - e.g., Stakeholder discussion to realign goals]
2. [Step 2 - e.g., Reframe the problem]
3. [Step 3 - e.g., Start fresh with new constraints]

---

## 8. Questions You Need to Answer First

These questions must be answered before this [plan/architecture/proposal] can proceed:

| # | Question | Who Can Answer | What It Blocks | Priority |
|---|----------|---------------|----------------|----------|
| 1 | [Specific question] | [Person/team] | [Decision blocked] | Critical |
| 2 | [Specific question] | [Person/team] | [Decision blocked] | High |
| 3 | [Specific question] | [Person/team] | [Decision blocked] | Medium |

### Question Details

**Q1: [Question]**
- Why this matters: [Context]
- Possible answers and implications:
  - If [answer A]: [implication]
  - If [answer B]: [implication]

**Q2: [Question]**
- Why this matters: [Context]
- Possible answers and implications:
  - If [answer A]: [implication]
  - If [answer B]: [implication]

---

## Summary

| Aspect | Assessment |
|--------|------------|
| **Verdict** | [GOOD/NEEDS MAJOR WORK/BAD] |
| **Confidence** | [High/Medium/Low] |
| **Critical Flaws** | [Count] identified |
| **Strengths** | [Count] noted |
| **Blocking Questions** | [Count] unanswered |
| **Recommendation** | [Proceed / Revise / Restart] |

---

*This validation was conducted by strategic-cto-mentor following standard validation protocol. The goal is to prevent costly mistakes by surfacing issues early, not to criticize for its own sake.*

*Next Steps: [Specific action - e.g., "Schedule meeting with cto-architect to discuss revisions" or "Proceed to implementation planning"]*
```

---

## Usage Notes

### Adapting the Template

- **Skip sections that don't apply** (e.g., Reframe section if problem is correct)
- **Add sections if needed** (e.g., Compliance considerations for regulated industries)
- **Adjust depth based on scope** (MVP validation needs less than enterprise architecture)

### Tone Calibration

| Verdict | Opening Tone | Flaw Tone | Closing Tone |
|---------|-------------|-----------|--------------|
| GOOD | Affirming | Advisory | Encouraging |
| NEEDS MAJOR WORK | Neutral | Direct | Constructive |
| BAD | Sympathetic | Firm | Helpful |

### Common Mistakes

1. **Generic feedback**: Every point should be specific to this proposal
2. **Inflated strengths**: Don't praise the obvious to soften criticism
3. **Vague flaws**: "Could be better" is not actionable
4. **Missing evidence**: Every flaw needs supporting data
5. **Impossible criteria**: Bulletproof criteria should be achievable
