# Verdict Criteria

Decision framework for determining validation verdicts.

## Verdict Options

| Verdict | Meaning | Action |
|---------|---------|--------|
| **GOOD** | Ready for implementation | Proceed (with minor notes) |
| **NEEDS MAJOR WORK** | Sound foundation, significant gaps | Revise and re-validate |
| **BAD** | Fundamentally flawed | Stop and rethink |

---

## GOOD Criteria

A proposal receives **GOOD** when ALL of the following are true:

### Core Validity
- [ ] Core assumptions are validated or validatable
- [ ] Problem framing is correct
- [ ] Solution addresses the actual problem

### Feasibility
- [ ] Timeline is realistic (within 20% of similar projects)
- [ ] Budget is appropriate (with reasonable contingency)
- [ ] Team has skills to execute (or clear plan to acquire)
- [ ] Technology choices are justified

### Risk Management
- [ ] Major risks are identified
- [ ] Mitigation strategies exist for high risks
- [ ] Failure modes are considered
- [ ] Rollback plan exists

### Quality
- [ ] Trade-offs are explicit
- [ ] Alternatives were considered
- [ ] Success metrics are defined
- [ ] Monitoring approach is specified

### Minor Issues Acceptable
- Small optimizations possible
- Documentation gaps
- Minor scope clarifications
- Nice-to-have features deferred

---

## NEEDS MAJOR WORK Criteria

A proposal receives **NEEDS MAJOR WORK** when:

### The foundation is sound BUT...

**Any 2+ of these are true**:
- [ ] Timeline is optimistic by 30-50%
- [ ] Budget underestimates by 30-50%
- [ ] 1-2 critical assumptions are unvalidated
- [ ] Key risks are not mitigated
- [ ] Team skill gaps are significant but addressable
- [ ] Major alternative was not considered

### Specific Triggers

| Issue | Threshold for NEEDS MAJOR WORK |
|-------|-------------------------------|
| Timeline variance | 30-50% too optimistic |
| Budget variance | 30-50% underestimated |
| Unvalidated assumptions | 1-2 critical assumptions |
| Missing risk mitigation | High-risk areas without plans |
| Team gaps | Gaps addressable in 4-8 weeks |
| Scope issues | 20-40% scope unclear |

### What Makes It Fixable
- Core architecture is sound
- Problem is correctly framed
- Team can address gaps
- Timeline can be adjusted
- Budget can be revised

---

## BAD Criteria

A proposal receives **BAD** when ANY of the following are true:

### Fatal Flaws

#### Wrong Problem
- [ ] Solving symptoms, not root cause
- [ ] Constraint accepted that should be challenged
- [ ] Solution looking for a problem
- [ ] Success metrics don't align with business goals

#### Invalid Foundation
- [ ] Core assumptions are demonstrably false
- [ ] Fundamental technology mismatch
- [ ] Architecture cannot support requirements
- [ ] Data doesn't exist and can't be obtained

#### Unrealistic Execution
- [ ] Timeline is fantasy (>50% underestimate)
- [ ] Budget is impossible (>50% underestimate)
- [ ] Team cannot acquire needed skills
- [ ] Dependencies cannot be satisfied

#### Anti-Pattern Dominance
- [ ] Premature optimization driving decisions
- [ ] Shiny object syndrome (tech for tech's sake)
- [ ] Hero culture dependency (single point of failure)
- [ ] Second system effect (over-engineering)

### Specific Triggers

| Issue | Threshold for BAD |
|-------|-------------------|
| Timeline variance | >50% too optimistic |
| Budget variance | >50% underestimated |
| Core assumption validity | >2 critical assumptions false |
| Team capability | Cannot reasonably acquire skills |
| Problem framing | Fundamentally incorrect |
| Anti-patterns | Major anti-pattern present |

---

## Confidence Levels

### High Confidence
- Sufficient information to assess
- Domain expertise matches the proposal
- Similar projects for comparison
- Clear evidence for verdict

### Medium Confidence
- Some information gaps (noted in Questions section)
- Adjacent domain expertise
- Limited comparable projects
- Verdict based on patterns/experience

### Low Confidence
- Significant information gaps
- Novel domain for evaluator
- No comparable projects
- Verdict is best guess (recommend expert review)

---

## Edge Cases

### Mixed Signals

When different dimensions give different signals:

| If you have... | Verdict | Rationale |
|----------------|---------|-----------|
| 1 BAD signal, rest GOOD | NEEDS MAJOR WORK | One fatal flaw can be addressed |
| 2+ BAD signals | BAD | Multiple fundamental issues |
| All borderline | NEEDS MAJOR WORK | Cumulative risk too high |

### Insufficient Information

| Information Level | Approach |
|-------------------|----------|
| >80% complete | Give verdict with notes |
| 50-80% complete | Give verdict with Low confidence |
| <50% complete | Cannot validate - request more info |

### Scope Mismatch

| Situation | Approach |
|-----------|----------|
| Proposal too ambitious | BAD if unrealistic, otherwise NEEDS MAJOR WORK with scope reduction |
| Proposal too limited | GOOD with expansion recommendations |
| Wrong scope entirely | BAD - reframe needed |

---

## Decision Tree

```
START
  │
  ├─► Is the problem correctly framed?
  │     NO ──────────────────────────────────────► BAD
  │     YES
  │       │
  │       ▼
  ├─► Are core assumptions valid?
  │     >2 invalid ──────────────────────────────► BAD
  │     1-2 questionable ────► (continue with caution)
  │     All valid
  │       │
  │       ▼
  ├─► Is timeline realistic?
  │     >50% underestimate ──────────────────────► BAD
  │     30-50% underestimate ──► (flag for NEEDS MAJOR WORK)
  │     Within 30%
  │       │
  │       ▼
  ├─► Is budget realistic?
  │     >50% underestimate ──────────────────────► BAD
  │     30-50% underestimate ──► (flag for NEEDS MAJOR WORK)
  │     Within 30%
  │       │
  │       ▼
  ├─► Can team execute?
  │     Cannot acquire skills ───────────────────► BAD
  │     Significant gaps ──────► (flag for NEEDS MAJOR WORK)
  │     Team capable
  │       │
  │       ▼
  ├─► Are major anti-patterns present?
  │     Dominant anti-pattern ───────────────────► BAD
  │     Minor anti-pattern ────► (flag for NEEDS MAJOR WORK)
  │     None detected
  │       │
  │       ▼
  └─► Count flags for NEEDS MAJOR WORK
        0-1 flags ───────────────────────────────► GOOD
        2+ flags ────────────────────────────────► NEEDS MAJOR WORK
```

---

## Calibration Examples

### Example 1: GOOD

**Proposal**: Notification system architecture
- Timeline: 8 weeks (realistic for scope)
- Budget: $3K/month (aligned with scale)
- Team: 2 backend engineers (sufficient)
- Assumptions: All validated
- Risks: Identified with mitigations

**Verdict**: GOOD
**Confidence**: High
**Notes**: Minor suggestions for monitoring approach

---

### Example 2: NEEDS MAJOR WORK

**Proposal**: Microservices migration
- Timeline: 8 weeks (similar projects took 16+ weeks)
- Budget: $10K/month (realistic)
- Team: 3 engineers (need DevOps skills)
- Assumptions: 2 unvalidated (database performance, traffic patterns)
- Risks: Some identified, missing failure modes

**Verdict**: NEEDS MAJOR WORK
**Confidence**: High
**Reasons**: Timeline 50% underestimated, team gap, unvalidated assumptions

---

### Example 3: BAD

**Proposal**: AI-powered recommendation engine
- Timeline: 4 weeks (impossible for ML system)
- Budget: $1K/month (need $10K+ for compute)
- Team: No ML experience
- Assumptions: "We have enough data" (have 1000 records, need 100K)
- Anti-pattern: Shiny object syndrome (want AI, don't have AI problem)

**Verdict**: BAD
**Confidence**: High
**Reasons**: Timeline fantasy, budget impossible, team can't execute, core assumption invalid, wrong problem

---

## Final Notes

### Be Honest, Not Harsh
- BAD verdict is not failure—it's preventing expensive failure
- Deliver hard truths with respect
- Always provide path forward

### Err Toward Caution
- When in doubt between GOOD and NEEDS MAJOR WORK → NEEDS MAJOR WORK
- When in doubt between NEEDS MAJOR WORK and BAD → NEEDS MAJOR WORK (but with strong warnings)
- Better to over-validate than under-validate

### Document Reasoning
- Always explain WHY each verdict criterion applied
- Cite specific evidence
- Make reasoning auditable
