---
name: executive-briefing
description: "Transforms research findings into executive-ready briefings. Automatically activated when user mentions 'executive', 'briefing', 'C-suite', 'board', 'leadership', or 'presentation'."
---

# Executive Briefing Skill

## Activation Triggers
This skill activates when the conversation mentions:
- "executive summary", "executive briefing"
- "C-suite", "board presentation", "leadership team"
- "stakeholder update", "management report"
- "one-pager", "key takeaways"

## Briefing Format

When creating executive briefings, always follow this structure:

### The BLUF Principle (Bottom Line Up Front)
Start with the conclusion. Executives are busy - lead with what matters.

### One-Page Format
```
═══════════════════════════════════════════════════════════
EXECUTIVE BRIEFING: [Topic]
Date: [Date] | Prepared for: [Audience]
═══════════════════════════════════════════════════════════

BOTTOM LINE
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
[2-3 sentences: What they need to know and what to do about it]

KEY FINDINGS
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
• [Finding 1 - with data point if available]
• [Finding 2 - with data point if available]
• [Finding 3 - with data point if available]

IMPLICATIONS
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
What this means for [Company/Team]:
• [Implication 1]
• [Implication 2]

RECOMMENDED ACTIONS
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
1. [Action] - [Owner] - [Timeline]
2. [Action] - [Owner] - [Timeline]
3. [Action] - [Owner] - [Timeline]

RISKS & CONSIDERATIONS
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
• [Risk/Consideration 1]
• [Risk/Consideration 2]

═══════════════════════════════════════════════════════════
Sources: [Brief citation list]
Contact: [Who to reach out to for questions]
═══════════════════════════════════════════════════════════
```

## Style Guidelines

### Do:
- Use numbers and metrics where possible
- Keep sentences short and direct
- Use bullet points liberally
- Highlight decisions that need to be made
- Include clear next steps with owners

### Don't:
- Use jargon or technical terms without explanation
- Include lengthy background (link to appendix instead)
- Bury the recommendation
- Use passive voice
- Include information that doesn't drive a decision

## Data Presentation

When including data:
- Round numbers for readability (say "$2.3M" not "$2,347,892")
- Compare to benchmarks or previous periods
- Highlight deltas and trends
- Use comparisons that resonate ("10x faster" not "900% improvement")

## Confidence Indicators

Always indicate confidence level:
- **HIGH CONFIDENCE**: Multiple reliable sources, verified data
- **MEDIUM CONFIDENCE**: Good sources but some gaps
- **LOW CONFIDENCE**: Limited data, emerging information

## Appendix Guidelines

For detailed information, create a separate appendix file with:
- Full methodology
- Complete data tables
- Source documentation
- Technical details
- Extended analysis
