---
name: pre-registration
description: "Create pre-registration documents for research transparency. Use when: (1) Before data collection, (2) Grant submissions, (3) Ensuring reproducibility, (4) Meeting open science standards, (5) Preventing HARKing."
allowed-tools: Read, Write
version: 1.0.0
---

# Pre-Registration Skill

## Purpose
Document study plans before data collection to ensure transparency and prevent questionable research practices.

## Pre-Registration Components

**1. Study Information**
- Title, authors, institutions
- Funding sources

**2. Hypotheses**
- Primary hypothesis (pre-specified)
- Secondary hypotheses
- Exploratory questions

**3. Design**
- Study type (observational, experimental)
- Blinding (who, how)
- Randomization details

**4. Sampling**
- Sample size (with power analysis)
- Recruitment strategy
- Inclusion/exclusion criteria
- Stopping rules

**5. Variables**
- Independent variables (manipulation)
- Dependent variables (outcomes)
- Control variables
- Measurement instruments

**6. Analysis Plan**
- Primary statistical test
- Handling missing data
- Outlier treatment
- Multiple comparison corrections

**7. Timeline**
- Start date
- Data collection period
- Analysis completion

## Platforms

- **OSF (Open Science Framework)**: osf.io
- **AsPredicted**: aspredicted.org
- **ClinicalTrials.gov**: For clinical trials

---
**Version:** 1.0.0
