---
name: publication-prep
description: "Prepare manuscripts for journal submission. Use when: (1) Writing research papers, (2) Selecting target journals, (3) Formatting manuscripts, (4) Ensuring reporting guideline compliance, (5) Preparing submission materials."
allowed-tools: Read, Write, Grep
version: 1.0.0
---

# Publication Preparation Skill

## Purpose
Prepare complete, submission-ready manuscripts following journal requirements and reporting guidelines.

## Manuscript Components

**1. Title Page**
- Informative title (<20 words)
- Author names, affiliations
- Corresponding author contact
- Word count
- Funding, conflicts of interest

**2. Abstract**
- Structured (Background, Methods, Results, Conclusions)
- Within word limit (typically 250-300)
- Keywords (3-6 terms)

**3. Introduction**
- Background and rationale
- Literature gap
- Study objectives/hypotheses

**4. Methods**
- Study design
- Participants
- Procedures
- Measures
- Statistical analysis

**5. Results**
- Participant flow
- Descriptive statistics
- Primary outcomes
- Secondary outcomes
- Effect sizes with CI

**6. Discussion**
- Summary of findings
- Comparison to literature
- Limitations
- Implications
- Conclusions

**7. References**
- Formatted per journal style
- Complete and accurate

**8. Tables and Figures**
- Self-contained
- Publication quality
- Referred to in text

## Reporting Guidelines

- **RCTs**: CONSORT checklist
- **Systematic Reviews**: PRISMA checklist
- **Observational**: STROBE checklist
- **Diagnostic**: STARD checklist

## Journal Selection

**Consider:**
- Scope and fit
- Impact factor
- Open access vs subscription
- Review speed
- Acceptance rate

## Submission Checklist

- [ ] Manuscript formatted per journal guidelines
- [ ] Reporting checklist completed
- [ ] All co-authors approved
- [ ] Ethics approval documented
- [ ] Data availability statement
- [ ] Funding disclosed
- [ ] Conflicts of interest declared
- [ ] Cover letter written
- [ ] Suggested reviewers (if allowed)
- [ ] Supplementary materials prepared

---
**Version:** 1.0.0
