---
name: research-questions
description: "Formulate research questions using FINER criteria (Feasible, Interesting, Novel, Ethical, Relevant). Use when: (1) Starting new research projects, (2) Refining study scope, (3) Grant proposal development, (4) Ensuring research question quality."
allowed-tools: Read, Write
version: 1.0.0
---

# Research Question Formulation Skill

## Purpose
Develop high-quality research questions using FINER criteria.

## FINER Criteria

**F - Feasible**
- Adequate participants available
- Sufficient technical expertise
- Affordable in time and money
- Manageable in scope

**I - Interesting**
- Interesting to investigator and community
- Relevant to scientific knowledge
- Relevant to clinical/policy importance

**N - Novel**
- Confirms/refutes previous findings
- Extends previous findings
- Provides new findings

**E - Ethical**
- IRB approvable
- Benefits outweigh risks
- Equipoise exists

**R - Relevant**
- Advances scientific knowledge
- Influences clinical practice or policy
- Informs future research

## Examples

**Poor Question:**
"Does stress affect health?"
- Too broad, not specific

**Better Question:**
"Does chronic work-related stress increase cardiovascular disease risk in middle-aged adults?"
- Specific population, exposure, outcome

**Best Question:**
"Among adults aged 40-60 with high job strain (Karasek Job Content Questionnaire score >24), does a 12-week mindfulness-based stress reduction intervention reduce systolic blood pressure compared to usual care?"
- PICO format: Population, Intervention, Comparison, Outcome
- Measurable variables
- Specific timeframe

---
**Version:** 1.0.0
