# IEEE Decision Process Guide

## Source
Based on IEEE Author Center - Understanding the Decision Process

## Three Decision Types

### 1. ACCEPT
**Meaning**: Article approved for publication with minimal changes
- Technical quality meets standards
- Contribution is significant
- Presentation is adequate
- Only minor editorial corrections needed

**Next steps for authors**:
- Complete any requested final tasks
- Provide high-quality files
- Sign publishing agreement
- Prompt completion avoids delays

**Frequency**: Rare on first submission

---

### 2. REVISE
**Meaning**: Article has merit but requires changes

This is **the most common decision** for IEEE reviews.

#### Major Revision
**Characteristics**:
- Significant methodological changes needed
- Additional experiments required
- Substantial rewriting necessary
- Core technical issues to address
- May take months to complete

**Review process**:
- Original reviewers typically re-review
- Full evaluation of changes
- May require multiple revision rounds

**Timeline**: Extended (weeks to months)

#### Minor Revision
**Characteristics**:
- Clarifications and additions needed
- No new experiments required
- Presentation improvements
- Additional references or discussion
- Relatively quick fixes

**Review process**:
- May not require full re-review
- Editor may check compliance
- Faster turnaround

**Timeline**: Shorter (days to weeks)

#### Author Responsibilities
When receiving revision decision:
1. **Read entire decision letter carefully**
2. **Note all deadlines**
3. **Address ALL reviewer suggestions**
4. **Provide point-by-point reply** to each comment
5. **Clearly mark changes** in revised manuscript
6. **Submit within deadline**

**Critical**: Include detailed response letter explaining how each reviewer comment was addressed (or why not).

---

### 3. REJECT
**Meaning**: Article does not meet publication standards

**Common reasons**:
- Fundamental technical flaws
- Insufficient novelty or significance
- Out of scope for publication
- Ethical concerns
- Cannot be salvaged with revision

**Author options after rejection**:
- Review feedback carefully
- Improve paper substantially
- Consider different venue
- Resubmit elsewhere (not same IEEE publication without major changes)

**Decision letter will**:
- Explain reasons for rejection
- May include suggestions for improvement
- May indicate if paper suitable elsewhere

---

## Editor's Role

### Timeline
Editors have **90-day window** from submission to decision (IEEE policy requirement).

### Decision Process
Editor will:
1. Consider feedback from ALL reviewers
2. Synthesize disparate reports
3. Make final decision based on balanced view
4. Provide written rationale
5. Disregard inappropriate reviews

### Editor Responsibilities
- Ensure fair and speedy review
- Select unbiased reviewers
- Avoid conflicts of interest
- Maintain confidentiality
- Uphold IEEE policies

---

## Understanding Your Decision Letter

### What to Look For

**Key elements**:
1. **Decision statement**: Accept / Revise / Reject
2. **Reviewer comments**: Feedback from each reviewer
3. **Editor's summary**: Overall assessment
4. **Required actions**: What you must do next
5. **Deadlines**: When revision due (if applicable)
6. **Contact information**: Who to ask for clarifications

### Reading Reviewer Comments

**Remember**:
- Reviewers are experts providing feedback
- Comments aim to improve your work
- Not all suggestions must be followed (but must be addressed)
- Conflicting reviews happen - editor arbitrates

**How to respond**:
- Take time to digest feedback
- Separate emotional reaction from substantive critique
- Identify common themes across reviewers
- Prioritize critical vs minor issues
- Prepare systematic response

---

## Revision Strategy

### For Major Revision

**Approach**:
1. **Understand all concerns** thoroughly
2. **Plan substantial changes** systematically  
3. **Conduct new experiments** if needed
4. **Rewrite significant sections**
5. **Verify all issues addressed**
6. **Prepare detailed response letter**

**Timeline**: Allow sufficient time (weeks to months)

**Success factors**:
- Address every reviewer concern
- Provide clear evidence of changes
- Explain any suggestions not followed
- Improve beyond minimum requirements

### For Minor Revision

**Approach**:
1. **Address all specific points** raised
2. **Make requested clarifications**
3. **Add suggested references** (with integration)
4. **Improve presentation** as noted
5. **Verify completeness**
6. **Prepare point-by-point response**

**Timeline**: Can often complete within weeks

**Success factors**:
- Be thorough despite "minor" label
- Don't miss any reviewer requests
- Improve clarity throughout
- Exceed expectations where possible

---

## Response Letter Best Practices

### Structure

```
Dear Editor,

Thank you for the opportunity to revise our manuscript "[Title]". 
We appreciate the reviewers' constructive feedback and have carefully 
addressed all comments.

Below we provide point-by-point responses to each reviewer comment:

REVIEWER 1:

Comment 1.1: [Quote exact reviewer comment]
Response: [Explain how addressed, include page/line numbers of changes]

Comment 1.2: [Quote exact reviewer comment]
Response: [Explain how addressed]

[Continue for all comments from all reviewers]

REVIEWER 2:
[Same format]

We believe these revisions have substantially strengthened the manuscript. 
Changes are highlighted in the revised manuscript for your convenience.

Thank you for your consideration.

Sincerely,
[Authors]
```

### Tips

**Do**:
- ✓ Quote each comment verbatim
- ✓ Respond to EVERY comment
- ✓ Be specific about changes
- ✓ Include page/line numbers
- ✓ Be polite and professional
- ✓ Explain if didn't follow suggestion

**Don't**:
- ✗ Skip any comments
- ✗ Be defensive or argumentative
- ✗ Make vague claims of changes
- ✗ Ignore minor comments
- ✗ Forget to highlight changes

---

## Appealing Decisions

### When to Consider Appeal

**Appropriate reasons**:
- Clear factual errors in reviews
- Reviewer bias or misconduct
- Procedural irregularities

**Inappropriate reasons**:
- Simply disagree with decision
- Think different reviewers would decide differently
- Believe work is better than reviewers thought

### Appeal Process

1. Contact journal editor first
2. Provide specific, factual basis
3. Include documentation if applicable
4. Be professional and respectful
5. Accept final decision

**Success rate**: Low - appeals rarely overturn decisions

---

## Post-Decision Actions

### If Accepted
- Complete production tasks promptly
- Review proofs carefully
- Promote your published work
- Thank reviewers (anonymously) if opportunity

### If Revision Required
- Review feedback thoroughly
- Plan revisions systematically
- Meet revision deadline
- Submit comprehensive response

### If Rejected
- Take time to process feedback
- Improve paper based on comments
- Consider alternate venues
- Learn from the experience

---

## Timeline Expectations

### Typical IEEE Timeline
1. **Submission**: Day 0
2. **Initial screening**: 1-2 weeks
3. **Review assignment**: 2-4 weeks
4. **Reviews completed**: 6-10 weeks
5. **Editor decision**: 8-12 weeks total
6. **(If revision)**: 1-6 months for authors
7. **Final decision**: 12-20 weeks total (varies)

### Factors Affecting Timeline
- Reviewer availability
- Number of revision rounds
- Complexity of paper
- Holiday periods
- Reviewer responsiveness

---

## Key Takeaways

1. **Revise is most common** - expect to revise
2. **Address ALL comments** - comprehensively
3. **Response letter crucial** - don't skip
4. **Meet deadlines** - or request extension early
5. **Be systematic** - organized response increases success
6. **Stay professional** - even if disagree with reviewers
7. **Learn from feedback** - improves future submissions

---

Good luck with your IEEE submission! Remember that peer review is designed to improve your work and advance the field.
