# IEEE Ethics Framework for Peer Review

## Foundation

IEEE peer review is a system based on **trust, professionalism, ethics, and confidentiality**.

Each party relies on others to operate with integrity.

---

## Reviewer Responsibilities

### Core Ethical Duties

1. **Provide prompt, thorough, impartial review**
   - Complete reviews within agreed timeline
   - Evaluate based on merit, not bias
   - Be comprehensive yet efficient

2. **Give constructive feedback**
   - Reasonable suggestions
   - Professional tone
   - Specific, actionable guidance

3. **Avoid inappropriate reference suggestions**
   - NO irrelevant references
   - NO excessive references
   - Must justify any reference additions

4. **Alert editor to ethical issues**
   - Report suspected misconduct promptly
   - Flag plagiarism, fabrication, etc.
   - Maintain reviewer anonymity in process

5. **Maintain confidentiality**
   - Safeguard unique contributions
   - Never share unpublished work
   - Never use ideas for personal gain

---

## Author Ethical Responsibilities

### Expected Conduct

1. **Accurately report research findings**
   - No fabrication or falsification
   - Honest representation of results
   - Acknowledge limitations

2. **Meet publication requirements**
   - Follow submission guidelines
   - Adhere to ethical standards
   - Obtain necessary permissions

3. **Respond to reviewer feedback**
   - Address all suggestions
   - Provide reasons if not following advice
   - Revise in good faith

---

## Types of Author Misconduct

### 1. Plagiarism
**Definition**: Using others' work without proper attribution

**Forms**:
- Copying text without quotation/citation
- Paraphrasing without attribution
- Using others' ideas without credit
- Self-plagiarism (reusing own published work)

**Action**: Report immediately to editor

### 2. Duplicate Publication
**Definition**: Republishing previously published material without acknowledgment

**Forms**:
- Same paper published in multiple venues
- Substantial overlap with prior publication
- Segmenting single study into multiple papers ("salami slicing")

**Action**: Report to editor with documentation

### 3. Parallel Submission
**Definition**: Submitting same article to multiple venues simultaneously

**IEEE policy**: Prohibited
**Why**: Wastes reviewer time, violates copyright

**Action**: Report if discovered

### 4. Data Fabrication or Falsification
**Definition**: Inventing, altering, or omitting data

**Forms**:
- Making up results
- Manipulating data to support conclusions
- Selectively omitting contradictory data
- Cherry-picking results

**Red flags**:
- Results too perfect
- Implausible statistics
- Missing error bars or variance
- Results don't match methodology

**Action**: Report concerns to editor

### 5. Image Manipulation
**Definition**: Altering images in ways that misrepresent findings

**Acceptable**: Adjusting contrast/brightness uniformly
**Unacceptable**: 
- Selective editing
- Erasing or adding features
- Combining images deceptively
- Duplicating elements

**Action**: Note specific concerns to editor

### 6. Inappropriate Authorship
**Definition**: Adding or omitting authors improperly

**Forms**:
- **Gift authorship**: Adding non-contributors
- **Ghost authorship**: Omitting actual contributors
- **Guest authorship**: Honorary additions
- Incorrect author order

**IEEE standards**: All authors must have made substantive contributions

**Action**: Flag concerns (though difficult to verify externally)

### 7. Citation Stacking
**Definition**: Including irrelevant references to boost citations

**Forms**:
- Excessive self-citations
- Citing papers with no relevance
- Agreements to cite each other
- Gaming citation metrics

**IEEE policy**: References must be relevant and necessary

**Action**: Note in review if excessive/irrelevant

---

## Reviewer Misconduct

### What Reviewers Must Avoid

1. **Breach of confidentiality**
   - Sharing unpublished content
   - Using ideas for personal gain
   - Discussing with others without permission
   
   **Consequences**: Serious professional misconduct

2. **Bias and conflicts of interest**
   - Reviewing papers with conflicts
   - Personal bias affecting evaluation
   - Competing interests influencing review
   
   **Action**: Decline review if conflict exists

3. **Inappropriate delays**
   - Holding reviews unnecessarily
   - Strategic delays for competitive advantage
   
   **Action**: Complete promptly or decline

4. **Harsh or unprofessional comments**
   - Personal attacks
   - Dismissive tone
   - Inflammatory language
   
   **Standard**: Professional, constructive feedback

5. **Inappropriate reference suggestions**
   - Suggesting own work excessively
   - Irrelevant citations
   - Excessive references
   
   **IEEE policy**: Reference suggestions must be justified

---

## Editor/Publication Responsibilities

### Ethical Obligations

1. **Select and manage reviewers**
   - Choose qualified, unbiased reviewers
   - Ensure no conflicts of interest
   - Invite based on expertise

2. **Ensure fair and speedy process**
   - Monitor review progress
   - Enforce 90-day decision timeline
   - Handle appeals appropriately

3. **Synthesize reviews fairly**
   - Consider all reviewer input
   - Make balanced decisions
   - Disregard inappropriate reviews

4. **Maintain confidentiality**
   - Preserve reviewer anonymity (single-blind)
   - Protect author submissions
   - Safeguard review process integrity

5. **Uphold IEEE policies**
   - Enforce ethical standards
   - Handle misconduct appropriately
   - Follow PSPB Operations Manual

---

## Reporting Misconduct

### If You Suspect Misconduct

**As Reviewer**:
1. Document specific concerns
2. Notify editor immediately
3. Provide evidence if available
4. Your anonymity will be preserved
5. Do not investigate independently

**What Editor Will Do**:
- Evaluate evidence
- May consult ethics committee
- Follow IEEE procedures
- Take appropriate action
- Maintain confidentiality

### Consequences of Misconduct

**For Authors**:
- Desk rejection
- Publication ban
- Retraction of published work
- Investigation by institution
- Damage to reputation

**For Reviewers**:
- Removal from reviewer pool
- Professional consequences
- Potential IEEE sanctions

---

## Confidentiality Requirements

### What is Confidential

- **Unpublished manuscripts**
- **Review comments** (in single-blind)
- **Editorial decisions** before publication
- **Reviewer identities** (in single-blind)
- **Internal deliberations**

### Maintaining Confidentiality

**Do**:
- Store manuscripts securely
- Delete files after review
- Never discuss with colleagues
- Keep communications private

**Don't**:
- Share manuscripts with others
- Present others' ideas as your own
- Discuss content publicly
- Upload to AI tools (violates confidentiality)

---

## Conflicts of Interest

### When to Decline Review

Decline if you have:
- Recent collaboration with authors
- Financial interests in outcomes
- Personal relationships with authors
- Work at same institution
- Competing research in same area
- Prior agreement with authors
- Cannot be objective

**Always err on side of caution** - if unsure, decline or consult editor.

---

## Best Practices Summary

### For Ethical Reviewing

1. **Independence**: Evaluate objectively without bias
2. **Confidentiality**: Protect unpublished work
3. **Timeliness**: Complete reviews promptly
4. **Constructiveness**: Help authors improve
5. **Professionalism**: Maintain respectful tone
6. **Vigilance**: Report suspected misconduct
7. **Integrity**: Follow IEEE ethical standards

### Red Flags to Watch For

- **Plagiarism**: Familiar text, missing citations
- **Data issues**: Too-perfect results, inconsistencies
- **Image problems**: Obvious manipulation
- **Citation issues**: Irrelevant or excessive refs
- **Dual submission**: Signs of parallel publishing
- **Authorship**: Gift/ghost author indicators

---

## Resources

**IEEE Ethics Resources**:
- IEEE Code of Ethics
- PSPB Operations Manual
- IEEE Author Center guidelines

**For Questions**:
- Contact journal editor
- Consult IEEE Publishing
- Review IEEE ethics policies

---

## Remember

Ethical peer review is foundation of scientific integrity. Your role as reviewer carries responsibility to:
- **Protect authors' intellectual contributions**
- **Ensure quality of published research**  
- **Maintain trust in peer review system**
- **Uphold professional standards**

Thank you for maintaining the highest ethical standards in your reviews.
