# IEEE Reviewer Guidelines

## Source
Compiled from IEEE Author Center Journals - Reviewer Resources

## Core Principles

IEEE peer review is based on **fairness, integrity, and professionalism**. All participants (authors, editors, reviewers) must follow IEEE's ethical principles.

## Peer Review Process

### Overview
- Articles evaluated by **at least two independent, qualified reviewers**
- Reviewers selected based on expertise and track record
- Most IEEE publications use **single-anonymous** review (reviewers know authors, authors don't know reviewers)

### Reviewer Responsibilities

**Primary duties**:
1. Provide **prompt, thorough, impartial** review
2. Give **constructive feedback** with reasonable suggestions
3. Maintain **professional tone**
4. Avoid suggesting **irrelevant or excessive references**
5. Alert editor to **suspected ethical issues**
6. Maintain **confidentiality** of unpublished work

### What Reviewers Evaluate

Reviewers assess:
- **Quality**: Technical soundness and rigor
- **Validity**: Correctness of methodology and analysis
- **Originality**: Novel contributions to field
- **Significance**: Impact and importance
- **Clarity**: Communication quality
- **Completeness**: Adequate detail for understanding

## Review Structure

### Required Components

**Summary**: Briefly restate article's purpose and findings

**Major Concerns**: Issues with methodology, data, or analysis
- Must be specific and well-supported
- Should explain impact on validity

**Minor Concerns**: Issues with clarity, structure, presentation
- Editorial and formatting issues
- Presentation improvements

**Overall Feedback**: Balance of strengths and weaknesses with clear recommendation

### Reference Suggestions

**Important policy**: Reviewers are NOT permitted to suggest:
- Irrelevant references
- Excessive numbers of references

Any reference suggestions must be accompanied by **clear justification** for why those references should be added.

## Use of AI Tools

**PROHIBITED**: Do not use AI tools (e.g., ChatGPT, Gemini, Claude) to generate or draft reviews.

**Rationale**:
- Articles under review are confidential
- Reviewers responsible for their own evaluations
- Selected for expertise, not outsourced judgment

## Making a Recommendation

### Decision Categories

May vary by publication but fall into three types:

**Accept**: Article meets IEEE standards with no significant changes

**Revise**: Article needs changes before acceptance
- Major Revision: Significant changes required
- Minor Revision: Small improvements needed

**Reject**: Article does not meet standards or has fundamental flaws

## Handling Too-Poorly-Written Papers

If an article is **too poorly written to evaluate**, notify the editor rather than attempting full review. Don't waste time on papers where language prevents proper technical evaluation.

## Best Practices

### Do:
✓ Be professional, objective, and constructive
✓ Provide specific, actionable feedback
✓ Support comments with clear reasoning and examples
✓ Write the review you would want to receive
✓ Complete reviews in timely manner
✓ Maintain confidentiality

### Don't:
✗ Use AI to draft reviews
✗ Suggest excessive or irrelevant references
✗ Be harsh, dismissive, or unprofessional
✗ Share confidential information
✗ Review papers with conflicts of interest
✗ Delay without notifying editor

## Ethical Responsibilities

### Author Misconduct to Watch For:

**Plagiarism**: Using others' work without proper attribution

**Duplicate publication**: Republishing previously published material without acknowledgment

**Parallel submission**: Submitting same article to multiple venues simultaneously

**Data fabrication/falsification**: Inventing, altering, or omitting data

**Image manipulation**: Altering images to misrepresent findings

**Inappropriate authorship**: Adding or omitting authors improperly

**Citation stacking**: Including irrelevant references to boost citations

### If You Suspect Misconduct:
- **Notify editor immediately**
- Your anonymity will be preserved
- Do not attempt to investigate yourself

## Timeline Expectations

- Complete reviews promptly when agreed upon
- Editors have 90-day window for decisions
- Communicate with editor if unable to complete on time
- Decline invitation early if unable to review

## Confidentiality

**Critical requirement**: Maintain confidentiality by:
- Not sharing unpublished content
- Not using ideas for personal gain
- Not discussing paper with others (except editor)
- Safeguarding unique contributions of authors

**Breach of confidentiality is serious misconduct.**

## Quality Review Characteristics

A good IEEE review:
- Is thorough yet efficient
- Identifies both strengths and weaknesses
- Provides constructive guidance
- Supports claims with specific evidence
- Maintains professional tone
- Helps authors improve work
- Assists editor in making informed decision

## Resources

For questions about peer review process, contact the journal Editor.

For general IEEE publishing guidelines, see IEEE Author Center: https://journals.ieeeauthorcenter.ieee.org/
