# NeurIPS Code of Ethics (Summary)

## Preamble
Guide NeurIPS community toward higher standards of ethical conduct in research ethics and societal/environmental impact.

## Research Process Harms

### Human Subjects Research
- **Fair Wages**: Pay at least minimum wage in region
- **Research Protocols**: Follow IRB or equivalent processes
- **Privacy**: Minimize PII exposure, obtain informed consent
- **Consent**: Get explicit consent or explain why unable

### Data-Related Concerns
- **Privacy**: Minimize personally identifiable information
- **Consent**: Ask explicit consent for real data of real people
- **Deprecated Datasets**: Don't use datasets taken down by creators
- **Copyright**: Respect dataset licenses (CC, MIT, etc.)
- **Representative Evaluation**: Assess and communicate dataset representativeness

## Societal Impact and Harmful Consequences

### Areas of Concern

**Safety**: Could technology harm, injure, or kill through direct application, side effects, or misuse? No research increasing weapon lethality.

**Security**: Risk of security vulnerabilities or accidents in deployment? Recommend or implement protections.

**Discrimination**: Could technology discriminate, exclude, or negatively impact people (healthcare, education, credit)?

**Surveillance**: Consult local laws. Don't use surveillance to predict protected categories or endanger well-being.

**Deception & Harassment**: Could facilitate theft, fraud, harassment, impersonation, hate speech, or abuse?

**Environment**: Negative environmental impact (fossil fuels, consumption, greenhouse gases)?

**Human Rights**: Prohibit illegal activity facilitation. Discourage denying rights to privacy, speech, health, liberty, security.

**Bias and Fairness**: Consider if models/datasets encode or exacerbate bias against protected characteristics.

## Impact Mitigation Measures

- **Data/Model Documentation**: Use structured templates
- **Licenses**: Provide licenses with intended use and limitations
- **Privacy/Security**: Use encryption, anonymization
- **Responsible Release**: Control access for high-risk models
- **Reproducibility**: Disclose essential elements
- **Legal Compliance**: Ensure awareness of regional requirements

## Violations

Report to: hotline@neurips.cc

NeurIPS may reject presentations violating Code of Ethics.

## Key Ethical Principles for Reviewers

1. Respect human dignity and rights
2. Protect vulnerable populations
3. Ensure data privacy and security
4. Promote fairness and avoid discrimination
5. Consider environmental impact
6. Address dual-use concerns
7. Be transparent about limitations
8. Follow responsible disclosure practices
