# NeurIPS 2025 Reviewer Guidelines (Summary)

## Key Responsibilities

1. **Thorough Review**: Provide substantive, evidence-based reviews
2. **Timeliness**: Meet all deadlines
3. **Confidentiality**: Keep all materials confidential
4. **Professionalism**: Follow code of conduct
5. **Engagement**: Participate in discussion period

## Important Dates (AoE)

- Paper Assignments Check: May 29
- Reviews Due: July 2
- Author Rebuttal: July 24-30
- Reviewer-Author Discussion: July 31 - Aug 6
- Reviewer-AC Discussion: Aug 7-13
- Author Notification: Sept 18

## Review Form Sections

### 1. Summary
Briefly summarize paper in your own words. Help AC understand paper, verify your understanding.

### 2. Strengths and Weaknesses
Assess across four dimensions:
- **Quality**: Technical soundness, claims supported, methods appropriate
- **Clarity**: Well-written, well-organized, informative
- **Significance**: Impactful, likely to be used/built upon
- **Originality**: New insights, clear differentiation from prior work

### 3. Questions
3-5 key questions that are actionable. State how answers affect your assessment.

### 4. Limitations
Has paper adequately addressed limitations? Authors rewarded for transparency.

### 5. Dimension Scores
- Quality: [1-4]
- Clarity: [1-4]
- Significance: [1-4]
- Originality: [1-4]

### 6. Overall Score
- 6: Strong Accept (groundbreaking, flawless)
- 5: Accept (technically solid, high impact)
- 4: Borderline Accept (use sparingly)
- 3: Borderline Reject (use sparingly)
- 2: Reject (technical flaws, weak evaluation)
- 1: Strong Reject (fundamental flaws, ethical issues)

### 7. Confidence
- 5: Absolutely certain
- 4: Confident
- 3: Fairly confident
- 2: Willing to defend
- 1: Educated guess

### 8. Ethical Concerns
Flag if needed for ethics review.

## Best Practices

**Be Thoughtful**: Remember first-time authors, be constructive

**Be Fair**: Don't let personal feelings affect review

**Be Useful**: Help all parties - authors, reviewers, ACs

**Be Specific**: Make concrete, actionable points

**Be Flexible**: Update understanding based on author responses

**Be Timely**: Respect deadlines, respond promptly in discussions

## Important Policies

### Double-Blind Reviewing
- Don't try to identify authors
- Don't reference workshop versions
- Don't break anonymity

### Confidentiality
- Keep everything confidential
- Don't use ideas before public
- Don't share with anyone
- Don't share with LLMs

### Conflicts of Interest
- Know conflict policies
- Declare if unsure
- Don't collude

### Formatting
- 9 content pages maximum
- Additional pages for references, checklist, appendices
- Minor violations ok, major ones flag to AC

### Code Execution
- Run submitted code in secure environment only
- Use Docker, VM, or isolated cloud instance
- Be cautious with links

### Dual Submissions
- NeurIPS doesn't allow identical/substantially similar papers
- Flag if suspected

## Responsible Reviewing Initiative

**Reviews Withholding**: Reviewers who are also authors won't see reviews of their papers until they complete their own reviews.

**Desk Rejection Sanction**: Grossly negligent reviews can result in desk rejection of reviewer's own papers.

**Goal**: Ensure timely, high-quality reviews for all submissions.

## Resources

- Use NeurIPS paper checklist as evaluation tool
- Consult ethics guidelines when needed
- Contact AC for issues
- Contact Program Chairs for serious concerns
