# Responsible Reviewing Initiative - NeurIPS 2025

## Background
As NeurIPS expands, maintaining review quality and timeliness is challenging. Late and low-quality reviews threaten conference sustainability.

## Partnership Philosophy
Submitting to NeurIPS is a partnership. Every submission nominates a reciprocal reviewer. Many invited reviewers also submit papers. Authors expect timely, high-quality feedback; reviewers must fulfill this obligation.

## New Measures

### 1. Reviews Withholding Mechanism
Inspired by SIG KDD 24/25:
- Reviewers who are also authors won't see reviews of their papers until completing assigned reviews
- If reviews are late, reviewers and co-authors lose access to their paper reviews
- In worst case: Lose access for first 5 days of rebuttal period
- Multiple reminders sent before deadline

### 2. Desk Rejection Sanction
Inspired by CVPR 25:
- Last-resort sanction for grossly negligent reviewer-authors
- ACs/SACs flag low-quality reviews (placeholders, regardless of timing)
- Reviewer notified and required to address issues
- If problems persist after PC verification: Reviewer's papers may face desk rejection at meta-review stage

## Expected Outcomes
Significant portion of papers will receive more responsible, timely reviews. Both main track and Datasets & Benchmarks track adopt these measures.

## Implications for Reviewers
- Take reviewing seriously as professional obligation
- Complete reviews on time
- Provide substantive, well-thought-out reviews
- Remember reviews affect entire co-author team
- Your reviewing quality directly impacts your own papers

## Philosophy
Reviewing is not just service to community; it's integral part of being an author in the community. Quality reviews benefit everyone and sustain the conference.
