# Review Synthesis Template

## Purpose
Integrate all component assessments into coherent, well-structured review.

## Synthesis Workflow

### 1. Collect Component Outputs

Gather all assessments from:
- Technical assessment (quality + findings)
- Contribution assessment (novelty/significance/originality)
- Clarity assessment (clarity + issues)
- Ethics assessment (concerns/flags)
- Checklist evaluation

### 2. Determine Review Strategy

Select tone/approach based on paper quality:
- **Clear Accept**: Supportive, emphasize strengths
- **Borderline**: Balanced, high detail for AC
- **Clear Reject**: Professional but firm

### 3. Write Summary (100-200 words)

Factual, not evaluative. Cover problem, approach, results, scope.

### 4. Synthesize Strengths (3-7 points)

Be specific with evidence. Balance by paper quality.

### 5. Synthesize Weaknesses (3-8 points)

Actionable, classified by severity. Suggest solutions.

### 6. Formulate Questions (3-5 key questions)

Each with context and impact statement.

### 7. Determine Scores

- Dimension scores: Quality, Clarity, Significance, Originality [1-4]
- Overall score: [1-6] with detailed justification
- Confidence: [1-5] with explanation

### 8. Final Assembly

```
SUMMARY: [Factual summary]
STRENGTHS: [List]
WEAKNESSES: [List]
QUESTIONS: [With impacts]
LIMITATIONS: [Yes/No + justification]
ETHICAL CONCERNS: [Yes/No + details]
QUALITY: [1-4]
CLARITY: [1-4]
SIGNIFICANCE: [1-4]
ORIGINALITY: [1-4]
OVERALL SCORE: [1-6] [Justification]
CONFIDENCE: [1-5] [Explanation]
```
