---
name: templates
description: Predefined session palace templates for common workflows
category: templates
tags: [templates, layouts, workflows]
dependencies: [session-palace-builder]
complexity: beginner
estimated_tokens: 350
---

# Session Palace Templates

Pre-designed templates for common session types accelerate palace creation.

## Software Development Workshop

```
Development Workshop Palace
├── Requirements Room (Feature specifications)
├── Architecture Hall (Design decisions)
├── Implementation Forge (Code and development)
├── Testing Arena (Quality assurance)
├── Review Chamber (Code reviews and feedback)
└── Deployment Platform (Release preparation)
```

**Best for**: Feature development, bug fixes, refactoring projects

## Research Library

```
Research Library Palace
├── Question Foyer (Research questions and hypotheses)
├── Methodology Wing (Research approaches)
├── Data Analysis Hall (Findings and insights)
├── Source Gallery (References and citations)
├── Conclusion Chamber (Synthesis and answers)
└── Future Study Alcove (Further research directions)
```

**Best for**: Investigation, analysis, documentation projects

## Decision Council

```
Decision Council Palace
├── Evidence Chamber (Facts and data)
├── Options Gallery (Alternatives considered)
├── Debate Floor (Pros and cons discussion)
├── Vote Hall (Final decisions)
└── Action Registry (Implementation assignments)
```

**Best for**: Architecture decisions, planning sessions, reviews

## Debug Workshop

```
Debug Workshop Palace
├── Symptom Board (Error manifestations)
├── Hypothesis Lab (Potential causes)
├── Investigation Bench (Testing and exploration)
├── Root Cause Vault (Confirmed causes)
└── Fix Foundry (Solution implementation)
```

**Best for**: Bug investigation, troubleshooting, incident response

## Template Customization

Start from a template and modify:
1. Add/remove rooms based on session needs
2. Rename areas for domain specificity
3. Add shortcuts for frequent navigation paths
4. Create sub-areas for detailed organization
