---
name: rust-review
description: |

Triggers: concurrency, traits, rust, ownership, cargo
  Expert-level Rust audits covering ownership, concurrency, unsafe blocks,
  traits, and Cargo dependencies.

  Triggers: Rust review, ownership analysis, borrowing, unsafe audit, concurrency,
  Cargo dependencies, lifetime annotations, trait bounds

  Use when: reviewing Rust code, auditing unsafe blocks, analyzing ownership patterns,
  scanning Cargo dependencies for security

  DO NOT use when: general code review without Rust - use unified-review.
  DO NOT use when: performance profiling - use parseltongue:python-performance pattern.

  Use this skill for Rust-specific code audits.
category: code-review
tags: [rust, ownership, concurrency, unsafe, traits, cargo]
tools: [borrow-checker-analyzer, unsafe-auditor, dependency-scanner]
usage_patterns:
  - rust-audit
  - unsafe-review
  - dependency-audit
  - concurrency-analysis
complexity: advanced
estimated_tokens: 400
progressive_loading: true
dependencies:
  - pensive:shared
  - imbue:evidence-logging
modules:
  - ownership-analysis.md
  - error-handling.md
  - concurrency-patterns.md
  - unsafe-audit.md
  - cargo-dependencies.md
---
## Table of Contents

- [Quick Start](#quick-start)
- [When to Use](#when-to-use)
- [Required TodoWrite Items](#required-todowrite-items)
- [Progressive Loading](#progressive-loading)
- [Core Workflow](#core-workflow)
- [Rust Quality Checklist](#rust-quality-checklist)
- [Safety](#safety)
- [Correctness](#correctness)
- [Performance](#performance)
- [Idioms](#idioms)
- [Output Format](#output-format)
- [Summary](#summary)
- [Ownership Analysis](#ownership-analysis)
- [Error Handling](#error-handling)
- [Concurrency](#concurrency)
- [Unsafe Audit](#unsafe-audit)
- [[U1] file:line](#[u1]-file:line)
- [Dependencies](#dependencies)
- [Recommendation](#recommendation)
- [Exit Criteria](#exit-criteria)


# Rust Review Workflow

Expert-level Rust code audits with focus on safety, correctness, and idiomatic patterns.

## Quick Start

```bash
/rust-review
```
**Verification:** Run the command with `--help` flag to verify availability.

## When to Use

- Reviewing Rust code changes
- Auditing unsafe blocks
- Analyzing concurrency patterns
- Dependency security review
- Performance optimization review

## Required TodoWrite Items

1. `rust-review:ownership-analysis`
2. `rust-review:error-handling`
3. `rust-review:concurrency`
4. `rust-review:unsafe-audit`
5. `rust-review:cargo-deps`
6. `rust-review:evidence-log`

## Progressive Loading

Load modules as needed based on review scope:

**Quick Review** (ownership + errors):
- @include ownership-analysis.md
- @include error-handling.md

**Concurrency Focus**:
- @include concurrency-patterns.md

**Safety Audit**:
- @include unsafe-audit.md

**Dependency Review**:
- @include cargo-dependencies.md

## Core Workflow

1. **Ownership Analysis**: Check borrowing, lifetimes, clone patterns
2. **Error Handling**: Verify Result/Option usage, propagation
3. **Concurrency**: Review async patterns, sync primitives
4. **Unsafe Audit**: Document invariants, FFI contracts
5. **Dependencies**: Scan for vulnerabilities, updates
6. **Evidence Log**: Record commands and findings

## Rust Quality Checklist

### Safety
- [ ] All unsafe blocks documented with SAFETY comments
- [ ] FFI boundaries properly wrapped
- [ ] Memory safety invariants maintained

### Correctness
- [ ] Error handling complete
- [ ] Concurrency patterns sound
- [ ] Tests cover critical paths

### Performance
- [ ] No unnecessary allocations
- [ ] Borrowing preferred over cloning
- [ ] Async properly non-blocking

### Idioms
- [ ] Standard traits implemented
- [ ] Error types well-designed
- [ ] Documentation complete

## Output Format

```markdown
## Summary
Rust audit findings

## Ownership Analysis
[borrowing and lifetime issues]

## Error Handling
[error patterns and issues]

## Concurrency
[async and sync patterns]

## Unsafe Audit
### [U1] file:line
- Invariants: [documented]
- Risk: [assessment]
- Recommendation: [action]

## Dependencies
[cargo audit results]

## Recommendation
Approve / Approve with actions / Block
```
**Verification:** Run the command with `--help` flag to verify availability.

## Exit Criteria

- All unsafe blocks audited
- Concurrency patterns verified
- Dependencies scanned
- Evidence logged
- Action items assigned
## Troubleshooting

### Common Issues

**Command not found**
Ensure all dependencies are installed and in PATH

**Permission errors**
Check file permissions and run with appropriate privileges

**Unexpected behavior**
Enable verbose logging with `--verbose` flag
