---
name: platform-voice-adapter
description: Adapt content tone, length, style, and formatting for specific social media platforms (Twitter, LinkedIn, Instagram, Threads, TikTok). Automatically adjusts voice from technical/casual to professional, optimizes for character limits, and applies platform-specific best practices. Use when reformatting content across channels or creating multi-platform campaigns.
---

# Platform Voice Adapter

Automatically transform content to match the unique voice, style, and constraints of different social media platforms. Each platform has distinct audience expectations, technical limits, and engagement patterns—this skill ensures your content fits perfectly everywhere.

## Overview

The same message performs differently on each platform because:
- **Character limits** vary (280 on Twitter vs 3000 on LinkedIn)
- **Audience expectations** differ (professional on LinkedIn vs casual on Threads)
- **Content formats** require adaptation (threads, carousels, single posts)
- **Algorithm preferences** reward platform-specific patterns

This skill handles all adaptations automatically.

## Platform Specifications

### Twitter / X

**Character Limit:** 280 characters
**Optimal Length:** 220-260 (leaves room for RTs with comments)
**Voice:** Conversational, direct, punchy
**Format:** Single tweet or threads

**Best Practices:**
- Lead with strongest point (hook in first 140 chars)
- Use line breaks for readability (max 2-3 lines per paragraph)
- Include 2-3 hashtags (more looks spammy)
- Add one emoji for visual break (don't overdo)
- Questions increase replies
- Numbered lists perform well in threads

**Thread Specifications:**
- Tweet 1: Hook that makes people want to click "Show More"
- Tweets 2-N: One clear point per tweet, numbered
- Final tweet: CTA (call to action) with link
- Optimal thread length: 5-10 tweets
- Each tweet should be standalone readable

**Tone Spectrum:**
- Technical topics: Approachable expert (not academic)
- Personal updates: Authentic, not overly casual
- Tips/tutorials: Direct instruction, use "you"

**Formatting:**
```
{Hook that creates curiosity}

{Main point in 1-2 lines}

{Supporting detail or benefit}

{2-3 hashtags}
```

### LinkedIn

**Character Limit:** 3,000 characters (posts), 1,300 (optimal for full display)
**Optimal Length:** 1,200-1,500 characters
**Voice:** Professional, thoughtful, storytelling
**Format:** Single post with visual hierarchy

**Best Practices:**
- Start with personal story or relatable scenario
- Use plenty of line breaks (LinkedIn rewards scannable content)
- Include data points and specific metrics
- Tag relevant people/companies (increases reach)
- End with engagement question
- 3-5 hashtags (LinkedIn surfaces hashtag content)
- Post during work hours (8am-6pm, Tue-Thu best)

**Structure:**
```
{Personal hook or story opening}

{Problem statement - relatable to audience}

{Your solution or insight}

Key takeaways:
• {Takeaway 1}
• {Takeaway 2}
• {Takeaway 3}

{Engagement question or CTA}

{Hashtags}
```

**Tone Guidelines:**
- More formal than Twitter, but not corporate stiff
- Show expertise through experience, not credentials
- Vulnerable moments increase engagement
- Avoid sales-y language (provide value first)
- Use "I" statements for personal posts, "you" for advice

**Power Words for LinkedIn:**
- Professional: strategy, framework, insight, approach, methodology
- Results: achieved, implemented, transformed, increased, optimized
- Learning: discovered, learned, realized, found, uncovered

### Instagram

**Caption Limit:** 2,200 characters
**Optimal Length:** 1,000-1,500 (full display without "more")
**Voice:** Visual-first, aspirational, personal
**Format:** Caption supports image/video

**Best Practices:**
- First line is critical (hook before "...more")
- Emojis are expected (use liberally but meaningfully)
- Stories for behind-the-scenes, feed for polished
- Hashtags: 5-10 relevant (can go in comments to keep caption clean)
- Tag location for local reach
- Ask questions to boost comments (algorithm reward)
- Carousel posts get highest engagement

**Caption Structure:**
```
{Hook in first line - visible before "more"}

{Story or context - 2-3 paragraphs}

{Value or lesson}

{CTA - tag friend, comment, save}

•••

{Hashtags - 5-10, can be in first comment instead}
```

**Tone Spectrum:**
- Personal brand: Authentic, conversational, emoji-friendly
- Educational: Simple language, visual metaphors
- Behind-the-scenes: Raw, unpolished is authentic

**Emoji Usage:**
- Use to create visual breaks (not every sentence)
- Replace common words (💰 for money, 🚀 for growth)
- Bullet points can be emojis (✨, 💡, 🔥)

### Threads (Meta)

**Character Limit:** 500 characters per post
**Optimal Length:** 300-400 characters
**Voice:** Casual, authentic, conversational
**Format:** Single post or thread

**Best Practices:**
- Most casual tone of all platforms
- Feels like texting with friends
- Share raw thoughts, not polished essays
- Lowercase acceptable in some contexts
- No hashtags culture (yet)
- Replies and quote posts highly visible
- "Hot takes" and opinions perform well

**Structure:**
```
{Casual conversational hook}

{Main thought - can be incomplete sentences}

{Maybe a follow-up observation}
```

**Tone Guidelines:**
- Write like you talk
- Shorter sentences
- More personal, less promotional
- Humor and personality shine
- Okay to be polarizing (not offensive)

**Do's:**
- ✅ Share opinions
- ✅ Ask open questions
- ✅ React to trends
- ✅ Thread longer thoughts

**Don'ts:**
- ❌ Over-formal language
- ❌ Corporate speak
- ❌ Excessive self-promotion
- ❌ Hashtag spam

### TikTok (Text/Captions)

**Caption Limit:** 2,200 characters
**Optimal Length:** 100-150 characters (people are watching video)
**Voice:** Ultra-casual, trend-aware, punchy
**Format:** Short caption supporting video

**Best Practices:**
- Caption is secondary to video
- Use trending sounds/formats
- Hashtags matter: 3-5 relevant + trending
- First 3 words hook (before "more")
- Direct, almost abrupt tone
- Lowercase trend is strong here
- Questions boost comments

**Caption Formula:**
```
{Hook in 3-5 words}

{Context if needed, ultra-brief}

{CTA or question}

{3-5 hashtags including trending}
```

**Tone:**
- Gen Z friendly (even if not your demo)
- Self-aware humor
- No corporate speak ever
- Embrace trends and memes
- Fast-paced, no fluff

## Voice Adaptation Guidelines

### Technical → Professional (Twitter → LinkedIn)

**Twitter (Technical/Casual):**
```
Just shipped a Claude Code agent that auto-generates content hooks using Kallaway frameworks 🔥

15 files, 3 hours, zero manual prompt engineering.

Thread on how I structured it 👇
```

**LinkedIn (Professional/Storytelling):**
```
I spent 3 hours yesterday building something that would've taken me 3 days last month.

The project: An autonomous content generation agent using Claude Code and proven viral hook frameworks.

The result: 15 Python files that transform raw project data into engagement-optimized social posts.

Here's what I learned about structuring AI agents for creative workflows:

• Separation of concerns beats monolithic prompts
• Framework-driven generation ensures consistency
• Progressive disclosure manages token budgets
• Event-driven architecture enables autonomy

The breakthrough wasn't the code—it was realizing that content frameworks are just structured prompts. Feed Claude the right pattern library, and it becomes a content strategist.

Building in public with #ClaudeCode. What content workflows are you automating?

#AI #Automation #ContentStrategy #BuildingInPublic
```

### Professional → Casual (LinkedIn → Threads)

**LinkedIn (Professional):**
```
I discovered an interesting pattern while implementing context management for Claude Code agents.

By structuring documentation as hierarchical prompt libraries rather than static README files, we achieved 10x better context retention across sessions.

The key insight: Documentation isn't for humans anymore—it's for AI.
```

**Threads (Casual):**
```
wait

what if we stopped writing docs for humans and just wrote them as prompts for claude?

tested this in my personal-os project and it's actually wild how much better it works

like your readme.md becomes a literal instruction set that claude reads instead of you explaining the project every time

game changer honestly
```

### Casual → Ultra-Casual (Instagram → TikTok)

**Instagram:**
```
POV: You just realized your documentation is actually prompt engineering 💡

I stopped writing README files for human readers and started writing them as instruction sets for Claude Code.

The result? Claude understands my projects instantly without me re-explaining the context every session.

Swipe for the 3-step framework I use →

#ClaudeCode #AI #Productivity #DeveloperTools #BuildingInPublic
```

**TikTok:**
```
docs are just prompts for claude

mind = blown 🤯

#claudecode #aitools #coding
```

## Cross-Platform Adaptation Workflow

### Step 1: Identify Source Content

Extract core elements:
- **Main message:** What's the one key point?
- **Supporting points:** What evidence/details exist?
- **Call to action:** What should audience do?
- **Tone of source:** Where is it on casual → professional spectrum?

### Step 2: Select Target Platform(s)

Consider:
- **Audience overlap:** Is your LinkedIn audience the same as Twitter?
- **Content type fit:** Does this suit the platform? (Technical deep-dives great for LinkedIn, less so for TikTok)
- **Format requirements:** Can you support with visuals/video?

### Step 3: Adapt Length

**Expansion (Twitter → LinkedIn):**
1. Add personal story context
2. Include data points and metrics
3. Expand single points into bullet lists
4. Add "key takeaways" section
5. Include engagement question

**Compression (LinkedIn → Twitter):**
1. Extract core insight
2. Remove story context (or save for thread)
3. Use power words to compact ideas
4. Focus on hook + one key point
5. Save supporting details for thread

### Step 4: Adjust Tone

**Professionalizing (casual → professional):**
- Replace contractions (can't → cannot)
- Remove excessive emojis
- Add industry terminology
- Include credentials/data
- Structured formatting (bullets, numbers)

**Casualizing (professional → casual):**
- Use contractions
- Shorter sentences
- More conversational phrases ("honestly," "wait," "here's the thing")
- Add personality and humor
- Break grammar rules occasionally (lowercase, fragments)

### Step 5: Format for Platform

Apply platform-specific:
- **Line breaks:** LinkedIn loves white space, Twitter needs compactness
- **Emojis:** Instagram/Threads expect them, LinkedIn uses sparingly
- **Hashtags:** LinkedIn 3-5, Instagram 5-10, Twitter 2-3, Threads minimal
- **Structure:** LinkedIn needs clear sections, Twitter needs flow

### Step 6: Optimize for Engagement

**Twitter:** Ask questions, create threads, use polls
**LinkedIn:** End with engagement question, tag relevant people
**Instagram:** "Tag a friend who needs this," save/share prompts
**Threads:** Controversial takes, open questions
**TikTok:** Duet/stitch hooks, trending hashtags

## Platform-Specific Templates

### The Same Idea, 5 Platforms

**Core Idea:** "I built an agent that auto-generates viral hooks using Claude Code and the Kallaway framework. Saved 10 hours per week."

**Twitter:**
```
Just automated my content hook generation with Claude Code 🤖

Input: Project metadata
Output: Viral hooks using Kallaway frameworks

10 hours/week saved on ideation.

The secret? Treating frameworks as structured prompts.

#ClaudeCode #Automation
```

**LinkedIn:**
```
I automated the most time-consuming part of my content workflow this week.

The problem: I was spending 10+ hours weekly brainstorming social media hooks for my building-in-public updates.

The solution: An autonomous Claude Code agent that applies proven viral frameworks (Kallaway's contrarian, benefit-driven, transformation, and how-to patterns) to my daily project data.

How it works:
• Scans project activity (files changed, features shipped, problems solved)
• Matches patterns to appropriate hook frameworks
• Generates 3-5 hook variations per project update
• Outputs formatted for each platform (Twitter, LinkedIn, Threads)

The insight that made this work: Content frameworks are just structured prompts. Instead of manually applying "contrarian hook to project X," I feed Claude the framework pattern library and let it match context to template.

Week 1 results:
• 47 hooks generated from 12 project updates
• 10 hours saved
• Higher engagement (frameworks are proven patterns)
• Zero decision fatigue

Next step: Adding performance tracking so the agent learns which hook types perform best for which project categories.

Building in public with #ClaudeCode. What repetitive creative tasks are you automating?

#AI #ContentStrategy #Automation #BuildingInPublic #ProductivityHacks
```

**Instagram:**
```
POV: You just saved 10 hours per week on content ideation 💡

Swipe to see how I automated viral hook generation using Claude Code →

The framework:
1️⃣ Project metadata goes in
2️⃣ Claude applies Kallaway hook formulas
3️⃣ Viral hooks come out

No more staring at blank screens trying to make technical updates sound interesting.

The agent matches my project activity (new features, bugs fixed, lessons learned) to proven engagement patterns:
✨ Contrarian hooks for surprising insights
📈 Transformation hooks for before/after wins
🎯 How-to hooks for tutorials
💡 Benefit-driven hooks for value props

Week 1 = 47 hooks generated, zero creative block.

Tag someone who needs this ⬇️

#ClaudeCode #AI #ContentAutomation #BuildingInPublic #ProductivityHack #SoloFounder #CreatorEconomy
```

**Threads:**
```
i automated the "what should i post about" problem and it's honestly changed everything

built a claude code agent that reads my daily project activity and generates viral hooks using proven frameworks

input: "shipped 12 files in personal-os agents"
output: "The Personal-OS breakthrough that saved me 10 hours (here's the workflow)"

it's just pattern matching but it works??

10 hours/week back in my life
```

**TikTok Caption:**
```
how to never run out of content ideas (use AI)

#claudecode #contentcreator #automation #aitools
```

## Quality Checklist

Before publishing adapted content:

**Tone:**
- [ ] Matches platform voice (casual vs professional)
- [ ] Appropriate emoji usage for platform
- [ ] Contractions match platform norms

**Length:**
- [ ] Within character limits
- [ ] Optimal length for full display
- [ ] Not artificially padded or cut

**Format:**
- [ ] Line breaks appropriate for platform
- [ ] Hashtags in right quantity and placement
- [ ] Platform-specific structure (bullets, numbers, sections)

**Engagement:**
- [ ] Includes CTA appropriate for platform
- [ ] Hooks work in platform context
- [ ] Encourages platform-specific interactions (retweet, comment, save, share)

**Visual:**
- [ ] Supports visual if required (Instagram, TikTok)
- [ ] Text doesn't compete with image
- [ ] Caption enhances rather than repeats visual

## Integration with Content Workflow

**Recommended Stack:**
1. Content idea generation → Social Media Content Agent
2. Hook creation → viral-hook-generator skill
3. Platform adaptation → This skill (platform-voice-adapter)
4. Platform-specific optimization → linkedin-thought-leader, twitter-thread-builder (as needed)
5. Publishing → Manual or scheduling tool

**Typical Flow:**
```
Raw idea (from daily project scan)
    ↓
viral-hook-generator (creates engaging hook)
    ↓
platform-voice-adapter (adapts for each platform)
    ↓
[Optional] Platform-specific skill (linkedin-thought-leader for deeper LinkedIn adaptation)
    ↓
Ready to publish
```

## Reference Files

See `/references/` for:
- `platform_specs.json` - Complete specifications for all platforms
- `voice_guidelines.md` - Detailed tone guides with examples
- `emoji_usage_guide.md` - Platform-appropriate emoji patterns
- `hashtag_strategies.md` - Hashtag optimization by platform
