# 11 Essential Landing Page Elements

Based on DESIGNNAS guidelines. This reference provides detailed explanations of each essential element.

## 1. URL with Keywords (주요 키워드가 포함된 URL)

**Principle:** URLs should contain relevant keywords related to the product or service.

**Implementation:**
- Helps with SEO optimization
- Users can understand page content just from the URL
- Shorter and more memorable URLs are better

**Good Examples:**
- `www.example.com/eco-friendly-water-bottles`
- `www.example.com/premium-coffee-subscription`

**Bad Examples:**
- `www.example.com/page123`
- `www.example.com/prod?id=4567`

---

## 2. Company Logo (회사 로고)

**Principle:** Logo should be placed in a prominent position, typically top-left of the page.

**Implementation:**
- Allows users to immediately recognize the brand
- Important visual element
- Clear and familiar logo builds trust from the first moment

**Placement Recommendations:**
- Top-left of page header
- Link to homepage on click
- Ensure sufficient whitespace

---

## 3. SEO-Optimized Title and Subtitle (SEO 최적화된 제목과 부제목)

**Principle:** Title and subtitle should naturally include keywords for SEO optimization.

**Implementation:**
- Must be clear and compelling, answering "What benefits does this page offer me?"
- Strong titles make visitors stay longer on the page

**Writing Tips:**
- Include main keywords in H1 tag
- Concise and clear message
- Present user's problem and solution
- Specify concrete benefits

**Good Examples:**
- "The Easiest Way to Save the Planet with Eco-Friendly Tumblers"
- "Double Your English Conversation Skills in 30 Days Program"

---

## 4. Primary CTA (Call-to-Action) (주요 행동 유도 문구)

**Principle:** Primary CTA is the most important call-to-action, usually placed right below the title.

**Implementation:**
- Delivers prominent and direct messages like "Get Started" or "Sign Up Free"
- Plays key role in guiding customer journey

**Design Principles:**
- Make it stand out with contrasting colors
- Sufficiently large button size
- Clear action-oriented copy
- Ensure sufficient surrounding whitespace

**Good CTA Examples:**
- "Start for Free"
- "Try It Now"
- "Get Limited Discount"
- "Request Demo"

---

## 5. Social Proof (사회적 증거)

**Principle:** Social proof can include reviews, certifications, or number of users.

**Implementation:**
- Increases credibility and reduces hesitation when customers make decisions
- Users tend to trust other people's opinions and experiences

**Elements to Include:**
- Customer reviews and ratings (stars)
- User count statistics
- Logos of famous companies/institutions
- Awards and certifications
- Press coverage

**Effective Display Methods:**
- Real user names and photos
- Present specific numbers
- Cite trustworthy sources

---

## 6. Images or Videos (이미지 또는 영상)

**Principle:** Images or videos help clearly demonstrate product value and functionality.

**Implementation:**
- Visual content helps users consume information faster and more engagingly
- One short video can replace multiple paragraphs of text

**Content Types:**
- Product demonstration videos
- Product usage images
- Infographics
- High-quality professional photos

**Precautions:**
- Use high-resolution images
- Optimize for fast loading
- Include alt text
- Size well for mobile viewing

---

## 7. Core Benefits / Features (핵심 혜택 / 기능)

**Principle:** This section should clearly present the main benefits and core features the product offers.

**Implementation:**
- Users are more interested in value they can get than technical details
- Good to emphasize benefits before explaining features

**Writing Method:**
- Select 3-6 core benefits/features
- Add icons to each item
- Concise title and description
- Use user-centric language

**Structure Example:**
```
[Icon] Time Saving
Automate complex tasks and save 2 hours per day

[Icon] Cost Reduction
Reduce operating costs by 30% on average per month

[Icon] Easy to Use
Intuitive interface you can start in 5 minutes
```

---

## 8. Customer Testimonials (고객 후기)

**Principle:** Real customer testimonials are the most powerful evidence for building trust.

**Implementation:**
- Users can be confident that the product truly provides value
- Presenting customer photos and names together increases credibility

**Effective Testimonial Section:**
- Place 4-6 customer testimonials
- Elements to include in each testimonial:
  * Customer name
  * Job title/company (if applicable)
  * Profile photo
  * Star rating or evaluation
  * Specific and authentic review content

**Testimonial Selection Criteria:**
- Mention specific results or benefits
- Cover diverse use cases
- Authentic expression
- Appropriate length (not too short or long)

---

## 9. FAQ Section (자주 묻는 질문)

**Principle:** FAQ section resolves customers' common questions.

**Implementation:**
- Customers can get answers quickly, saving time for both business and customers
- FAQs are effective in reducing pre-purchase barriers

**FAQ Writing Guide:**
- Select 5-10 core questions
- Recommend accordion format where answers expand on click
- Concise and clear answers
- Provide links if additional information needed

**Question Types to Include:**
- Basic product/service information
- Pricing and payment methods
- Refund policy
- Technical requirements
- Customer support methods

**Example Questions:**
- "How long is the free trial period?"
- "Can I use it without a contract period?"
- "What are the differences from other platforms?"

---

## 10. Final CTA (최종 행동 유도 문구)

**Principle:** Final CTA is usually placed at the bottom of the page, serving as a final reminder for customers to take action.

**Implementation:**
- Provides second chance for visitors who didn't click first CTA
- Must contain clear and strong message

**Placement Strategy:**
- Bottom of page, after FAQ
- Distinguish with prominent background color or section
- Same or similar message as primary CTA

**Effective Final CTA:**
- Add urgency: "Start Now", "Special Offer Today Only"
- Remove risk: "Free Trial", "Cancel Anytime"
- Clear button design
- Ensure sufficient surrounding whitespace

---

## 11. Contact Information / Legal Pages (연락처 정보 / 법적 페이지)

**Principle:** Contact information and legal pages like privacy policy and terms of service are essential for building company credibility.

**Implementation:**
- Users feel more secure when they can easily contact when needed
- Necessary element for professional websites

**Information to Include in Footer:**
- Company address
- Email address
- Phone number
- Social media links
- Privacy policy link
- Terms of service link
- Cookie policy (if applicable)

**Essential Elements for Legal Pages:**
- Clear and understandable language
- Keep information up to date
- Easily accessible location
- Comply with GDPR, CCPA and other regulations
