# Web to Markdown Converter

웹페이지를 마크다운 형식으로 변환하여 저장하는 Claude 스킬입니다.

## 개요

이 스킬은 웹페이지 URL을 입력받아 해당 페이지의 HTML 콘텐츠를 깔끔한 마크다운 형식으로 변환합니다. 블로그 글, 기술 문서, 튜토리얼 등을 로컬에 아카이빙하고 싶을 때 유용합니다.

## 주요 기능

- **간단한 변환**: URL만 입력하면 자동으로 마크다운 변환
- **스마트 정리**: 불필요한 네비게이션, 광고 등 자동 제거
- **캐싱**: 같은 URL을 반복 요청해도 빠른 응답
- **일괄 처리**: 여러 URL을 한 번에 변환 가능
- **커스터마이징**: 특정 섹션만 추출하거나 포맷 지정 가능
- **AI 최적화 모드** ⭐: AI 에이전트가 컨텍스트로 활용하기 최적화된 형태로 변환
- **듀얼 모드** ⭐⭐ NEW: 원본 + AI 최적화 버전 2개 파일 동시 생성

## 사용 방법

### 기본 사용

```
User: https://example.com/article 이거 마크다운으로 저장해줘

Claude: 파일명을 어떻게 할까요? (기본: webpage.md)

User: article.md

Claude: ✅ 웹페이지를 마크다운으로 변환했습니다!
```

### 여러 페이지 일괄 변환

```
User: 이 URL들을 전부 마크다운으로 저장해줘
- https://example.com/doc1
- https://example.com/doc2
- https://example.com/doc3
```

### 내용만 보기 (저장 안 함)

```
User: https://example.com 내용을 마크다운으로 보여줘만 하고 저장은 하지마
```

### AI 최적화 모드 ⭐ NEW

AI 에이전트가 컨텍스트로 활용하기 최적화된 형태로 변환합니다.

```
User: https://react.dev/reference/react/useState 를 AI가 읽기 좋게 변환해줘

Claude: AI 최적화 모드로 변환하겠습니다.
구조화된 프론트매터, 핵심 요약, 명확한 섹션을 추가합니다.

✅ 저장 완료!
📄 react-useState.context.md
📊 원본 3,500 토큰 → 최적화 2,100 토큰 (40% 절감)
```

**AI 최적화 모드의 특징:**
- 📋 **구조화된 메타데이터**: YAML 프론트매터 (제목, 주제, 요약, 난이도)
- 🎯 **핵심 요약**: 3-5줄로 빠른 이해 가능
- 📚 **명확한 계층**: H2/H3 섹션으로 탐색 용이
- 💡 **인사이트 추출**: 핵심 포인트 bullet points로 정리
- 🚀 **토큰 절감**: 불필요한 요소 제거로 30-50% 절감
- 🔍 **검색 최적화**: topics 기반 분류 가능

**활용 사례:**
- RAG (Retrieval-Augmented Generation) 시스템 구축
- AI 에이전트 학습 자료 준비
- 지식 베이스 구축
- 문서 비교 분석

**자세한 내용**: `AI_OPTIMIZATION.md` 참고

### 듀얼 모드 ⭐⭐ NEW

원본 마크다운과 AI 최적화 버전을 동시에 생성합니다.

```
User: https://react.dev/reference/react/useState 원본이랑 AI 최적화 버전 둘 다 만들어줘

Claude: 듀얼 모드로 변환하겠습니다.
[원본 변환 중...]
[AI 최적화 변환 중...]

✅ 듀얼 모드 변환 완료! 2개 파일이 생성되었습니다.

📄 원본 마크다운:
- 파일: useState.md
- 크기: 약 3,500 글자
- 용도: 사람이 읽기 좋은 원본 보존

📄 AI 최적화 버전:
- 파일: useState.context.md
- 크기: 약 2,100 글자 (40% 절감)
- 용도: AI 컨텍스트로 활용

💡 팁:
- 원본(.md)은 사람이 읽을 때
- AI 최적화(.context.md)는 RAG 시스템이나 AI 컨텍스트로
```

**듀얼 모드의 장점:**
- 🎯 **용도별 최적화**: 사람용 vs AI용 동시 확보
- 💾 **원본 보존**: 원본 그대로 백업
- 🚀 **토큰 절감**: AI용은 40% 토큰 절감
- 🔄 **비교 가능**: 두 버전 비교 분석 가능
- ⚡ **한 번에 처리**: 2번 요청할 필요 없음

**활용 시나리오:**
- 기술 문서를 사람도 읽고 AI도 활용할 때
- 백업과 AI 학습을 동시에 하고 싶을 때
- 원본 충실도와 AI 효율성을 모두 원할 때

## 활성화 키워드

다음과 같은 요청에 자동으로 활성화됩니다:

**일반 모드:**
- "웹페이지를 마크다운으로 변환해줘"
- "이 URL을 마크다운으로 저장해줘"
- "웹사이트 내용을 마크다운 파일로 만들어줘"
- "웹페이지 아카이빙해줘"
- "블로그 글을 마크다운으로 저장해줘"

**AI 최적화 모드:**
- "AI가 읽기 좋게 변환해줘"
- "컨텍스트로 사용하기 좋게 변환해줘"
- "AI 학습용으로 변환해줘"
- "RAG 시스템용으로 변환해줘"

**듀얼 모드:**
- "원본이랑 AI 최적화 버전 둘 다 만들어줘"
- "원본도 저장하고 AI용도 만들어줘"
- "2개 버전으로 저장해줘"
- "사람용이랑 AI용 둘 다"

## 변환되는 요소

### 포함되는 요소
- 제목 (H1-H6)
- 본문 텍스트
- 링크
- 이미지 (URL 링크로)
- 리스트
- 코드 블록
- 인용구
- 테이블

### 제외되는 요소
- 네비게이션 메뉴
- 푸터
- 광고
- 사이드바 (대부분의 경우)

## 제한사항

- JavaScript로 동적 렌더링되는 콘텐츠는 포함되지 않을 수 있습니다
- 이미지는 다운로드되지 않고 원본 URL 링크로 저장됩니다
- 매우 긴 문서는 요약될 수 있습니다
- 접근 권한이 필요한 페이지는 변환할 수 없습니다

## 활용 예시

### 일반 모드

#### 1. 기술 문서 아카이빙
```
프로젝트에 필요한 공식 문서들을 로컬에 저장하여 오프라인에서도 참고
```

#### 2. 블로그 글 백업
```
중요한 블로그 글을 마크다운으로 저장하여 개인 아카이브 구축
```

#### 3. 학습 자료 정리
```
온라인 튜토리얼이나 가이드를 마크다운으로 변환하여 학습 노트에 통합
```

#### 4. 콘텐츠 마이그레이션
```
다른 플랫폼의 콘텐츠를 마크다운으로 변환하여 새 시스템에 이전
```

### AI 최적화 모드 ⭐

#### 5. RAG 시스템 구축
```
AI 에이전트가 참고할 수 있는 지식 베이스를 구조화된 형태로 구축
- 45개 문서를 AI 최적화 모드로 변환
- 프론트매터의 topics로 자동 분류
- 토큰 40% 절감으로 비용 효율적
```

#### 6. AI 에이전트 학습 자료
```
기술 문서를 AI가 빠르게 이해할 수 있는 형태로 변환
- 핵심 요약으로 3초 내 파악
- 명확한 섹션 구조로 특정 정보 쉽게 추출
- 인사이트 정리로 best practices 학습
```

#### 7. 지식 베이스 관리
```
topics 기반으로 문서를 자동 분류하고 검색 최적화
- 프론트매터 메타데이터로 필터링
- content_type과 difficulty로 적절한 문서 선택
- 일관된 구조로 유지보수 용이
```

#### 8. 문서 비교 분석
```
여러 기술이나 접근법을 AI가 체계적으로 비교
- 구조화된 포맷으로 공정한 비교
- 핵심 인사이트로 차이점 명확히
- 실용적 적용 섹션으로 선택 기준 제시
```

## 기술 스택

- **WebFetch**: Claude의 웹 페이지 가져오기 도구 (HTML → 마크다운 자동 변환)
- **Write**: 파일 저장 도구
- **캐싱**: 15분 자가 정리 캐시

## 팁

1. **명확한 파일명**: 나중에 찾기 쉽도록 의미 있는 파일명 사용
2. **폴더 정리**: 주제별로 폴더를 만들어 체계적으로 관리
3. **저작권 주의**: 변환한 콘텐츠는 개인적인 용도로만 사용
4. **정기 백업**: 중요한 온라인 리소스는 주기적으로 백업

## 문제 해결

### URL 오류
- URL이 `http://` 또는 `https://`로 시작하는지 확인
- 전체 URL을 복사했는지 확인

### 접근 불가
- 페이지가 여전히 존재하는지 확인
- 로그인이 필요한 페이지는 변환할 수 없음
- VPN이나 방화벽이 차단하고 있지 않은지 확인

### 저장 실패
- 파일 경로에 쓰기 권한이 있는지 확인
- 디렉토리가 존재하는지 확인
- 파일명에 특수문자가 있는지 확인

## 라이선스

이 스킬은 Claude Code의 일부로, 개인적 및 교육적 용도로 자유롭게 사용할 수 있습니다.

## 피드백

문제나 개선 아이디어가 있으시면 언제든지 공유해주세요!
