# 카드 뉴스 생성기 스킬 - 빠른 시작 가이드

## 🎯 이 스킬은 무엇인가요?

소셜 미디어(인스타그램, 페이스북, 카카오톡 등)에 올릴 수 있는 텍스트 기반 카드 뉴스 이미지를 자동으로 생성하는 Claude 스킬입니다.

## ✨ 주요 기능

- ✅ 한글 텍스트 완벽 지원
- ✅ 커스텀 배경색 및 텍스트 색상
- ✅ 자동 중앙 정렬 및 레이아웃
- ✅ 숫자 배지 지원 (시리즈물)
- ✅ 다양한 이미지 크기 지원

## 📦 설치 방법

### 1단계: 스킬 폴더 설정

```bash
# Claude Code의 skills 디렉토리에 압축 해제
cd ~/.claude/skills/user
tar -xzf card-news-generator.tar.gz
```

### 2단계: 필요한 패키지 설치

```bash
pip install Pillow --break-system-packages
```

### 3단계: 한글 폰트 설치 (Ubuntu/Debian)

```bash
sudo apt-get update
sudo apt-get install -y fonts-noto-cjk
```

## 🚀 사용 방법

### 방법 1: 인터랙티브 모드 (초보자 추천)

가장 쉬운 방법입니다. Claude에게 이렇게 요청하세요:

```
카드 뉴스를 만들고 싶어. 인터랙티브 모드로 실행해줘.
```

그러면 Claude가 `interactive_generator.py`를 실행하고, 다음을 차례로 물어봅니다:

1. **제목 입력** (여러 줄 가능)
   ```
   선생님·부모보다
   유튜브 등을 더 신뢰함
   (빈 줄 입력으로 완료)
   ```

2. **내용 입력** (여러 줄 가능)
   ```
   정보 접근이 빠르고,
   권위보다 '속도'를 더 신뢰함.
   (빈 줄 입력으로 완료)
   ```

3. **배경색 선택** (RGB 형식)
   ```
   추천 색상이 표시됩니다:
   • 따뜻한 베이지: 245,243,238
   • 소프트 핑크: 255,229,229
   • 민트 그린: 224,244,241
   등등...
   
   원하는 색상 입력: 245,243,238
   ```

4. **텍스트 색상** (RGB 형식)
   ```
   기본값 사용하려면 빈 값 입력
   또는 RGB 값 입력: 26,26,26
   ```

5. **카드 번호** (선택사항)
   ```
   1
   ```

6. **파일명**
   ```
   card_01.png
   ```

완료! 카드가 자동으로 생성됩니다.

### 방법 2: Claude에게 직접 요청 (빠른 방법)

모든 정보를 한 번에 제공:

```
제목: "선생님·부모보다 유튜브 등을 더 신뢰함"
내용: "정보 접근이 빠르고, 권위보다 '속도'를 더 신뢰함."
배경색: RGB 245,243,238 (따뜻한 베이지)
텍스트: RGB 26,26,26 (검정)
번호: 1

이 내용으로 카드 뉴스를 만들어줘.
```

Claude가 자동으로 RGB 값을 Hex로 변환하고 카드를 생성합니다.

### 고급 사용법

#### 커스텀 색상 지정
```
핑크색 배경으로 카드를 만들어줘.
제목: "나만의 제목"
내용: "나만의 내용"
배경 RGB: 255,229,229
텍스트 RGB: 44,24,16
```

#### 정사각형 포맷 (인스타그램)
```
1080x1080 정사각형으로 카드를 만들어줘.
제목과 내용은 인터랙티브로 입력할게.
```

#### 시리즈 카드 생성
```
다음 내용으로 3개의 카드 뉴스 시리즈를 만들어줘.
모두 베이지 배경(245,243,238)으로 통일:

1. 제목: "첫 번째", 내용: "첫 번째 설명"
2. 제목: "두 번째", 내용: "두 번째 설명"  
3. 제목: "세 번째", 내용: "세 번째 설명"
```

## 🎨 추천 색상 조합

| 스타일 | 배경 RGB | 텍스트 RGB | Hex (참고) | 용도 |
|-------|---------|-----------|-----------|-----|
| 클래식 베이지 | `245,243,238` | `26,26,26` | `#f5f3ee` / `#1a1a1a` | 기본, 모든 주제 |
| 소프트 핑크 | `255,229,229` | `44,24,16` | `#ffe5e5` / `#2c1810` | 부드러운 주제 |
| 민트 프레시 | `224,244,241` | `26,26,26` | `#e0f4f1` / `#1a1a1a` | 자연, 건강 |
| 감성 라벤더 | `232,224,245` | `44,24,16` | `#e8e0f5` / `#2c1810` | 힐링, 감성 |
| 따뜻한 피치 | `255,232,214` | `44,24,16` | `#ffe8d6` / `#2c1810` | 활력, 따뜻함 |
| 프로페셔널 블루 | `227,242,253` | `26,26,26` | `#e3f2fd` / `#1a1a1a` | 비즈니스, 전문성 |

**색상 선택 팁:**
- 인터랙티브 모드: RGB 값 그대로 입력 (예: `245,243,238`)
- Claude에게 요청: "베이지 배경", "핑크 배경" 등으로 말해도 됩니다

## 📐 이미지 크기 가이드

| 플랫폼 | 권장 크기 | 용도 |
|--------|----------|-----|
| 인스타그램 스토리 | 1080 x 1920 | 세로형 풀스크린 |
| 인스타그램 피드 | 1080 x 1080 | 정사각형 |
| 페이스북 포스트 | 1200 x 630 | 가로형 |
| 카카오톡 | 1080 x 1920 | 세로형 |
| 블로그 썸네일 | 1200 x 630 | 가로형 |

## 💡 팁 & 트릭

### 1. 텍스트 줄바꿈
긴 제목이나 내용은 자연스러운 위치에서 줄바꿈하세요:
```
제목: "선생님·부모보다\n유튜브 등을 더 신뢰함"
```

### 2. 시리즈물 일관성
시리즈로 여러 장을 만들 때는 같은 배경색을 사용하세요:
```
모든 카드를 베이지색(#F5F3EE) 배경으로 통일해줘.
```

### 3. 가독성 최적화
- 제목은 15자 내외로 간결하게
- 본문은 30자 내외로 핵심만
- 밝은 배경에는 어두운 텍스트
- 어두운 배경에는 밝은 텍스트

### 4. 브랜딩
고유한 색상 조합을 정해서 일관되게 사용하면 브랜드 인지도가 높아집니다.

## 🔧 문제 해결

### Q: 한글이 깨져서 나와요
```bash
# 폰트 재설치
sudo apt-get install --reinstall fonts-noto-cjk
fc-cache -fv
```

### Q: "PIL" 모듈을 찾을 수 없다고 나와요
```bash
pip install --upgrade Pillow --break-system-packages
```

### Q: 이미지가 생성은 되는데 다운로드 링크가 안 보여요
Claude가 `/mnt/user-data/outputs/` 폴더에 저장했는지 확인하고, 
`computer://` 링크를 제공하도록 요청하세요.

### Q: 텍스트가 너무 작거나 커요
폰트 크기를 조정해 달라고 요청하세요:
```
제목 폰트 크기를 150으로, 본문은 70으로 조정해줘.
```

## 📝 예제 모음

### 예제 1: 인터랙티브 모드로 기본 카드
```
카드 뉴스를 인터랙티브 모드로 만들어줘.

→ 제목: 오늘의 명언
→ 내용: 작은 실천이\n큰 변화를 만든다
→ 배경 RGB: 245,243,238 (또는 Enter로 기본값)
→ 텍스트 RGB: (Enter로 기본값)
→ 번호: (Enter로 생략)
→ 파일명: quote_card.png
```

### 예제 2: 직접 명령으로 정보 전달
```
제목: "앱 업데이트 안내"
내용: "v2.0 버전이 출시되었습니다.\n새로운 기능을 확인하세요!"
배경: 베이지 (245,243,238)
번호: 1
파일명: update_card.png

이 내용으로 카드를 만들어줘.
```

### 예제 3: 이벤트 공지 (커스텀 색상)
```
제목: "특별 할인 이벤트"
내용: "지금 가입하면\n첫 달 50% 할인"
배경: 피치색 (255,232,214)
텍스트: 갈색 (44,24,16)

이렇게 카드 만들어줘.
```

### 예제 4: 교육 콘텐츠 시리즈
```
Python 기초 시리즈를 3장 만들어줘.
모두 스카이블루 배경 (227,242,253)으로:

1. 제목: "Python 기초", 내용: "변수란 데이터를\n저장하는 공간입니다"
2. 제목: "Python 기초", 내용: "함수는 코드를\n재사용 가능하게 합니다"  
3. 제목: "Python 기초", 내용: "리스트는 여러 값을\n순서대로 저장합니다"
```

## 🎓 고급 활용

### 자동화된 시리즈 생성
JSON 형식으로 여러 카드 내용을 제공하면 Claude가 자동으로 시리즈를 생성합니다:

```json
[
  {"title": "첫 번째 주제", "content": "첫 번째 설명"},
  {"title": "두 번째 주제", "content": "두 번째 설명"},
  {"title": "세 번째 주제", "content": "세 번째 설명"}
]
```

### 브랜드 색상 세트 저장
자주 사용하는 색상 조합을 Claude에게 기억하도록 요청:
```
우리 브랜드 색상은 배경 RGB 245,243,238, 텍스트 RGB 44,24,16이야. 
앞으로 카드 만들 때 이 색상을 기본으로 써줘.
```

**참고**: Claude는 RGB 값을 자동으로 Hex 코드로 변환해서 명령어를 실행합니다. 
예: RGB `245,243,238` → Hex `#f5f3ee`

## 📄 라이선스

MIT License - 자유롭게 사용, 수정, 배포 가능합니다.

## 🙋‍♂️ 도움이 필요하신가요?

Claude에게 다음과 같이 물어보세요:
- "카드 뉴스 스킬 사용법 알려줘"
- "다른 배경색 추천해줘"
- "이 카드를 정사각형으로 다시 만들어줘"
- "텍스트 크기를 조정해줘"

즐거운 카드 뉴스 제작 되세요! 🎉
