# Component Catalog

Comprehensive guide to all shadcn/ui components.

## Layout Components

### Card
- Basic card structure
- Card with header, content, footer
- Clickable cards
- Card grid layouts

### Separator
- Horizontal and vertical separators
- Use in layouts and forms

### Aspect Ratio
- Responsive image containers
- Video embeds

## Form Components

### Input
- Text, email, password inputs
- Input with icons
- Input validation states

### Textarea
- Multi-line text input
- Resizable options

### Select
- Single select dropdown
- Multi-select
- Searchable select

### Checkbox & Radio
- Single checkbox
- Checkbox groups
- Radio groups

### Switch
- Toggle switch
- With labels

### Slider
- Range slider
- Multiple handles

### Date Picker
- Single date
- Date range
- Time picker

## Data Display

### Table
- Basic table
- Sortable columns
- Pagination
- Row selection

### Badge
- Status badges
- Count badges
- Custom colors

### Avatar
- User avatars
- With fallback
- Avatar groups

### Progress
- Linear progress
- Circular progress
- With labels

## Feedback

### Toast
- Success, error, warning toasts
- Action buttons
- Auto-dismiss

### Alert
- Info, warning, error alerts
- Dismissible alerts
- With actions

### Alert Dialog
- Confirmation dialogs
- Destructive actions

## Overlay

### Dialog (Modal)
- Basic modal
- Form in modal
- Nested modals
- Scrollable content

### Drawer
- Sheet from side
- With form

### Popover
- Contextual info
- Form popover

### Tooltip
- Simple tooltip
- Rich content tooltip

## Navigation

### Dropdown Menu
- Basic menu
- With icons
- With keyboard shortcuts
- Nested menus

### Command
- Command palette
- Searchable commands
- With keyboard navigation

### Menubar
- Application menu
- With submenus

### Navigation Menu
- Horizontal navigation
- With dropdowns

### Tabs
- Basic tabs
- Vertical tabs
- With icons

### Breadcrumb
- Page hierarchy
- With dropdown

## Utility

### Accordion
- Single or multiple open
- With icons

### Collapsible
- Expandable sections

### Context Menu
- Right-click menu

### Hover Card
- Preview on hover

### Scroll Area
- Custom scrollbars

For implementation examples, see the main SKILL.md file.
