# Configuration Guide

Comprehensive guide to customizing Tailwind CSS configuration.

## Theme Customization

### Colors
- Extending the default color palette
- Custom color shades
- Opacity modifiers

### Spacing
- Custom spacing values
- Negative spacing

### Typography
- Custom fonts
- Font sizes
- Line heights
- Letter spacing

### Breakpoints
- Custom responsive breakpoints
- Container sizes

### Border Radius
- Custom radius values

## Content Configuration

- Configuring content paths
- Template paths for purging
- Safe listing classes

## Plugins

### Official Plugins
- @tailwindcss/forms
- @tailwindcss/typography
- @tailwindcss/aspect-ratio
- @tailwindcss/container-queries

### Custom Plugins
- Creating custom utilities
- Adding custom variants
- Extending base styles

## Dark Mode

- Class-based dark mode
- Media query dark mode
- Custom dark mode variants

## Production Optimization

- PurgeCSS configuration
- Minification
- File size optimization

See main SKILL.md for configuration examples.
