# Utility Patterns

Advanced Tailwind CSS utility patterns and techniques.

## Spacing Utilities

- Consistent spacing scale (0, 0.5, 1, 1.5, 2, 2.5, 3, 4, 5, 6, 8, 10, 12, 16, 20, 24, 32, 40, 48, 56, 64)
- Negative margins
- Space between children
- Divide utilities

## Layout Utilities

- Flexbox patterns
- Grid layouts
- Positioning
- Z-index layering
- Overflow handling

## Typography Utilities

- Font families
- Font sizes and weights
- Line heights
- Letter spacing
- Text decoration and transformation

## Color Utilities

- Text colors with opacity
- Background colors
- Border colors
- Ring colors
- Gradient backgrounds

## Effects and Filters

- Box shadows
- Opacity
- Mix blend modes
- Filters (blur, brightness, contrast, etc.)

## Transitions and Animations

- Transition properties
- Duration and timing
- Transform utilities
- Animation keyframes

## Responsive Patterns

- Breakpoint utilities
- Mobile-first design
- Container queries
- Aspect ratios

See main SKILL.md for implementation examples.
