---
learner: { username }
created: { date }
last_updated: { date }
focus: { primary_goal }
level: { level }
style: { learning_style }
tech_stacks: [{ tech_stacks }]
estimated_tutorials: { count }
---

# Personalized Learning Curriculum

## Your Profile Summary

- **Level**: {level}
- **Learning Style**: {style}
- **Primary Goal**: {goal}
- **Focus Tech Stacks**: {tech_stacks}

## Current Codebase

- **Repository**: {repo_name}
- **Primary Language**: {primary_language}
- **Framework**: {framework}
- **Architecture**: {architecture_pattern}

## Learning Path

### Phase 1: Foundation (Tutorials 1-3)

Understanding the core structure and patterns.

| #   | Topic                  | Concepts                | Priority |
| --- | ---------------------- | ----------------------- | -------- |
| 1   | Project Overview       | architecture, structure | High     |
| 2   | Core Framework Basics  | {framework}, routing    | High     |
| 3   | Data Flow Fundamentals | state, props, context   | High     |

### Phase 2: Core Concepts (Tutorials 4-6)

Deep dive into key technologies used.

| #   | Topic                  | Concepts              | Priority |
| --- | ---------------------- | --------------------- | -------- |
| 4   | State Management       | {state_lib}, patterns | Medium   |
| 5   | API Integration        | fetching, caching     | Medium   |
| 6   | Component Architecture | patterns, composition | Medium   |

### Phase 3: Advanced Topics (Tutorials 7-9)

Mastering advanced patterns and optimization.

| #   | Topic            | Concepts              | Priority |
| --- | ---------------- | --------------------- | -------- |
| 7   | Performance      | optimization, caching | Low      |
| 8   | Testing Strategy | unit, integration     | Low      |
| 9   | Error Handling   | boundaries, logging   | Low      |

### Phase 4: Mastery (Tutorial 10+)

Expert-level understanding and contribution.

| #   | Topic               | Concepts          | Priority |
| --- | ------------------- | ----------------- | -------- |
| 10  | DevOps & Deployment | CI/CD, builds     | Optional |
| 11+ | Custom Topics       | based on progress | TBD      |

## Progress Tracking

| Tutorial            | Status      | Score | Last Quiz |
| ------------------- | ----------- | ----- | --------- |
| 1. Project Overview | Not Started | -     | -         |
| 2. Core Framework   | Not Started | -     | -         |
| ...                 | ...         | ...   | ...       |

## Recommended Learning Schedule

Based on your {style} learning style:

### Daily (15-30 min)

- Review one concept from current tutorial
- Answer Socratic questions
- Try one small code exercise

### Weekly (1-2 hours)

- Complete one full tutorial
- Take quiz on previous tutorial
- Reflect on connections to codebase

### Monthly Review

- Assess curriculum progress
- Adjust priorities based on work needs
- Update learning goals

## Resources

### From Web Research

- [{framework} Official Docs](url)
- [Best Practices Guide](url)
- [Common Patterns](url)

### From This Codebase

- Key file: `src/core/...`
- Example pattern: `src/components/...`
- Reference implementation: `src/features/...`

## Notes

[Space for your personal notes and insights]

---

_Generated by coding-tutor-v2 on {date}_
_Based on codebase analysis and your learning profile_
