# Research Report: {{QUERY}}

**Generated:** {{DATE}}
**Research Level:** {{LEVEL}}
**Sources Analyzed:** {{SOURCE_COUNT}}
**Agents Used:** {{AGENT_COUNT}}
**Data Quality Score:** {{QUALITY_SCORE}}/1.0
**Coverage Score:** {{COVERAGE_SCORE}}/1.0

---

## Executive Summary

{{EXECUTIVE_SUMMARY}}

---

## Key Findings (Relevance ≥ 0.8)

{{#KEY_FINDINGS}}
### {{INDEX}}. {{FINDING_TITLE}}

{{FINDING_CONTENT}}

> **Evidence:** "{{QUOTE_OR_DATA}}"
> — [{{SOURCE_TITLE}}]({{SOURCE_URL}})

**Relevance:** {{RELEVANCE_SCORE}} | **Confidence:** {{CONFIDENCE}} | **Sources:** {{SOURCE_COUNT}}

{{/KEY_FINDINGS}}

---

## Supporting Information (0.5 ≤ Relevance < 0.8)

{{#SUPPORTING_INFO}}
- **{{FINDING_TITLE}}** ({{RELEVANCE_SCORE}})
  {{FINDING_CONTENT}}
  > Source: [{{SOURCE_TITLE}}]({{SOURCE_URL}})

{{/SUPPORTING_INFO}}

---

## Contradictions & Conflicts

{{#CONTRADICTIONS}}
### {{TOPIC}}

| Perspective | Claim | Source |
|-------------|-------|--------|
| A | {{CLAIM_A}} | [{{SOURCE_A_TITLE}}]({{SOURCE_A_URL}}) |
| B | {{CLAIM_B}} | [{{SOURCE_B_TITLE}}]({{SOURCE_B_URL}}) |

**Analysis:** {{RESOLUTION}}

{{/CONTRADICTIONS}}

{{^CONTRADICTIONS}}
*No significant contradictions were identified between sources.*
{{/CONTRADICTIONS}}

---

## Research Gaps

{{#GAPS}}
- **{{GAP_TITLE}}** (Importance: {{IMPORTANCE}})
  {{GAP_DESCRIPTION}}
  *Suggested search:* `{{SUGGESTED_QUERY}}`

{{/GAPS}}

{{^GAPS}}
*Research coverage was comprehensive with no significant gaps identified.*
{{/GAPS}}

---

## Recommendations

Based on the research findings, the following actions are recommended:

{{#RECOMMENDATIONS}}
{{INDEX}}. **{{RECOMMENDATION_TITLE}}**
   {{RECOMMENDATION_DETAIL}}

{{/RECOMMENDATIONS}}

---

## Methodology

### Research Process

| Phase | Details |
|-------|---------|
| **Planning** | Query decomposed into {{SUBTASK_COUNT}} parallel subtasks |
| **Research** | {{RESEARCH_AGENT_COUNT}} Research Agents executed in parallel |
| **Sources** | {{TOTAL_SOURCES}} total, {{UNIQUE_SOURCES}} unique sources analyzed |
| **Analysis** | Cross-referenced with relevance scoring (threshold: 0.3) |
| **Synthesis** | Findings consolidated and structured by relevance tier |

### Agent Execution Timeline

```
{{EXECUTION_TIMELINE}}
```

### Quality Assurance

- **Data Quality Score:** {{QUALITY_SCORE}}/1.0
  - Relevance Average: {{AVG_RELEVANCE}}
  - Source Credibility: {{SOURCE_CREDIBILITY}}
  - Recency Score: {{RECENCY_SCORE}}
  - Cross-Reference Rate: {{CROSS_REF_RATE}}

- **Coverage Score:** {{COVERAGE_SCORE}}/1.0
  - Subtasks Completed: {{COMPLETED_SUBTASKS}}/{{TOTAL_SUBTASKS}}
  - Gaps Identified: {{GAP_COUNT}}
  - Contradictions Resolved: {{RESOLVED_CONTRADICTIONS}}/{{TOTAL_CONTRADICTIONS}}

---

## Full Source List

### High-Relevance Sources (≥ 0.8)

{{#HIGH_SOURCES}}
{{INDEX}}. [{{TITLE}}]({{URL}}) — Relevance: {{SCORE}}
{{/HIGH_SOURCES}}

### Medium-Relevance Sources (0.5-0.8)

{{#MEDIUM_SOURCES}}
{{INDEX}}. [{{TITLE}}]({{URL}}) — Relevance: {{SCORE}}
{{/MEDIUM_SOURCES}}

### Supporting Sources (<0.5)

{{#LOW_SOURCES}}
{{INDEX}}. [{{TITLE}}]({{URL}}) — Relevance: {{SCORE}}
{{/LOW_SOURCES}}

---

## Appendix: Raw Agent Outputs

<details>
<summary>Click to expand Planning Agent output</summary>

```json
{{PLANNING_OUTPUT}}
```

</details>

<details>
<summary>Click to expand Research Agent outputs</summary>

{{#RESEARCH_OUTPUTS}}
### Research Agent {{INDEX}}
```json
{{OUTPUT}}
```

{{/RESEARCH_OUTPUTS}}

</details>

<details>
<summary>Click to expand Analysis Agent output</summary>

```json
{{ANALYSIS_OUTPUT}}
```

</details>

---

*This report was generated by Deep Researcher v2.0 Multi-Agent System*
*Inspired by [Anthropic's Multi-Agent Research System](https://www.anthropic.com/engineering/multi-agent-research-system) and [SkyworkAI/DeepResearchAgent](https://github.com/SkyworkAI/DeepResearchAgent)*
