---
name: kali-pentester
description: Professional web application penetration testing using Kali Linux Docker container. Use when performing security assessments, vulnerability scanning, OWASP testing, or white hat pentesting on target URLs. Supports docker exec and SSH access to Kali, OWASP Top 10 2025 compliance, full Kali tool suite, and executive-level HTML/Markdown reporting with remediation guidance.
---

# Kali Pentester v1.1

Professional penetration testing workflow with self-upgrade capability, OWASP compliance, Kali Linux Docker integration, and executive-level reporting.

## Overview

This skill automates professional-grade web application security testing using a Kali Linux Docker container. It performs OWASP Top 10 2025 compliant testing at white hat level and generates comprehensive executive reports.

**Platform:** macOS/Linux (requires Docker or SSH access to Kali)

## Workflow

### Phase 0: Self-Upgrade (Mandatory)

Before any testing, update knowledge on latest threats:

```
Use Task tool with subagent_type='claude-code-guide' to learn latest:
- Security testing best practices
- New vulnerability patterns
- Updated tool capabilities
```

Also perform WebSearch for:
- `OWASP Top 10 2025 latest vulnerabilities`
- `CVE 2025 critical web application exploits`
- `Kali Linux 2025 new pentesting tools`

### Phase 1: Environment Setup

#### 1.1 Connection Method

Ask user to select connection method:
- **Docker exec** (local): `docker exec -it <container> /bin/bash`
- **SSH** (remote): `ssh user@host -p port`

#### 1.2 Verify Kali Container

```bash
node scripts/kali_connector.js setup docker <container-name>
node scripts/kali_connector.js test
```

### Phase 2: Scope Definition

Ask user for:
1. **Target URL**: Full URL to test
2. **Test Level**: See table below
3. **Authorization**: Confirm written authorization exists
4. **Scope Limits**: Out-of-scope areas

| Level | Description | Tools Used |
|-------|-------------|------------|
| Recon | Information gathering only | Nmap, whois, dig |
| Basic | OWASP Top 10 automated scan | OWASP-ZAP, Nikto |
| Standard | Full vulnerability assessment | + SQLmap, XSStrike |
| Advanced | Exploitation attempts | + Metasploit, Burp |
| Expert | Full white hat pentest | All tools + manual |

### Phase 3-6: Scanning & Testing

Reference: `references/owasp_checklist.md` and `references/tool_guide.md`

```bash
# Quick scan
node scripts/vulnerability_scanner.js quick <url>

# Full OWASP scan
node scripts/vulnerability_scanner.js full <url>

# Specific OWASP category
node scripts/vulnerability_scanner.js owasp <url> --category A04
```

### Phase 7: Professional Reporting

Generate executive-level reports with full remediation guidance.

#### 7.1 List Available Scans

```bash
node scripts/report_generator.js list
```

#### 7.2 Generate HTML Report (Recommended)

```bash
# From latest scan
node scripts/report_generator.js latest --format html

# From specific scan
node scripts/report_generator.js generate scan_12345.json --format html
```

#### 7.3 Generate Markdown Report

```bash
node scripts/report_generator.js latest --format md
```

## Report Features

Professional reports include:

### Executive Summary
- Security Score (0-100)
- Risk Rating (Critical/High/Medium/Low)
- Findings breakdown by severity
- Visual risk meter

### Findings Detail
For each vulnerability:
- **Severity Classification** (CVSS-aligned)
- **OWASP Category Mapping** (A01-A10)
- **CWE Identification**
- **Business Impact Analysis**
- **Detailed Remediation Steps**
- **Evidence/Proof of Concept**
- **Reference Links**

### Compliance
- OWASP Top 10:2025 mapping
- CWE classification
- Industry-standard severity ratings

## Quick Start

```bash
# 1. Setup connection
node scripts/kali_connector.js setup docker kali

# 2. Test connection
node scripts/kali_connector.js test

# 3. Run scan
node scripts/vulnerability_scanner.js full http://target.com

# 4. Generate professional report
node scripts/report_generator.js latest --format html
```

## Scripts Reference

| Script | Purpose |
|--------|---------|
| `kali_connector.js` | Docker/SSH connection management |
| `vulnerability_scanner.js` | Automated OWASP scanning |
| `report_generator.js` | Professional HTML/MD reports |

## Report Output

Reports are saved to: `~/.kali-pentester/results/`
- `scan_*.json` - Raw scan data
- `report_*.html` - Professional HTML report
- `report_*.md` - Markdown report

## Remediation Database

Built-in remediation guidance for:
- Missing security headers (CSP, HSTS, X-Frame-Options)
- SSL/TLS configuration issues
- SQL Injection vulnerabilities
- Cross-Site Scripting (XSS)
- Server-Side Request Forgery (SSRF)
- Information disclosure
- Directory listing
- Weak cryptographic configurations

## Safety Requirements

1. **Written Authorization Required**: Never test without explicit permission
2. **Scope Boundaries**: Respect defined scope limits
3. **Rate Limiting**: Use appropriate delays to avoid DoS
4. **Data Handling**: Securely handle any sensitive data discovered
5. **Disclosure**: Follow responsible disclosure practices

## Sources

- [OWASP Top 10:2025](https://owasp.org/Top10/2025/)
- [CISA KEV Catalog](https://www.cisa.gov/known-exploited-vulnerabilities-catalog)
- [Kali Linux Tools](https://www.kali.org/tools/)
- [CWE Database](https://cwe.mitre.org/)
- [CVE Details](https://www.cvedetails.com/)
