# OWASP Top 10:2025 Testing Checklist

Systematic testing guide for each OWASP Top 10:2025 category.

## A01:2025 - Broken Access Control

**Risk:** Unauthorized access to resources and functionality.

### Tests

| Test | Command/Tool | What to Look For |
|------|--------------|------------------|
| IDOR | `ffuf -u URL/api/users/FUZZ -w ids.txt` | Access to other users' data |
| Path Traversal | `ffuf -u URL/file?path=FUZZ -w lfi.txt` | Reading system files |
| Privilege Escalation | Manual testing | Regular user accessing admin functions |
| Force Browsing | `dirb URL /usr/share/wordlists/dirb/common.txt` | Unprotected admin pages |
| CORS Misconfiguration | `curl -H "Origin: evil.com" URL` | `Access-Control-Allow-Origin: *` |

### Kali Commands

```bash
# Directory bruteforce
gobuster dir -u <url> -w /usr/share/wordlists/dirbuster/directory-list-2.3-medium.txt

# IDOR testing
ffuf -u <url>/api/user/FUZZ -w <(seq 1 1000) -mc 200

# JWT testing
jwt_tool <token> -T
```

## A02:2025 - Cryptographic Failures

**Risk:** Exposure of sensitive data due to weak cryptography.

### Tests

| Test | Command/Tool | What to Look For |
|------|--------------|------------------|
| SSL/TLS Config | `sslyze --regular URL` | Weak ciphers, outdated protocols |
| Certificate Issues | `sslscan URL` | Expired, self-signed, wrong domain |
| Data in Transit | `mitmproxy` | Unencrypted sensitive data |
| Weak Hashing | Code review | MD5, SHA1 for passwords |

### Kali Commands

```bash
# SSL/TLS analysis
sslscan <host>
testssl.sh <url>

# Check cipher suites
nmap --script ssl-enum-ciphers -p 443 <host>
```

## A03:2025 - Software Supply Chain Failures (NEW)

**Risk:** Vulnerabilities introduced through dependencies and build pipeline.

### Tests

| Test | Command/Tool | What to Look For |
|------|--------------|------------------|
| Dependency Check | `dependency-check` | Known CVEs in libraries |
| SCA Scanning | `retire.js` | Outdated JavaScript libraries |
| Container Scan | `trivy image:tag` | Vulnerable base images |
| SBOM Analysis | `syft` | Complete dependency tree |

### Kali Commands

```bash
# JavaScript dependency check
retire --js --jspath /path/to/js

# Python dependencies
pip-audit

# Container scanning
trivy image <image>
```

## A04:2025 - Injection

**Risk:** Untrusted data sent to interpreter as command/query.

### Tests

| Test | Command/Tool | What to Look For |
|------|--------------|------------------|
| SQL Injection | `sqlmap -u URL` | Database errors, data extraction |
| XSS | `xsstrike -u URL` | Script execution in browser |
| Command Injection | Manual | System command output |
| LDAP Injection | Manual | Directory traversal |
| Template Injection | `tplmap -u URL` | SSTI vulnerabilities |

### Kali Commands

```bash
# SQL Injection
sqlmap -u "<url>?id=1" --batch --risk=3 --level=5 --dbs

# XSS testing
python3 /usr/share/xsstrike/xsstrike.py -u "<url>?q=test"

# Command injection
commix -u "<url>?cmd=test"

# Template injection
tplmap -u "<url>?name=test"
```

## A05:2025 - Security Misconfiguration

**Risk:** Insecure default configurations, incomplete setups.

### Tests

| Test | Command/Tool | What to Look For |
|------|--------------|------------------|
| Default Credentials | `hydra`, `medusa` | admin:admin, root:root |
| Directory Listing | Browser | Open directory indexes |
| Error Messages | Manual | Stack traces, version info |
| Security Headers | `curl -I URL` | Missing CSP, X-Frame-Options |
| Unnecessary Services | `nmap -sV` | Open ports, unused services |

### Kali Commands

```bash
# Check security headers
curl -I <url> | grep -E "(X-Frame|X-Content|Content-Security|Strict-Transport)"

# Nikto for misconfigurations
nikto -h <url>

# Default credential testing
hydra -L users.txt -P passwords.txt <host> http-post-form "/login:user=^USER^&pass=^PASS^:Invalid"
```

## A06:2025 - Insecure Design

**Risk:** Flaws in design and architecture, missing security controls.

### Tests

| Test | Command/Tool | What to Look For |
|------|--------------|------------------|
| Business Logic | Manual | Workflow bypass, price manipulation |
| Rate Limiting | `wfuzz` | Missing rate limits on sensitive actions |
| Threat Modeling | Review | Missing security requirements |
| Trust Boundaries | Manual | Client-side validation only |

### Kali Commands

```bash
# Rate limit testing
wfuzz -z range,1-100 -u "<url>/api/action" -H "Cookie: session=xxx"

# Business logic testing
# Manual testing with Burp Suite proxy
```

## A07:2025 - Identification and Authentication Failures

**Risk:** Weak authentication mechanisms, credential exposure.

### Tests

| Test | Command/Tool | What to Look For |
|------|--------------|------------------|
| Brute Force | `hydra` | Weak password policies |
| Session Fixation | Manual | Session ID not regenerated |
| Session Hijacking | `mitmproxy` | Session tokens in URL |
| Password Reset | Manual | Predictable tokens, email enumeration |
| 2FA Bypass | Manual | Missing verification steps |

### Kali Commands

```bash
# Password brute force
hydra -l admin -P /usr/share/wordlists/rockyou.txt <host> http-post-form "/login:username=^USER^&password=^PASS^:Invalid"

# Session analysis
# Use Burp Suite to analyze session tokens
```

## A08:2025 - Software and Data Integrity Failures

**Risk:** Code/data integrity violations, insecure CI/CD.

### Tests

| Test | Command/Tool | What to Look For |
|------|--------------|------------------|
| Insecure Deserialization | `ysoserial` | Object injection |
| CI/CD Security | Review | Unsigned deployments |
| Subresource Integrity | Browser | Missing SRI hashes |
| Auto-Update | Manual | Unsigned updates |

### Kali Commands

```bash
# Deserialization testing
java -jar ysoserial.jar <payload> <command>

# Check SRI in HTML
curl <url> | grep -E "integrity="
```

## A09:2025 - Security Logging and Monitoring Failures

**Risk:** Insufficient logging, missing alerting.

### Tests

| Test | Command/Tool | What to Look For |
|------|--------------|------------------|
| Log Injection | Manual | Unescaped user input in logs |
| Audit Trail | Review | Missing security events |
| Alerting | Manual | No alerts on suspicious activity |
| Log Storage | Review | Logs only local, easily deleted |

## A10:2025 - Server-Side Request Forgery (SSRF)

**Risk:** Server making requests to unintended locations.

### Tests

| Test | Command/Tool | What to Look For |
|------|--------------|------------------|
| Internal Network | `curl` | Access to 127.0.0.1, 10.x, 192.168.x |
| Cloud Metadata | Manual | Access to 169.254.169.254 |
| Protocol Smuggling | Manual | file://, gopher://, dict:// |
| Bypass Filters | `ssrfmap` | Blacklist bypass techniques |

### Kali Commands

```bash
# SSRF testing
curl "<url>?fetch=http://127.0.0.1:22"
curl "<url>?fetch=http://169.254.169.254/latest/meta-data/"

# SSRFmap tool
python3 ssrfmap.py -r request.txt -p url -m readfiles
```

## Quick Reference: Severity Ratings

| Severity | Examples | CVSS Range |
|----------|----------|------------|
| Critical | RCE, Auth Bypass, SQLi with data exfil | 9.0-10.0 |
| High | Stored XSS, IDOR, SSRF to internal | 7.0-8.9 |
| Medium | Reflected XSS, Info Disclosure | 4.0-6.9 |
| Low | Missing headers, Version disclosure | 0.1-3.9 |
| Info | Best practice recommendations | N/A |
