---
name: kali-pentester-v2
description: Ultrathink-powered expert penetration testing with hierarchical multi-agent orchestration. Performs OWASP Top 10 2025, LLM/AI security, supply chain audits via 5+ parallel agents with extended thinking. Uses Kali Linux Docker/SSH, generates executive HTML/MD/JSON reports. Triggers on "pentest", "security assessment", "vulnerability audit", "OWASP scan", "LLM security test", or "supply chain audit".
---

# Kali Pentester v2.0 - Ultrathink Expert Edition

Hierarchical multi-agent penetration testing system with extended thinking for deep security analysis.

## Architecture

```
Orchestrator (Opus + Ultrathink)
    │
    ├─► Planning Agent ──► Scope decomposition & threat modeling
    │
    ├─► Intel Agents (PARALLEL) ──► Threat intelligence
    │       ├── CVE Monitor (haiku)
    │       ├── Tech Threats (haiku)
    │       └── Compliance Intel (haiku)
    │
    ├─► Scan Agents (PARALLEL) ──► Security scanning
    │       ├── Web/API Scanner (sonnet)
    │       ├── LLM Security Tester (opus + ultrathink)
    │       ├── Supply Chain Auditor (sonnet)
    │       ├── Injection Tester (sonnet)
    │       └── Config Auditor (sonnet)
    │
    ├─► Exploit Analyst (Opus + Ultrathink) ──► Deep vulnerability analysis
    │
    ├─► Synthesis Agent ──► Report generation (MD/HTML/JSON)
    │
    └─► Self-Upgrade ──► Capture learnings
```

## Depth Levels

| Level | Agents | Analysis | Ultrathink | Report |
|-------|--------|----------|------------|--------|
| 1 | 2 | Basic | Off | Quick |
| 2 | 3 | Standard | Exploit only | Standard |
| 3 | 4 | Detailed | Critical | Detailed |
| 4 | 5 | Deep | All phases | Expert |
| 5 | 6+ | Exhaustive | Maximum | Executive |

## Workflow

### Phase 0: Self-Upgrade (Mandatory)

```
Task(
  subagent_type='claude-code-guide',
  prompt='Get latest on: OWASP 2025 changes, LLM security patterns, supply chain threats',
  description='Upgrade security knowledge'
)

WebSearch(query='CVE 2025 critical web vulnerabilities')
WebSearch(query='OWASP Top 10 2025 A03 Supply Chain')
WebSearch(query='LLM prompt injection attacks 2025')
```

### Phase 1: Environment & Scope

Verify Kali connection and define scope:

```bash
node scripts/kali_connector.js setup docker <container>
node scripts/kali_connector.js test
```

Ask user for:
1. Target URL/IP
2. Test level (1-5)
3. Written authorization confirmation
4. Scope exclusions

### Phase 2: Threat Intelligence (PARALLEL)

Spawn 3 Intel Agents in ONE message:

```
Task(subagent_type='Explore', prompt='Search CVE alerts for target tech stack...', description='Intel: CVE', model='haiku')
Task(subagent_type='Explore', prompt='Search technology-specific attack patterns...', description='Intel: Tech', model='haiku')
Task(subagent_type='Explore', prompt='Search OWASP 2025, compliance updates...', description='Intel: Compliance', model='haiku')
```

### Phase 3: Security Scanning (PARALLEL)

Spawn 5 Scan Agents in ONE message with ultrathink for LLM testing:

```
Task(subagent_type='general-purpose', prompt='OWASP Top 10 2025 web/API scan...', description='Scan: Web/API', model='sonnet')
Task(subagent_type='general-purpose', prompt='LLM security: prompt injection, jailbreak, data leakage. Use extended thinking for complex analysis...', description='Scan: LLM Security', model='opus')
Task(subagent_type='general-purpose', prompt='Supply chain: dependencies, SBOM, container vulnerabilities...', description='Scan: Supply Chain', model='sonnet')
Task(subagent_type='general-purpose', prompt='Injection testing: SQLi, XSS, Command, Template injection...', description='Scan: Injection', model='sonnet')
Task(subagent_type='general-purpose', prompt='Config audit: headers, SSL/TLS, misconfigurations...', description='Scan: Config', model='sonnet')
```

### Phase 4: Deep Analysis (Ultrathink)

Exploit Analyst with extended thinking:

```
Task(
  subagent_type='general-purpose',
  prompt='Deep vulnerability analysis with extended thinking:
    1. Analyze exploitation paths and chains
    2. Calculate CVSS scores with attack complexity
    3. Assess business impact and data exposure risk
    4. Identify false positives through reasoning
    5. Prioritize by exploitability and impact

    Use thorough step-by-step reasoning before conclusions.',
  description='Exploit analysis with ultrathink',
  model='opus'
)
```

### Phase 5: Synthesis & Reporting

Generate comprehensive reports:

```bash
# Generate all formats
python3 scripts/report_generator.py --input ./results --format all --output ./reports
```

**Report includes:**
- Executive Summary with Risk Score (0-100)
- CVSS-weighted severity analysis
- OWASP 2025 compliance mapping
- LLM security findings
- Supply chain vulnerabilities
- Remediation timeline with SLAs
- Evidence and proof of concept

### Phase 6: Self-Upgrade

Capture learnings for future assessments:

```bash
python3 scripts/self_upgrade.py --findings ./results
```

## OWASP Top 10 2025 Coverage

| Category | Agent | Tools |
|----------|-------|-------|
| A01: Broken Access Control | Web/API Scanner | ffuf, gobuster, jwt_tool |
| A02: Security Misconfiguration | Config Auditor | nikto, nmap, curl |
| A03: Supply Chain Failures (NEW) | Supply Chain Auditor | trivy, dependency-check |
| A04: Cryptographic Failures | Config Auditor | sslscan, testssl.sh |
| A05: Injection | Injection Tester | sqlmap, xsstrike, commix |
| A06: Insecure Design | Exploit Analyst | Manual + ultrathink |
| A07: Auth Failures | Web/API Scanner | hydra, burp |
| A08: Integrity Failures | Supply Chain Auditor | sigstore, SBOM |
| A09: Logging Failures | Config Auditor | Log analysis |
| A10: Exceptional Conditions (NEW) | Exploit Analyst | Error handling tests |

## LLM/AI Security Testing

Specialized testing for AI systems:

| Test | Description | Tool/Method |
|------|-------------|-------------|
| Prompt Injection | Direct/indirect injection | Garak, manual |
| Jailbreak | Safety bypass attempts | LLMFuzzer |
| Data Leakage | Training data extraction | Targeted prompts |
| Model DoS | Resource exhaustion | Stress testing |
| Output Manipulation | Hallucination exploitation | Adversarial inputs |

## Supply Chain Security

| Check | Tool | Output |
|-------|------|--------|
| Dependency CVEs | trivy, pip-audit | Vulnerability list |
| SBOM Generation | syft, cyclonedx | CycloneDX/SPDX |
| Container Security | trivy image | Image vulnerabilities |
| Build Pipeline | Manual review | CI/CD risks |

## Scripts Reference

| Script | Purpose |
|--------|---------|
| `kali_connector.py` | Docker/SSH connection management |
| `orchestrator.py` | Multi-agent coordination |
| `scanner.py` | Automated OWASP/LLM scanning |
| `report_generator.py` | HTML/MD/JSON reports |
| `self_upgrade.py` | Learning capture |

## Kali Tool Integration

```bash
# Quick OWASP scan
python3 scripts/scanner.py quick --target <url>

# Full Level 5 audit
python3 scripts/scanner.py full --target <url> --level 5

# LLM security test
python3 scripts/scanner.py llm --target <api_endpoint>

# Supply chain audit
python3 scripts/scanner.py supply-chain --path ./project
```

## Resources

- [Agent Prompts](references/agent_prompts.md) - All agent templates
- [OWASP 2025 Checklist](references/owasp_2025.md) - Testing checklist
- [LLM Security Guide](references/llm_security.md) - AI testing guide
- [Tool Reference](references/tool_guide.md) - Kali tool commands

## Safety Requirements

1. **Written Authorization Required** - Never test without permission
2. **Scope Boundaries** - Respect defined limits
3. **Rate Limiting** - Avoid DoS conditions
4. **Responsible Disclosure** - Follow disclosure practices
5. **Data Handling** - Securely handle discovered data

## Trigger Phrases

- "pentest level X" / "침투 테스트 레벨 X"
- "security assessment" / "보안 평가"
- "OWASP 2025 audit" / "OWASP 감사"
- "LLM security test" / "LLM 보안 테스트"
- "supply chain audit" / "공급망 감사"
- "ultrathink security analysis" / "심층 보안 분석"
